/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SparkHashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.optimizer.physical.GenMRSkewJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.physical.LocalMapJoinProcFactory;
import org.apache.hadoop.hive.ql.optimizer.physical.MapJoinResolver;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.GenSparkUtils;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ConditionalResolverSkewJoin;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.HashTableDummyDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SparkEdgeProperty;
import org.apache.hadoop.hive.ql.plan.SparkHashTableSinkDesc;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class GenSparkSkewJoinProcessor {
    private static final Log LOG = LogFactory.getLog((String)GenSparkSkewJoinProcessor.class.getName());

    private GenSparkSkewJoinProcessor() {
    }

    /*
     * WARNING - void declaration
     */
    public static void processSkewJoin(JoinOperator joinOp, Task<? extends Serializable> currTask, ReduceWork reduceWork, ParseContext parseCtx) throws SemanticException {
        int i;
        SparkWork currentWork = (SparkWork)((SparkTask)currTask).getWork();
        if (currentWork.getChildren(reduceWork).size() > 0) {
            LOG.warn((Object)"Skip runtime skew join as the ReduceWork has child work and hasn't been split.");
            return;
        }
        List<Task<Serializable>> children = currTask.getChildTasks();
        Task<Serializable> child = children != null && children.size() == 1 ? children.get(0) : null;
        Path baseTmpDir = parseCtx.getContext().getMRTmpPath();
        JoinDesc joinDescriptor = (JoinDesc)joinOp.getConf();
        Map<Byte, List<ExprNodeDesc>> joinValues = joinDescriptor.getExprs();
        int numAliases = joinValues.size();
        HashMap<Byte, Path> bigKeysDirMap = new HashMap<Byte, Path>();
        HashMap<Byte, Map<Byte, Path>> smallKeysDirMap = new HashMap<Byte, Map<Byte, Path>>();
        HashMap<Byte, Path> skewJoinJobResultsDir = new HashMap<Byte, Path>();
        Byte[] tags = joinDescriptor.getTagOrder();
        for (int i2 = 0; i2 < numAliases; ++i2) {
            Byte alias = tags[i2];
            bigKeysDirMap.put(alias, GenMRSkewJoinProcessor.getBigKeysDir(baseTmpDir, alias));
            HashMap<Byte, Path> smallKeysMap = new HashMap<Byte, Path>();
            smallKeysDirMap.put(alias, smallKeysMap);
            for (Byte src2 : tags) {
                if (src2.equals(alias)) continue;
                smallKeysMap.put(src2, GenMRSkewJoinProcessor.getSmallKeysDir(baseTmpDir, alias, src2));
            }
            skewJoinJobResultsDir.put(alias, GenMRSkewJoinProcessor.getBigKeysSkewJoinResultDir(baseTmpDir, alias));
        }
        joinDescriptor.setHandleSkewJoin(true);
        joinDescriptor.setBigKeysDirMap(bigKeysDirMap);
        joinDescriptor.setSmallKeysDirMap(smallKeysDirMap);
        joinDescriptor.setSkewKeyDefinition(HiveConf.getIntVar(parseCtx.getConf(), HiveConf.ConfVars.HIVESKEWJOINKEY));
        TableDesc keyTblDesc = (TableDesc)reduceWork.getKeyDesc().clone();
        List<String> joinKeys = Utilities.getColumnNames(keyTblDesc.getProperties());
        List<String> joinKeyTypes = Utilities.getColumnTypes(keyTblDesc.getProperties());
        HashMap<Byte, TableDesc> tableDescList = new HashMap<Byte, TableDesc>();
        HashMap<Byte, RowSchema> rowSchemaList = new HashMap<Byte, RowSchema>();
        HashMap<Byte, List<ExprNodeDesc>> newJoinValues = new HashMap<Byte, List<ExprNodeDesc>>();
        HashMap<Byte, List<ExprNodeDesc>> newJoinKeys = new HashMap<Byte, List<ExprNodeDesc>>();
        ArrayList<TableDesc> newJoinValueTblDesc = new ArrayList<TableDesc>();
        for (i = 0; i < tags.length; ++i) {
            newJoinValueTblDesc.add(null);
        }
        for (i = 0; i < numAliases; ++i) {
            void var27_35;
            int k;
            Byte alias = tags[i];
            List<ExprNodeDesc> valueCols = joinValues.get(alias);
            String colNames = "";
            String string = "";
            int columnSize = valueCols.size();
            ArrayList<ExprNodeColumnDesc> newValueExpr = new ArrayList<ExprNodeColumnDesc>();
            ArrayList<ExprNodeColumnDesc> newKeyExpr = new ArrayList<ExprNodeColumnDesc>();
            ArrayList<ColumnInfo> columnInfos = new ArrayList<ColumnInfo>();
            boolean first = true;
            for (k = 0; k < columnSize; ++k) {
                void var27_39;
                TypeInfo type = valueCols.get(k).getTypeInfo();
                String newColName = i + "_VALUE_" + k;
                ColumnInfo columnInfo = new ColumnInfo(newColName, type, alias.toString(), false);
                columnInfos.add(columnInfo);
                newValueExpr.add(new ExprNodeColumnDesc(columnInfo.getType(), columnInfo.getInternalName(), columnInfo.getTabAlias(), false));
                if (!first) {
                    void var27_37;
                    colNames = colNames + ",";
                    String string2 = (String)var27_37 + ",";
                }
                first = false;
                colNames = colNames + newColName;
                String string3 = (String)var27_39 + valueCols.get(k).getTypeString();
            }
            for (k = 0; k < joinKeys.size(); ++k) {
                void var27_42;
                if (!first) {
                    colNames = colNames + ",";
                    String string4 = (String)var27_35 + ",";
                }
                first = false;
                colNames = colNames + joinKeys.get(k);
                String string5 = (String)var27_42 + joinKeyTypes.get(k);
                ColumnInfo columnInfo = new ColumnInfo(joinKeys.get(k), TypeInfoFactory.getPrimitiveTypeInfo(joinKeyTypes.get(k)), alias.toString(), false);
                columnInfos.add(columnInfo);
                newKeyExpr.add(new ExprNodeColumnDesc(columnInfo.getType(), columnInfo.getInternalName(), columnInfo.getTabAlias(), false));
            }
            newJoinValues.put(alias, newValueExpr);
            newJoinKeys.put(alias, newKeyExpr);
            tableDescList.put(alias, Utilities.getTableDesc(colNames, (String)var27_35));
            rowSchemaList.put(alias, new RowSchema(columnInfos));
            String valueColNames = "";
            String valueColTypes = "";
            first = true;
            for (int k2 = 0; k2 < columnSize; ++k2) {
                String newColName = i + "_VALUE_" + k2;
                if (!first) {
                    valueColNames = valueColNames + ",";
                    valueColTypes = valueColTypes + ",";
                }
                valueColNames = valueColNames + newColName;
                valueColTypes = valueColTypes + valueCols.get(k2).getTypeString();
                first = false;
            }
            newJoinValueTblDesc.set((byte)i, Utilities.getTableDesc(valueColNames, valueColTypes));
        }
        joinDescriptor.setSkewKeysValuesTables(tableDescList);
        joinDescriptor.setKeyTableDesc(keyTblDesc);
        HashMap<Path, Task<? extends Serializable>> bigKeysDirToTaskMap = new HashMap<Path, Task<? extends Serializable>>();
        ArrayList<Serializable> listWorks = new ArrayList<Serializable>();
        ArrayList<Task<? extends Serializable>> listTasks = new ArrayList<Task<? extends Serializable>>();
        for (int i3 = 0; i3 < numAliases - 1; ++i3) {
            int j;
            Byte by = tags[i3];
            HiveConf hiveConf = new HiveConf(parseCtx.getConf(), GenSparkSkewJoinProcessor.class);
            SparkWork sparkWork = new SparkWork(parseCtx.getConf().getVar(HiveConf.ConfVars.HIVEQUERYID));
            Task<SparkWork> skewJoinMapJoinTask = TaskFactory.get(sparkWork, hiveConf, new Task[0]);
            skewJoinMapJoinTask.setFetchSource(currTask.isFetchSource());
            Operator[] parentOps = new TableScanOperator[tags.length];
            for (int k = 0; k < tags.length; ++k) {
                TableScanOperator ts = GenMapRedUtils.createTemporaryTableScanOperator((RowSchema)rowSchemaList.get((byte)k));
                ts.setTableDesc((TableDesc)tableDescList.get((byte)k));
                parentOps[k] = ts;
            }
            String dumpFilePrefix = "mapfile" + PlanUtils.getCountForMapJoinDumpFilePrefix();
            MapJoinDesc mapJoinDescriptor = new MapJoinDesc(newJoinKeys, keyTblDesc, newJoinValues, newJoinValueTblDesc, newJoinValueTblDesc, joinDescriptor.getOutputColumnNames(), i3, joinDescriptor.getConds(), joinDescriptor.getFilters(), joinDescriptor.getNoOuterJoin(), dumpFilePrefix);
            mapJoinDescriptor.setTagOrder(tags);
            mapJoinDescriptor.setHandleSkewJoin(false);
            mapJoinDescriptor.setNullSafes(joinDescriptor.getNullSafes());
            MapJoinOperator mapJoinOp = (MapJoinOperator)OperatorFactory.getAndMakeChild(mapJoinDescriptor, null, parentOps);
            ArrayList reducerList = new ArrayList();
            reducerList.add(reduceWork.getReducer());
            Operator<?> reducer = Utilities.cloneOperatorTree(parseCtx.getConf(), reducerList).get(0);
            Preconditions.checkArgument(reducer instanceof JoinOperator, "Reducer should be join operator, but actually is " + reducer.getName());
            JoinOperator cloneJoinOp = (JoinOperator)reducer;
            List<Operator<? extends OperatorDesc>> childOps = cloneJoinOp.getChildOperators();
            for (Operator<OperatorDesc> operator : childOps) {
                operator.replaceParent(cloneJoinOp, mapJoinOp);
            }
            mapJoinOp.setChildOperators(childOps);
            GenSparkSkewJoinProcessor.setMemUsage(mapJoinOp, skewJoinMapJoinTask, parseCtx);
            MapWork bigMapWork = null;
            Map map = (Map)smallKeysDirMap.get(by);
            for (j = 0; j < tags.length; ++j) {
                Path path;
                MapWork mapWork = PlanUtils.getMapRedWork().getMapWork();
                sparkWork.add(mapWork);
                boolean mapperCannotSpanPartns = parseCtx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_MAPPER_CANNOT_SPAN_MULTIPLE_PARTITIONS);
                mapWork.setMapperCannotSpanPartns(mapperCannotSpanPartns);
                Operator tableScan = parentOps[j];
                String alias = tags[j].toString();
                ArrayList<String> aliases = new ArrayList<String>();
                aliases.add(alias);
                if (j == i3) {
                    path = (Path)bigKeysDirMap.get(tags[j]);
                    bigKeysDirToTaskMap.put(path, skewJoinMapJoinTask);
                    bigMapWork = mapWork;
                } else {
                    path = (Path)map.get(tags[j]);
                }
                mapWork.getPathToAliases().put(path.toString(), aliases);
                mapWork.getAliasToWork().put(alias, tableScan);
                PartitionDesc partitionDesc = new PartitionDesc((TableDesc)tableDescList.get(tags[j]), null);
                mapWork.getPathToPartitionInfo().put(path.toString(), partitionDesc);
                mapWork.getAliasToPartnInfo().put(alias, partitionDesc);
                mapWork.setNumMapTasks(HiveConf.getIntVar(hiveConf, HiveConf.ConfVars.HIVESKEWJOINMAPJOINNUMMAPTASK));
                mapWork.setMinSplitSize(HiveConf.getLongVar(hiveConf, HiveConf.ConfVars.HIVESKEWJOINMAPJOINMINSPLIT));
                mapWork.setInputformat(HiveInputFormat.class.getName());
                mapWork.setName("Map " + GenSparkUtils.getUtils().getNextSeqNumber());
            }
            Preconditions.checkArgument(bigMapWork != null, "Haven't identified big dir MapWork");
            for (BaseWork work : sparkWork.getRoots()) {
                Preconditions.checkArgument(work instanceof MapWork, "All root work should be MapWork, but got " + work.getClass().getSimpleName());
                if (work == bigMapWork) continue;
                sparkWork.connect(work, bigMapWork, new SparkEdgeProperty(0L));
            }
            for (j = 0; j < tags.length; ++j) {
                if (j == i3) continue;
                GenSparkSkewJoinProcessor.insertSHTS(tags[j], (TableScanOperator)parentOps[j], bigMapWork);
            }
            listWorks.add(skewJoinMapJoinTask.getWork());
            listTasks.add(skewJoinMapJoinTask);
        }
        if (children != null) {
            for (Task task : listTasks) {
                for (Task<Serializable> oldChild : children) {
                    task.addDependentTask(oldChild);
                }
            }
        }
        if (child != null) {
            currTask.removeDependentTask(child);
            listTasks.add(child);
            listWorks.add(child.getWork());
        }
        ConditionalResolverSkewJoin.ConditionalResolverSkewJoinCtx context = new ConditionalResolverSkewJoin.ConditionalResolverSkewJoinCtx(bigKeysDirToTaskMap, child);
        ConditionalWork conditionalWork = new ConditionalWork(listWorks);
        ConditionalTask cndTsk = (ConditionalTask)TaskFactory.get(conditionalWork, parseCtx.getConf(), new Task[0]);
        cndTsk.setListTasks(listTasks);
        cndTsk.setResolver(new ConditionalResolverSkewJoin());
        cndTsk.setResolverCtx(context);
        currTask.setChildTasks(new ArrayList<Task<? extends Serializable>>());
        currTask.addDependentTask(cndTsk);
    }

    private static void insertSHTS(byte tag, TableScanOperator tableScan, MapWork bigMapWork) {
        Preconditions.checkArgument(tableScan.getChildOperators().size() == 1 && tableScan.getChildOperators().get(0) instanceof MapJoinOperator);
        HashTableDummyDesc desc = new HashTableDummyDesc();
        HashTableDummyOperator dummyOp = (HashTableDummyOperator)OperatorFactory.get(desc, new Operator[0]);
        ((HashTableDummyDesc)dummyOp.getConf()).setTbl(tableScan.getTableDesc());
        MapJoinOperator mapJoinOp = (MapJoinOperator)tableScan.getChildOperators().get(0);
        mapJoinOp.replaceParent(tableScan, dummyOp);
        ArrayList<Operator<? extends OperatorDesc>> mapJoinChildren = new ArrayList<Operator<? extends OperatorDesc>>();
        mapJoinChildren.add(mapJoinOp);
        dummyOp.setChildOperators(mapJoinChildren);
        bigMapWork.addDummyOp(dummyOp);
        MapJoinDesc mjDesc = (MapJoinDesc)mapJoinOp.getConf();
        mjDesc.resetOrder();
        SparkHashTableSinkDesc hashTableSinkDesc = new SparkHashTableSinkDesc(mjDesc);
        SparkHashTableSinkOperator hashTableSinkOp = (SparkHashTableSinkOperator)OperatorFactory.get(hashTableSinkDesc, new Operator[0]);
        int[] valueIndex = mjDesc.getValueIndex(tag);
        if (valueIndex != null) {
            ArrayList<ExprNodeDesc> newValues = new ArrayList<ExprNodeDesc>();
            List<ExprNodeDesc> values = hashTableSinkDesc.getExprs().get(tag);
            for (int index = 0; index < values.size(); ++index) {
                if (valueIndex[index] >= 0) continue;
                newValues.add(values.get(index));
            }
            hashTableSinkDesc.getExprs().put(tag, newValues);
        }
        tableScan.replaceChild(mapJoinOp, hashTableSinkOp);
        ArrayList<Operator<? extends OperatorDesc>> tableScanParents = new ArrayList<Operator<? extends OperatorDesc>>();
        tableScanParents.add(tableScan);
        hashTableSinkOp.setParentOperators(tableScanParents);
        hashTableSinkOp.setTag(tag);
    }

    private static void setMemUsage(MapJoinOperator mapJoinOp, Task<? extends Serializable> task, ParseContext parseContext) {
        MapJoinResolver.LocalMapJoinProcCtx context = new MapJoinResolver.LocalMapJoinProcCtx(task, parseContext);
        try {
            new LocalMapJoinProcFactory.LocalMapJoinProcessor().hasGroupBy(mapJoinOp, context);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error setting memory usage.", (Throwable)e);
            return;
        }
        MapJoinDesc mapJoinDesc = (MapJoinDesc)mapJoinOp.getConf();
        HiveConf conf = context.getParseCtx().getConf();
        float hashtableMemoryUsage = context.isFollowedByGroupBy() ? conf.getFloatVar(HiveConf.ConfVars.HIVEHASHTABLEFOLLOWBYGBYMAXMEMORYUSAGE) : conf.getFloatVar(HiveConf.ConfVars.HIVEHASHTABLEMAXMEMORYUSAGE);
        mapJoinDesc.setHashTableMemoryUsage(hashtableMemoryUsage);
    }
}

