/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.IOContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOContextMap {
    public static final String DEFAULT_CONTEXT = "";
    private static final Logger LOG = LoggerFactory.getLogger(IOContextMap.class);
    private static final ConcurrentHashMap<String, IOContext> globalMap = new ConcurrentHashMap();
    private static final ThreadLocal<IOContext> sparkThreadLocal = new ThreadLocal<IOContext>(){

        @Override
        protected IOContext initialValue() {
            return new IOContext();
        }
    };
    private static final ConcurrentHashMap<String, ConcurrentHashMap<String, IOContext>> attemptMap = new ConcurrentHashMap();
    private static final InheritableThreadLocal<String> threadAttemptId = new InheritableThreadLocal();

    public static void setThreadAttemptId(String attemptId) {
        assert (attemptId != null);
        threadAttemptId.set(attemptId);
    }

    public static void clearThreadAttempt(String attemptId) {
        assert (attemptId != null);
        String attemptIdCheck = (String)threadAttemptId.get();
        if (!attemptId.equals(attemptIdCheck)) {
            LOG.error("Thread is clearing context for " + attemptId + ", but " + attemptIdCheck + " expected");
        }
        attemptMap.remove(attemptId);
        threadAttemptId.remove();
    }

    public static IOContext get(Configuration conf) {
        ConcurrentHashMap<String, IOContext> map;
        String attemptId;
        if (HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("spark")) {
            return sparkThreadLocal.get();
        }
        String inputName = conf.get("iocontext.input.name");
        if (inputName == null) {
            inputName = DEFAULT_CONTEXT;
        }
        if ((attemptId = (String)threadAttemptId.get()) == null) {
            map = globalMap;
        } else {
            ConcurrentHashMap<String, IOContext> oldMap;
            map = attemptMap.get(attemptId);
            if (map == null && (oldMap = attemptMap.putIfAbsent(attemptId, map = new ConcurrentHashMap())) != null) {
                map = oldMap;
            }
        }
        IOContext ioContext = map.get(inputName);
        if (ioContext != null) {
            return ioContext;
        }
        ioContext = new IOContext();
        IOContext oldContext = map.putIfAbsent(inputName, ioContext);
        return oldContext == null ? ioContext : oldContext;
    }

    public static void clear() {
        sparkThreadLocal.remove();
        globalMap.clear();
    }
}

