/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.PerfLogger;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.Changes;
import org.apache.jackrabbit.oak.plugins.document.Commit;
import org.apache.jackrabbit.oak.plugins.document.CommitBuilder;
import org.apache.jackrabbit.oak.plugins.document.CommitDiff;
import org.apache.jackrabbit.oak.plugins.document.ConflictException;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreStatsCollector;
import org.apache.jackrabbit.oak.plugins.document.DocumentStoreException;
import org.apache.jackrabbit.oak.plugins.document.FailedWithConflictException;
import org.apache.jackrabbit.oak.plugins.document.MergeStats;
import org.apache.jackrabbit.oak.plugins.document.ModifiedDocumentNodeState;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.TimingHook;
import org.apache.jackrabbit.oak.plugins.document.util.CountingDiff;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.ApplyDiff;
import org.apache.jackrabbit.oak.spi.state.ConflictAnnotatingRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeStoreBranch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DocumentNodeStoreBranch
implements NodeStoreBranch {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentNodeStoreBranch.class);
    private static final PerfLogger perfLogger = new PerfLogger(LoggerFactory.getLogger((String)(DocumentNodeStoreBranch.class.getName() + ".perf")));
    private static final int MAX_LOCK_TRY_TIME_MULTIPLIER = Integer.getInteger("oak.maxLockTryTimeMultiplier", 30);
    private static final Random RANDOM = new Random();
    private static final long MIN_BACKOFF = 50L;
    protected final DocumentNodeStore store;
    protected final long maximumBackoff;
    protected final long maxLockTryTimeMS;
    private final ReadWriteLock mergeLock;
    private final int updateLimit;
    private final boolean avoidMergeLock;
    private BranchState branchState;

    DocumentNodeStoreBranch(DocumentNodeStore store, DocumentNodeState base, ReadWriteLock mergeLock, boolean avoidMergeLock) {
        this.store = Objects.requireNonNull(store);
        this.branchState = new Unmodified(Objects.requireNonNull(base));
        this.maximumBackoff = Math.max((long)store.getMaxBackOffMillis(), 50L);
        this.maxLockTryTimeMS = store.getMaxBackOffMillis() * MAX_LOCK_TRY_TIME_MULTIPLIER;
        this.mergeLock = mergeLock;
        this.updateLimit = store.getUpdateLimit();
        this.avoidMergeLock = avoidMergeLock;
    }

    @NotNull
    public NodeState getBase() {
        return this.branchState.getBase();
    }

    @NotNull
    public NodeState getHead() {
        return this.branchState.getHead();
    }

    public void setRoot(NodeState newRoot) {
        this.branchState.setRoot(Objects.requireNonNull(newRoot));
    }

    @NotNull
    public NodeState merge(@NotNull CommitHook hook, @NotNull CommitInfo info) throws CommitFailedException {
        try {
            return this.merge0(hook, info, false);
        }
        catch (CommitFailedException e) {
            if (!e.isOfType("Merge")) {
                throw e;
            }
            if (this.avoidMergeLock) {
                throw e;
            }
            return this.merge0(hook, info, true);
        }
    }

    public void rebase() {
        this.branchState.rebase();
    }

    public String toString() {
        return this.branchState.toString();
    }

    @NotNull
    ReadWriteLock getMergeLock() {
        return this.mergeLock;
    }

    void persist() {
        this.branchState.persist();
    }

    @NotNull
    private NodeState merge0(@NotNull CommitHook hook, @NotNull CommitInfo info, boolean exclusive) throws CommitFailedException {
        CommitFailedException ex = null;
        HashSet<Revision> conflictRevisions = new HashSet<Revision>();
        long time = System.currentTimeMillis();
        int numRetries = 0;
        long suspendMillis = 0L;
        for (long backoff = 50L; backoff <= this.maximumBackoff; backoff *= 2L) {
            if (ex != null) {
                try {
                    ++numRetries;
                    long start = perfLogger.start();
                    if (!conflictRevisions.isEmpty()) {
                        LOG.debug("Suspending until {} is visible. Current head {}.", conflictRevisions, (Object)this.store.getHeadRevision());
                        suspendMillis += this.store.suspendUntilAll(conflictRevisions);
                        conflictRevisions.clear();
                        LOG.debug("Resumed. Current head {}.", (Object)this.store.getHeadRevision());
                    } else {
                        long sleepMillis = backoff + (long)RANDOM.nextInt((int)Math.min(backoff, Integer.MAX_VALUE));
                        suspendMillis += sleepMillis;
                        Thread.sleep(sleepMillis);
                    }
                    perfLogger.end(start, 1L, "Merge - Retry attempt [{}]", (Object)numRetries);
                }
                catch (InterruptedException e) {
                    throw new CommitFailedException("Merge", 3, "Merge interrupted", (Throwable)e);
                }
            }
            try {
                NodeState result = this.branchState.merge(Objects.requireNonNull(hook), Objects.requireNonNull(info), exclusive);
                this.store.getStatsCollector().doneMerge(this.branchState.getMergedChanges(), numRetries, System.currentTimeMillis() - time, suspendMillis, exclusive);
                return result;
            }
            catch (FailedWithConflictException e) {
                ex = e;
                conflictRevisions.addAll(e.getConflictRevisions());
            }
            catch (CommitFailedException e) {
                ex = e;
            }
            LOG.trace("Merge Error", (Throwable)ex);
            if (ex.isOfType("Merge")) continue;
            throw ex;
        }
        time = System.currentTimeMillis() - time;
        this.store.getStatsCollector().failedMerge(numRetries, time, suspendMillis, exclusive);
        String msg = ex.getMessage() + " (retries " + numRetries + ", " + time + " ms)";
        throw new CommitFailedException(ex.getSource(), ex.getType(), ex.getCode(), msg, ex.getCause());
    }

    @Nullable
    private Lock acquireMergeLock(boolean exclusive) throws CommitFailedException {
        String mode;
        boolean acquired;
        long start = System.nanoTime();
        Lock lock = exclusive ? this.mergeLock.writeLock() : this.mergeLock.readLock();
        try {
            acquired = lock.tryLock(this.maxLockTryTimeMS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new CommitFailedException("Oak", 1, "Unable to acquire merge lock", (Throwable)e);
        }
        String string = mode = exclusive ? "exclusive" : "shared";
        if (acquired) {
            perfLogger.end(start, 1L, "Merge - Acquired lock ({})", (Object)mode);
        } else {
            LOG.info("Time out while acquiring merge lock ({})", (Object)mode);
            lock = null;
        }
        long micros = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - start);
        this.store.getStatsCollector().doneMergeLockAcquired(micros);
        return lock;
    }

    private DocumentNodeState persist(final @NotNull NodeState toPersist, final @NotNull DocumentNodeState base, @NotNull CommitInfo info, final @NotNull MergeStats stats) throws ConflictException, DocumentStoreException {
        return this.persist(new Changes(){

            @Override
            public void with(@NotNull CommitBuilder commitBuilder) {
                CommitDiff diff = new CommitDiff(DocumentNodeStoreBranch.this.store.getBundlingConfigHandler().newBundlingHandler(), commitBuilder, DocumentNodeStoreBranch.this.store.getBlobSerializer());
                toPersist.compareAgainstBaseState((NodeState)base, (NodeStateDiff)diff);
                stats.numDocuments += diff.getNumChanges();
            }
        }, base, info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentNodeState persist(@NotNull Changes op, @NotNull DocumentNodeState base, @NotNull CommitInfo info) throws ConflictException, DocumentStoreException {
        RevisionVector rev;
        boolean success = false;
        Commit c = this.store.newCommit(op, base.getRootRevision(), this);
        try {
            if (c.isEmpty()) {
                DocumentNodeState documentNodeState = base;
                return documentNodeState;
            }
            c.apply();
            rev = this.store.done(c, base.getRootRevision().isBranch(), info);
            success = true;
        }
        finally {
            if (!success) {
                this.store.canceled(c);
            }
        }
        return this.store.getRoot(rev);
    }

    private static CommitFailedException mergeFailed(Throwable t) {
        DocumentStoreException dse;
        String msg = t.getMessage();
        if (msg == null) {
            msg = "Failed to merge changes to the underlying store";
        }
        String type = "Oak";
        if (t instanceof DocumentStoreException && (dse = (DocumentStoreException)t).getType() == DocumentStoreException.Type.TRANSIENT) {
            type = "Merge";
        }
        return new CommitFailedException(type, 1, msg, t);
    }

    static void configurePerfLogger(long infoLogMillis) {
        perfLogger.setInfoLogMillis(infoLogMillis);
    }

    private class ResetFailed
    extends BranchState {
        private final CommitFailedException ex;

        protected ResetFailed(DocumentNodeState base, CommitFailedException e) {
            super(base);
            this.ex = e;
        }

        @Override
        @NotNull
        NodeState getHead() {
            throw new IllegalStateException("Branch with failed reset", (Throwable)this.ex);
        }

        @Override
        void setRoot(NodeState root) {
            throw new IllegalStateException("Branch with failed reset", (Throwable)this.ex);
        }

        @Override
        void rebase() {
            throw new IllegalStateException("Branch with failed reset", (Throwable)this.ex);
        }

        @Override
        @NotNull
        NodeState merge(@NotNull CommitHook hook, @NotNull CommitInfo info, boolean exclusive) throws CommitFailedException {
            throw this.ex;
        }
    }

    private class Merged
    extends BranchState {
        private final MergeStats stats;

        protected Merged(@NotNull DocumentNodeState base, MergeStats stats) {
            super(base);
            this.stats = stats;
        }

        public String toString() {
            return "Merged[" + String.valueOf((Object)this.base) + "]";
        }

        @Override
        @NotNull
        NodeState getHead() {
            throw new IllegalStateException("Branch has already been merged");
        }

        @Override
        void setRoot(NodeState root) {
            throw new IllegalStateException("Branch has already been merged");
        }

        @Override
        void rebase() {
            throw new IllegalStateException("Branch has already been merged");
        }

        @Override
        @NotNull
        NodeState merge(@NotNull CommitHook hook, @NotNull CommitInfo info, boolean exclusive) {
            throw new IllegalStateException("Branch has already been merged");
        }

        @Override
        int getMergedChanges() {
            return this.stats.numDocuments;
        }
    }

    private class Persisted
    extends BranchState {
        private DocumentNodeState head;
        private int numCommits;
        private final MergeStats ms;

        public String toString() {
            return "Persisted[" + String.valueOf((Object)this.base) + ", " + String.valueOf((Object)this.head) + "]";
        }

        Persisted(DocumentNodeState base) {
            super(base);
            this.ms = new MergeStats();
            this.head = this.createBranch(base).asBranchRootState(DocumentNodeStoreBranch.this);
        }

        @Override
        Persisted persist() {
            return this;
        }

        final DocumentNodeState createBranch(DocumentNodeState state) {
            return DocumentNodeStoreBranch.this.store.getRoot(state.getRootRevision().asBranchRevision(DocumentNodeStoreBranch.this.store.getClusterId()));
        }

        @NotNull
        DocumentNodeState getHead() {
            return this.head;
        }

        @Override
        void setRoot(NodeState root) {
            if (!this.head.equals(root)) {
                this.persistTransientHead(root);
            }
        }

        @Override
        void rebase() {
            DocumentNodeState root = DocumentNodeStoreBranch.this.store.getRoot();
            this.head = DocumentNodeStoreBranch.this.store.getRoot(DocumentNodeStoreBranch.this.store.rebase(this.head.getRootRevision(), root.getRootRevision())).asBranchRootState(DocumentNodeStoreBranch.this);
            this.base = root;
        }

        @Override
        @NotNull
        NodeState merge(@NotNull CommitHook hook, @NotNull CommitInfo info, boolean exclusive) throws CommitFailedException {
            boolean success = false;
            DocumentNodeState previousHead = this.head;
            Lock lock = DocumentNodeStoreBranch.this.acquireMergeLock(exclusive);
            try {
                this.rebase();
                previousHead = this.head;
                this.checkForConflicts();
                DocumentNodeStoreStatsCollector stats = DocumentNodeStoreBranch.this.store.getStatsCollector();
                NodeState toCommit = TimingHook.wrap(Objects.requireNonNull(hook), (time, unit) -> stats.doneCommitHookProcessed(unit.toMicros(time))).processCommit((NodeState)this.base, (NodeState)this.head, info);
                this.persistTransientHead(toCommit);
                DocumentNodeState newRoot = DocumentNodeStoreBranch.this.store.getRoot(DocumentNodeStoreBranch.this.store.merge(this.head.getRootRevision(), info));
                success = true;
                DocumentNodeStoreBranch.this.branchState = new Merged(this.base, this.ms);
                stats.doneMergeBranch(this.numCommits, DocumentNodeStoreBranch.this.branchState.getMergedChanges());
                DocumentNodeState documentNodeState = newRoot;
                return documentNodeState;
            }
            catch (CommitFailedException e) {
                throw e;
            }
            catch (ConflictException e) {
                throw e.asCommitFailedException();
            }
            catch (Throwable t) {
                throw DocumentNodeStoreBranch.mergeFailed(t);
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
                if (!success) {
                    this.resetBranch(this.head, previousHead);
                }
            }
        }

        private void persistTransientHead(NodeState newHead) throws DocumentStoreException {
            try {
                this.head = DocumentNodeStoreBranch.this.persist(newHead, this.head, CommitInfo.EMPTY, this.ms).asBranchRootState(DocumentNodeStoreBranch.this);
            }
            catch (ConflictException e) {
                throw DocumentStoreException.convert(e);
            }
            ++this.numCommits;
            DocumentNodeStoreBranch.this.store.getStatsCollector().doneBranchCommit();
        }

        private void resetBranch(DocumentNodeState branchHead, DocumentNodeState ancestor) {
            try {
                this.head = DocumentNodeStoreBranch.this.store.getRoot(DocumentNodeStoreBranch.this.store.reset(branchHead.getRootRevision(), ancestor.getRootRevision())).asBranchRootState(DocumentNodeStoreBranch.this);
            }
            catch (Exception e) {
                CommitFailedException ex = new CommitFailedException("Oak", 100, "Branch reset failed", (Throwable)e);
                DocumentNodeStoreBranch.this.branchState = new ResetFailed(this.base, ex);
            }
        }

        private void checkForConflicts() throws CommitFailedException {
            Branch b = DocumentNodeStoreBranch.this.store.getBranches().getBranch(this.head.getRootRevision());
            if (b == null) {
                return;
            }
            NodeDocument doc = Utils.getRootDocument(DocumentNodeStoreBranch.this.store.getDocumentStore());
            HashSet<Revision> collisions = new HashSet<Revision>(doc.getLocalMap("_collisions").keySet());
            HashSet commits = new HashSet();
            IterableUtils.transform(b.getCommits(), Revision::asTrunkRevision).forEach(commits::add);
            Set conflicts = SetUtils.intersection(collisions, commits);
            if (!conflicts.isEmpty()) {
                throw new CommitFailedException("State", 2, "Conflicting concurrent change on branch commits " + String.valueOf(conflicts));
            }
        }
    }

    private class InMemory
    extends BranchState {
        private NodeState head;

        public String toString() {
            return "InMemory[" + String.valueOf((Object)this.base) + ", " + String.valueOf(this.head) + "]";
        }

        InMemory(DocumentNodeState base, NodeState head) {
            super(base);
            this.head = this.newModifiedDocumentNodeState(head);
        }

        @Override
        @NotNull
        NodeState getHead() {
            return this.head;
        }

        @Override
        void setRoot(NodeState root) {
            if (this.base.equals(root)) {
                DocumentNodeStoreBranch.this.branchState = new Unmodified(this.base);
            } else {
                int numChanges = CountingDiff.countChanges((NodeState)this.base, root);
                if (numChanges > DocumentNodeStoreBranch.this.updateLimit) {
                    this.head = this.newModifiedDocumentNodeState(root);
                    this.persist();
                } else {
                    MemoryNodeBuilder builder = new MemoryNodeBuilder((NodeState)this.base);
                    root.compareAgainstBaseState((NodeState)this.base, (NodeStateDiff)new ApplyDiff((NodeBuilder)builder));
                    this.head = this.newModifiedDocumentNodeState(builder.getNodeState());
                }
            }
        }

        @Override
        void rebase() {
            DocumentNodeState root = DocumentNodeStoreBranch.this.store.getRoot();
            if (root.getRootRevision().equals(this.base.getRootRevision())) {
                return;
            }
            MemoryNodeBuilder builder = new MemoryNodeBuilder((NodeState)root);
            this.head.compareAgainstBaseState((NodeState)this.base, (NodeStateDiff)new ConflictAnnotatingRebaseDiff((NodeBuilder)builder));
            this.base = root;
            this.head = this.newModifiedDocumentNodeState(builder.getNodeState());
        }

        /*
         * Exception decompiling
         */
        @Override
        @NotNull
        NodeState merge(@NotNull CommitHook hook, @NotNull CommitInfo info, boolean exclusive) throws CommitFailedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void reset(Persisted p) {
            RevisionVector branchHeadRev = p.getHead().getRootRevision();
            Branch b = DocumentNodeStoreBranch.this.store.getBranches().getBranch(branchHeadRev);
            if (b != null) {
                try {
                    DocumentNodeStoreBranch.this.store.reset(branchHeadRev, b.getBase().asBranchRevision(DocumentNodeStoreBranch.this.store.getClusterId()));
                }
                catch (Exception e) {
                    LOG.warn("Resetting persisted branch failed", (Throwable)e);
                }
            }
        }

        private ModifiedDocumentNodeState newModifiedDocumentNodeState(NodeState modified) {
            return new ModifiedDocumentNodeState(DocumentNodeStoreBranch.this.store, DocumentNodeStoreBranch.this, this.base, modified);
        }

        private static /* synthetic */ void lambda$merge$0(DocumentNodeStoreStatsCollector stats, long time, TimeUnit unit) {
            stats.doneCommitHookProcessed(unit.toMicros(time));
        }
    }

    private class Unmodified
    extends BranchState {
        Unmodified(DocumentNodeState base) {
            super(base);
        }

        public String toString() {
            return "Unmodified[" + String.valueOf((Object)this.base) + "]";
        }

        @Override
        @NotNull
        NodeState getHead() {
            return this.base;
        }

        @Override
        void setRoot(NodeState root) {
            if (!this.base.equals(root)) {
                DocumentNodeStoreBranch.this.branchState = new InMemory(this.base, root);
            }
        }

        @Override
        void rebase() {
            this.base = DocumentNodeStoreBranch.this.store.getRoot();
        }

        @Override
        @NotNull
        NodeState merge(@NotNull CommitHook hook, @NotNull CommitInfo info, boolean exclusive) {
            DocumentNodeStoreBranch.this.branchState = new Merged(this.base, new MergeStats());
            return this.base;
        }
    }

    private abstract class BranchState {
        protected DocumentNodeState base;

        protected BranchState(DocumentNodeState base) {
            this.base = base;
        }

        Persisted persist() {
            Persisted p = new Persisted(this.base);
            p.persistTransientHead(this.getHead());
            DocumentNodeStoreBranch.this.branchState = p;
            return p;
        }

        DocumentNodeState getBase() {
            return this.base;
        }

        int getMergedChanges() {
            return 0;
        }

        @NotNull
        abstract NodeState getHead();

        abstract void setRoot(NodeState var1);

        abstract void rebase();

        @NotNull
        abstract NodeState merge(@NotNull CommitHook var1, @NotNull CommitInfo var2, boolean var3) throws CommitFailedException;
    }
}

