/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.persistentCache.broadcast;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.broadcast.Broadcaster;
import org.apache.jackrabbit.oak.plugins.document.persistentCache.broadcast.DynamicBroadcastConfig;

public class InMemoryBroadcaster
implements Broadcaster {
    public static final InMemoryBroadcaster INSTANCE = new InMemoryBroadcaster();
    private final ArrayList<Broadcaster.Listener> listeners = new ArrayList();

    @Override
    public void send(ByteBuffer buff) {
        int start = buff.position();
        for (Broadcaster.Listener l : this.listeners) {
            ((Buffer)buff).position(start);
            l.receive(buff);
        }
    }

    @Override
    public void addListener(Broadcaster.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Broadcaster.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void close() {
    }

    @Override
    public void setBroadcastConfig(DynamicBroadcastConfig broadcastConfig) {
    }
}

