/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.config;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.ByteSource;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jclouds.byon.Node;
import org.jclouds.byon.config.ConfiguresNodeStore;
import org.jclouds.byon.domain.YamlNode;
import org.jclouds.byon.functions.NodesFromYamlStream;
import org.jclouds.byon.suppliers.NodesParsedFromSupplier;
import org.jclouds.collect.TransformingMap;

@ConfiguresNodeStore
@Beta
public class YamlNodeStoreModule
extends AbstractModule {
    private static final Map<String, ByteSource> BACKING = new ConcurrentHashMap<String, ByteSource>();
    private final Map<String, ByteSource> backing;

    public YamlNodeStoreModule(Map<String, ByteSource> backing) {
        this.backing = backing;
    }

    public YamlNodeStoreModule() {
        this(null);
    }

    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Supplier<LoadingCache<String, Node>>>(){}).to(NodesParsedFromSupplier.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<ByteSource, LoadingCache<String, Node>>>(){}).to(NodesFromYamlStream.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<YamlNode, ByteSource>>(){}).toInstance(YamlNode.yamlNodeToByteSource);
        this.bind((TypeLiteral)new TypeLiteral<Function<ByteSource, YamlNode>>(){}).toInstance(YamlNode.byteSourceToYamlNode);
        this.bind((TypeLiteral)new TypeLiteral<Function<Node, YamlNode>>(){}).toInstance(YamlNode.nodeToYamlNode);
        this.bind((TypeLiteral)new TypeLiteral<Function<YamlNode, Node>>(){}).toInstance(YamlNode.toNode);
        if (this.backing != null) {
            this.bind((TypeLiteral)new TypeLiteral<Map<String, ByteSource>>(){}).annotatedWith((Annotation)Names.named((String)"yaml")).toInstance(this.backing);
        } else {
            this.bind((TypeLiteral)new TypeLiteral<Map<String, ByteSource>>(){}).annotatedWith((Annotation)Names.named((String)"yaml")).toInstance(BACKING);
        }
    }

    @Provides
    @Singleton
    protected final LoadingCache<String, Node> provideNodeStore(Map<String, YamlNode> backing, Function<Node, YamlNode> yamlSerializer, Function<YamlNode, Node> yamlDeserializer) {
        return CacheBuilder.newBuilder().build(CacheLoader.from((Function)Functions.forMap((Map)new TransformingMap(backing, yamlDeserializer, yamlSerializer))));
    }

    @Provides
    @Singleton
    protected final Map<String, YamlNode> provideYamlStore(@Named(value="yaml") Map<String, ByteSource> backing, Function<YamlNode, ByteSource> yamlSerializer, Function<ByteSource, YamlNode> yamlDeserializer) {
        return new TransformingMap(backing, yamlDeserializer, yamlSerializer);
    }
}

