/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon.functions;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import jakarta.inject.Singleton;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.jclouds.byon.Node;
import org.jclouds.byon.domain.YamlNode;
import org.jclouds.util.Closeables2;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

@Singleton
public class NodesFromYamlStream
implements Function<ByteSource, LoadingCache<String, Node>> {
    public LoadingCache<String, Node> apply(ByteSource source) {
        Config config;
        Constructor constructor = new Constructor(Config.class, new LoaderOptions());
        TypeDescription nodeDesc = new TypeDescription(YamlNode.class);
        nodeDesc.putListPropertyType("tags", String.class);
        constructor.addTypeDescription(nodeDesc);
        TypeDescription configDesc = new TypeDescription(Config.class);
        configDesc.putListPropertyType("nodes", YamlNode.class);
        constructor.addTypeDescription(configDesc);
        Yaml yaml = new Yaml((BaseConstructor)constructor);
        InputStream in = null;
        try {
            in = source.openStream();
            config = (Config)yaml.load(in);
        }
        catch (IOException ioe) {
            throw Throwables.propagate((Throwable)ioe);
        }
        finally {
            Closeables2.closeQuietly((Closeable)in);
        }
        Preconditions.checkState((config != null ? 1 : 0) != 0, (Object)"missing config: class");
        Preconditions.checkState((config.nodes != null ? 1 : 0) != 0, (Object)"missing nodes: collection");
        ImmutableMap backingMap = Maps.uniqueIndex((Iterable)Iterables.transform(config.nodes, YamlNode.toNode), (Function)new Function<Node, String>(){

            public String apply(Node node) {
                return node.getId();
            }
        });
        LoadingCache cache = CacheBuilder.newBuilder().build(CacheLoader.from((Function)Functions.forMap((Map)backingMap)));
        for (String node : backingMap.keySet()) {
            cache.getUnchecked((Object)node);
        }
        return cache;
    }

    public static class Config {
        public List<YamlNode> nodes;
    }
}

