/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.QueryParam;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.cloudstack.domain.SshKeyPair;
import org.jclouds.cloudstack.filters.AuthenticationFilter;
import org.jclouds.cloudstack.options.ListSSHKeyPairsOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@RequestFilters(value={AuthenticationFilter.class})
@QueryParams(keys={"response"}, values={"json"})
public interface SSHKeyPairApi {
    @Named(value="listSSHKeyPairs")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listSSHKeyPairs", "true"})
    @SelectJson(value={"sshkeypair"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<SshKeyPair> listSSHKeyPairs(ListSSHKeyPairsOptions ... var1);

    @Named(value="registerSSHKeyPair")
    @GET
    @QueryParams(keys={"command"}, values={"registerSSHKeyPair"})
    @SelectJson(value={"keypair"})
    @Consumes(value={"application/json"})
    public SshKeyPair registerSSHKeyPair(@QueryParam(value="name") String var1, @QueryParam(value="publickey") String var2);

    @Named(value="createSSHKeyPair")
    @GET
    @QueryParams(keys={"command"}, values={"createSSHKeyPair"})
    @SelectJson(value={"keypair"})
    @Consumes(value={"application/json"})
    public SshKeyPair createSSHKeyPair(@QueryParam(value="name") String var1);

    @Named(value="listSSHKeyPairs")
    @GET
    @QueryParams(keys={"command", "listAll"}, values={"listSSHKeyPairs", "true"})
    @SelectJson(value={"sshkeypair"})
    @OnlyElement
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public SshKeyPair getSSHKeyPair(@QueryParam(value="name") String var1);

    @Named(value="deleteSSHKeyPair")
    @GET
    @QueryParams(keys={"command"}, values={"deleteSSHKeyPair"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void deleteSSHKeyPair(@QueryParam(value="name") String var1);
}

