/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Map;
import org.jclouds.cloudstack.domain.AsyncJob;
import org.jclouds.cloudstack.functions.ParseTypedAsyncJob;
import org.jclouds.domain.JsonBall;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;

@Singleton
public class ParseAsyncJobFromHttpResponse
implements Function<HttpResponse, AsyncJob<?>> {
    private final UnwrapOnlyJsonValue<AsyncJob<Map<String, JsonBall>>> parser;
    private final ParseTypedAsyncJob parseTyped;

    @Inject
    public ParseAsyncJobFromHttpResponse(ParseTypedAsyncJob parseTyped, UnwrapOnlyJsonValue<AsyncJob<Map<String, JsonBall>>> parser) {
        this.parseTyped = (ParseTypedAsyncJob)Preconditions.checkNotNull((Object)parseTyped, (Object)"parseTyped");
        this.parser = (UnwrapOnlyJsonValue)Preconditions.checkNotNull(parser, (Object)"parser");
    }

    public AsyncJob<?> apply(HttpResponse response) {
        Preconditions.checkNotNull((Object)response, (Object)"response");
        AsyncJob toParse = (AsyncJob)this.parser.apply(response);
        Preconditions.checkNotNull((Object)toParse, (String)"parsed result from %s", (Object)response);
        return this.parseTyped.apply(toParse);
    }
}

