/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackApi;
import org.jclouds.cloudstack.domain.Template;
import org.jclouds.cloudstack.domain.Zone;
import org.jclouds.cloudstack.options.ListZonesOptions;

@Singleton
public class CorrectHypervisorForZone
implements Function<String, Predicate<Template>> {
    private final Supplier<Map<String, Set<String>>> hypervisorsSupplier;

    @Inject
    public CorrectHypervisorForZone(CloudStackApi client) {
        this((Supplier<Map<String, Set<String>>>)Suppliers.ofInstance(new CloudStackApiToZoneToHypervisors().apply((CloudStackApi)Preconditions.checkNotNull((Object)client, (Object)"client"))));
    }

    public CorrectHypervisorForZone(Supplier<Map<String, Set<String>>> hypervisorsSupplier) {
        this.hypervisorsSupplier = (Supplier)Preconditions.checkNotNull(hypervisorsSupplier, (Object)"hypervisorsSupplier");
    }

    public Predicate<Template> apply(final String zoneId) {
        Set acceptableHypervisorsInZone;
        try {
            acceptableHypervisorsInZone = (Set)((Map)this.hypervisorsSupplier.get()).get(zoneId);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("unknown zone: " + zoneId);
        }
        if (acceptableHypervisorsInZone.isEmpty()) {
            return Predicates.alwaysFalse();
        }
        return new Predicate<Template>(){

            public boolean apply(Template input) {
                return Predicates.in((Collection)acceptableHypervisorsInZone).apply((Object)input.getHypervisor());
            }

            public String toString() {
                return "hypervisorsInZone(" + zoneId + ", " + acceptableHypervisorsInZone + ")";
            }
        };
    }

    private static class CloudStackApiToZoneToHypervisors
    implements Function<CloudStackApi, Map<String, Set<String>>> {
        private CloudStackApiToZoneToHypervisors() {
        }

        public Map<String, Set<String>> apply(CloudStackApi client) {
            Preconditions.checkNotNull((Object)client, (Object)"client");
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Zone zone : client.getZoneApi().listZones(new ListZonesOptions[0])) {
                builder.put((Object)zone.getId(), client.getHypervisorApi().listHypervisorsInZone(zone.getId()));
            }
            return builder.build();
        }
    }
}

