/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.docker.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.docker.domain.Network;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.binders.BindToJsonPayload;

@Consumes(value={"application/json"})
@Path(value="/v{jclouds.api-version}/networks")
public interface NetworkApi {
    @Named(value="networks:list")
    @GET
    @Fallback(value=Fallbacks.EmptyListOnNotFoundOr404.class)
    public List<Network> listNetworks();

    @Named(value="network:create")
    @POST
    @Path(value="/create")
    public Network createNetwork(@BinderParam(value=BindToJsonPayload.class) Network var1);

    @Named(value="network:inspect")
    @GET
    @Path(value="/{idOrName}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Network inspectNetwork(@PathParam(value="idOrName") String var1);

    @Named(value="network:delete")
    @DELETE
    @Path(value="/{idOrName}")
    public void removeNetwork(@PathParam(value="idOrName") String var1);

    @Named(value="network:connectContainer")
    @POST
    @Path(value="/{idOrName}/connect")
    @Payload(value="%7B\"Container\":\"{containerIdOrName}\"%7D")
    @Headers(keys={"Content-Type"}, values={"application/json"})
    public void connectContainerToNetwork(@PathParam(value="idOrName") String var1, @PayloadParam(value="containerIdOrName") String var2);

    @Named(value="network:disconnectContainer")
    @POST
    @Path(value="/{idOrName}/disconnect")
    @Payload(value="%7B\"Container\":\"{containerIdOrName}\"%7D")
    @Headers(keys={"Content-Type"}, values={"application/json"})
    public void disconnectContainerFromNetwork(@PathParam(value="idOrName") String var1, @PayloadParam(value="containerIdOrName") String var2);
}

