/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.extensions.ImageExtension;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.ec2.compute.EC2ComputeService;
import org.jclouds.ec2.compute.domain.PasswordDataAndPrivateKey;
import org.jclouds.ec2.compute.domain.RegionAndName;
import org.jclouds.ec2.compute.extensions.EC2ImageExtension;
import org.jclouds.ec2.compute.extensions.EC2SecurityGroupExtension;
import org.jclouds.ec2.compute.functions.AddElasticIpsToNodemetadata;
import org.jclouds.ec2.compute.functions.CreateUniqueKeyPair;
import org.jclouds.ec2.compute.functions.CredentialsForInstance;
import org.jclouds.ec2.compute.functions.EC2ImageParser;
import org.jclouds.ec2.compute.functions.EC2SecurityGroupIdFromName;
import org.jclouds.ec2.compute.functions.EC2SecurityGroupToSecurityGroup;
import org.jclouds.ec2.compute.functions.PasswordCredentialsFromWindowsInstance;
import org.jclouds.ec2.compute.functions.RunningInstanceToNodeMetadata;
import org.jclouds.ec2.compute.functions.WindowsLoginCredentialsFromEncryptedData;
import org.jclouds.ec2.compute.internal.EC2TemplateBuilderImpl;
import org.jclouds.ec2.compute.loaders.CreateSecurityGroupIfNeeded;
import org.jclouds.ec2.compute.loaders.LoadPublicIpForInstanceOrNull;
import org.jclouds.ec2.compute.loaders.RegionAndIdToImage;
import org.jclouds.ec2.compute.options.EC2TemplateOptions;
import org.jclouds.ec2.compute.predicates.SecurityGroupPresent;
import org.jclouds.ec2.domain.Image;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.util.Predicates2;

public class EC2ComputeServiceDependenciesModule
extends AbstractModule {
    public static final Map<InstanceState, NodeMetadata.Status> toPortableNodeStatus = ImmutableMap.builder().put((Object)InstanceState.PENDING, (Object)NodeMetadata.Status.PENDING).put((Object)InstanceState.RUNNING, (Object)NodeMetadata.Status.RUNNING).put((Object)InstanceState.SHUTTING_DOWN, (Object)NodeMetadata.Status.PENDING).put((Object)InstanceState.TERMINATED, (Object)NodeMetadata.Status.TERMINATED).put((Object)InstanceState.STOPPING, (Object)NodeMetadata.Status.PENDING).put((Object)InstanceState.STOPPED, (Object)NodeMetadata.Status.SUSPENDED).put((Object)InstanceState.UNRECOGNIZED, (Object)NodeMetadata.Status.UNRECOGNIZED).build();
    @VisibleForTesting
    public static final Map<Image.ImageState, Image.Status> toPortableImageStatus = ImmutableMap.builder().put((Object)Image.ImageState.AVAILABLE, (Object)Image.Status.AVAILABLE).put((Object)Image.ImageState.DEREGISTERED, (Object)Image.Status.DELETED).put((Object)Image.ImageState.UNRECOGNIZED, (Object)Image.Status.UNRECOGNIZED).build();

    @Singleton
    @Provides
    protected Map<InstanceState, NodeMetadata.Status> toPortableNodeStatus() {
        return toPortableNodeStatus;
    }

    @Singleton
    @Provides
    protected Map<Image.ImageState, Image.Status> toPortableImageStatus() {
        return toPortableImageStatus;
    }

    protected void configure() {
        this.bind(TemplateBuilder.class).to(EC2TemplateBuilderImpl.class);
        this.bind(TemplateOptions.class).to(EC2TemplateOptions.class);
        this.bind(ComputeService.class).to(EC2ComputeService.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<RunningInstance, Optional<LoginCredentials>>>(){}).to(CredentialsForInstance.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<RegionAndName, KeyPair>>(){}).to(CreateUniqueKeyPair.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<RegionAndName, org.jclouds.compute.domain.Image>>(){}).to(RegionAndIdToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<RegionAndName, String>>(){}).annotatedWith((Annotation)Names.named((String)"SECURITY")).to(CreateSecurityGroupIfNeeded.class);
        this.bind((TypeLiteral)new TypeLiteral<CacheLoader<RegionAndName, String>>(){}).annotatedWith((Annotation)Names.named((String)"ELASTICIP")).to(LoadPublicIpForInstanceOrNull.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<String, String>>(){}).annotatedWith((Annotation)Names.named((String)"SECGROUP_NAME_TO_ID")).to(EC2SecurityGroupIdFromName.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<PasswordDataAndPrivateKey, LoginCredentials>>(){}).to(WindowsLoginCredentialsFromEncryptedData.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<RunningInstance, LoginCredentials>>(){}).to(PasswordCredentialsFromWindowsInstance.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Image, org.jclouds.compute.domain.Image>>(){}).to(EC2ImageParser.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<SecurityGroup, org.jclouds.compute.domain.SecurityGroup>>(){}).to(EC2SecurityGroupToSecurityGroup.class);
        this.bind((TypeLiteral)new TypeLiteral<ImageExtension>(){}).to(EC2ImageExtension.class);
        this.bind((TypeLiteral)new TypeLiteral<SecurityGroupExtension>(){}).to(EC2SecurityGroupExtension.class);
    }

    @Provides
    @Singleton
    public Function<RunningInstance, NodeMetadata> bindNodeConverter(RunningInstanceToNodeMetadata baseConverter, AddElasticIpsToNodemetadata addElasticIpsToNodemetadata, @Named(value="jclouds.ec2.auto-allocate-elastic-ips") boolean autoAllocateElasticIps) {
        if (!autoAllocateElasticIps) {
            return baseConverter;
        }
        return Functions.compose((Function)addElasticIpsToNodemetadata, (Function)baseConverter);
    }

    @Provides
    @Singleton
    protected LoadingCache<RunningInstance, Optional<LoginCredentials>> credentialsMap(CacheLoader<RunningInstance, Optional<LoginCredentials>> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Singleton
    protected ConcurrentMap<RegionAndName, KeyPair> keypairMap(Injector i) {
        return Maps.newConcurrentMap();
    }

    @Provides
    @Singleton
    @Named(value="SECURITY")
    protected LoadingCache<RegionAndName, String> securityGroupMap(@Named(value="SECURITY") CacheLoader<RegionAndName, String> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Singleton
    @Named(value="ELASTICIP")
    protected LoadingCache<RegionAndName, String> instanceToElasticIp(@Named(value="ELASTICIP") CacheLoader<RegionAndName, String> in) {
        return CacheBuilder.newBuilder().build(in);
    }

    @Provides
    @Singleton
    @Named(value="SECURITY")
    protected Predicate<RegionAndName> securityGroupEventualConsistencyDelay(SecurityGroupPresent in, @Named(value="jclouds.ec2.timeout.securitygroup-present") long msDelay) {
        return Predicates2.retry((Predicate)in, (long)msDelay, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

