/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.date.DateCodec;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.ec2.domain.InstanceState;
import org.jclouds.ec2.domain.Reservation;
import org.jclouds.ec2.domain.RootDeviceType;
import org.jclouds.ec2.domain.RunningInstance;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public abstract class BaseReservationHandler<T>
extends ParseSax.HandlerForGeneratedRequestWithResult<T> {
    protected final DateCodec dateCodec;
    protected final Supplier<String> defaultRegion;
    protected RunningInstance.Builder<?> builder = this.newBuilder();
    protected StringBuilder currentText = new StringBuilder();
    protected int itemDepth;
    protected boolean inInstancesSet;
    protected boolean inProductCodes;
    protected boolean inGroupSet;
    private String volumeId;
    private Attachment.Status attachmentStatus;
    private Date attachTime;
    private boolean deleteOnTermination;
    private String deviceName;
    private Set<String> groupNames = Sets.newLinkedHashSet();
    private String ownerId;
    private String requesterId;
    private String reservationId;
    private Set<RunningInstance> instances = Sets.newLinkedHashSet();

    @Inject
    public BaseReservationHandler(DateCodecFactory dateCodecFactory, @Region Supplier<String> defaultRegion) {
        this.dateCodec = dateCodecFactory.iso8601();
        this.defaultRegion = defaultRegion;
    }

    protected RunningInstance.Builder<?> newBuilder() {
        return RunningInstance.builder();
    }

    protected void inItem() {
        if (this.endOfInstanceItem()) {
            this.refineBuilderBeforeAddingInstance();
            this.instances.add(this.builder.build());
            this.builder = this.newBuilder();
        }
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"item")) {
            ++this.itemDepth;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"instancesSet")) {
            this.inInstancesSet = true;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"productCodes")) {
            this.inProductCodes = true;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"groupSet")) {
            this.inGroupSet = true;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"item")) {
            this.inItem();
            --this.itemDepth;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"instancesSet")) {
            this.inInstancesSet = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"productCodes")) {
            this.inProductCodes = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"groupSet")) {
            this.inGroupSet = false;
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"groupId")) {
            this.groupNames.add(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ownerId")) {
            this.ownerId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"requesterId")) {
            this.requesterId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"reservationId")) {
            this.reservationId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"amiLaunchIndex")) {
            this.builder.amiLaunchIndex(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"dnsName")) {
            this.builder.dnsName(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"imageId")) {
            this.builder.imageId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"instanceId")) {
            this.builder.instanceId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"name")) {
            String rawState = SaxUtils.currentOrNull((StringBuilder)this.currentText);
            if (rawState != null) {
                this.builder.rawState(rawState);
                this.builder.instanceState(InstanceState.fromValue(rawState));
            }
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"instanceType")) {
            this.builder.instanceType(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ipAddress")) {
            this.builder.ipAddress(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"kernelId")) {
            this.builder.kernelId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"keyName")) {
            this.builder.keyName(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"launchTime")) {
            this.builder.launchTime(this.dateCodec.toDate(SaxUtils.currentOrNull((StringBuilder)this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"availabilityZone")) {
            this.builder.availabilityZone(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"virtualizationType")) {
            this.builder.virtualizationType(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"platform")) {
            this.builder.platform(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"privateDnsName")) {
            this.builder.privateDnsName(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"privateIpAddress")) {
            this.builder.privateIpAddress(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ramdiskId")) {
            this.builder.ramdiskId(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"reason")) {
            this.builder.reason(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"rootDeviceType")) {
            this.builder.rootDeviceType(RootDeviceType.fromValue(SaxUtils.currentOrNull((StringBuilder)this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"rootDeviceName")) {
            this.builder.rootDeviceName(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"deviceName")) {
            this.deviceName = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"volumeId")) {
            this.volumeId = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"status")) {
            this.attachmentStatus = Attachment.Status.fromValue(this.currentText.toString().trim());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"attachTime")) {
            this.attachTime = this.dateCodec.toDate(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"deleteOnTermination")) {
            this.deleteOnTermination = Boolean.parseBoolean(this.currentText.toString().trim());
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"ebs")) {
            this.builder.device(this.deviceName, new BlockDevice(this.volumeId, this.attachmentStatus, this.attachTime, this.deleteOnTermination));
            this.deviceName = null;
            this.volumeId = null;
            this.attachmentStatus = null;
            this.attachTime = null;
            this.deleteOnTermination = true;
        }
        this.currentText.setLength(0);
    }

    protected void refineBuilderBeforeAddingInstance() {
        String region = this.getRequest() != null ? AWSUtils.findRegionInArgsOrNull((GeneratedHttpRequest)this.getRequest()) : null;
        this.builder.region(region == null ? (String)this.defaultRegion.get() : region);
        this.builder.groupNames(this.groupNames);
    }

    protected boolean endOfInstanceItem() {
        return this.itemDepth <= 2 && this.inInstancesSet && !this.inProductCodes && !this.inGroupSet;
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }

    protected Reservation<? extends RunningInstance> newReservation() {
        String region;
        String string = region = this.getRequest() != null ? AWSUtils.findRegionInArgsOrNull((GeneratedHttpRequest)this.getRequest()) : null;
        if (region == null) {
            region = (String)this.defaultRegion.get();
        }
        Reservation<RunningInstance> info = new Reservation<RunningInstance>(region, this.groupNames, this.instances, this.ownerId, this.requesterId, this.reservationId);
        this.groupNames = Sets.newLinkedHashSet();
        this.instances = Sets.newLinkedHashSet();
        this.ownerId = null;
        this.requesterId = null;
        this.reservationId = null;
        return info;
    }
}

