/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;

public enum OsFamily {
    UNRECOGNIZED,
    AIX,
    ARCH,
    CENTOS,
    DARWIN,
    DEBIAN,
    ESX,
    FEDORA,
    FREEBSD,
    GENTOO,
    HPUX,
    LINUX,
    SMARTOS,
    AMZN_LINUX,
    MANDRIVA,
    NETBSD,
    OEL,
    OPENBSD,
    RHEL,
    SCIENTIFIC,
    GCEL,
    SIGAR,
    SLACKWARE,
    SOLARIS,
    SUSE,
    TURBOLINUX,
    CLOUD_LINUX,
    UBUNTU,
    WINDOWS;


    public String value() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.name());
    }

    public String toString() {
        return this.value();
    }

    public static OsFamily fromValue(String osFamily) {
        try {
            return OsFamily.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)osFamily, (Object)"osFamily")));
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

