/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.compute.stub.config;

import com.google.common.base.Supplier;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.net.HostAndPort;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.stub.extensions.StubSecurityGroupExtension;
import org.jclouds.domain.Credentials;
import org.jclouds.location.Provider;
import org.jclouds.predicates.SocketOpen;

public class StubComputeServiceDependenciesModule
extends AbstractModule {
    protected static final LoadingCache<String, ConcurrentMap<String, NodeMetadata>> backing = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, ConcurrentMap<String, NodeMetadata>>(){

        public ConcurrentMap<String, NodeMetadata> load(String arg0) throws Exception {
            return new ConcurrentHashMap<String, NodeMetadata>();
        }
    });
    protected static final LoadingCache<String, ConcurrentMap<String, SecurityGroup>> groupBacking = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, ConcurrentMap<String, SecurityGroup>>(){

        public ConcurrentMap<String, SecurityGroup> load(String arg0) throws Exception {
            return new ConcurrentHashMap<String, SecurityGroup>();
        }
    });
    protected static final LoadingCache<String, Multimap<String, SecurityGroup>> groupsForNodeBacking = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Multimap<String, SecurityGroup>>(){

        public Multimap<String, SecurityGroup> load(String arg0) throws Exception {
            return LinkedHashMultimap.create();
        }
    });
    protected static final LoadingCache<String, AtomicInteger> nodeIds = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

        public AtomicInteger load(String arg0) throws Exception {
            return new AtomicInteger(0);
        }
    });
    protected static final LoadingCache<String, AtomicInteger> groupIds = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, AtomicInteger>(){

        public AtomicInteger load(String arg0) throws Exception {
            return new AtomicInteger(0);
        }
    });

    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<SecurityGroupExtension>(){}).to(StubSecurityGroupExtension.class);
    }

    @Provides
    @Singleton
    protected ConcurrentMap<String, NodeMetadata> provideNodesForIdentity(@Provider Supplier<Credentials> creds) throws ExecutionException {
        return (ConcurrentMap)backing.get((Object)((Credentials)creds.get()).identity);
    }

    @Provides
    @Singleton
    protected ConcurrentMap<String, SecurityGroup> provideGroups(@Provider Supplier<Credentials> creds) throws ExecutionException {
        return (ConcurrentMap)groupBacking.get((Object)((Credentials)creds.get()).identity);
    }

    @Provides
    @Singleton
    protected Multimap<String, SecurityGroup> provideGroupsForNode(@Provider Supplier<Credentials> creds) throws ExecutionException {
        return (Multimap)groupsForNodeBacking.get((Object)((Credentials)creds.get()).identity);
    }

    @Provides
    @Named(value="NODE_ID")
    protected Integer provideNodeIdForIdentity(@Provider Supplier<Credentials> creds) throws ExecutionException {
        return ((AtomicInteger)nodeIds.get((Object)((Credentials)creds.get()).identity)).incrementAndGet();
    }

    @Provides
    @Named(value="GROUP_ID")
    protected Integer provideGroupIdForIdentity(@Provider Supplier<Credentials> creds) throws ExecutionException {
        return ((AtomicInteger)groupIds.get((Object)((Credentials)creds.get()).identity)).incrementAndGet();
    }

    @Singleton
    @Provides
    @Named(value="PUBLIC_IP_PREFIX")
    String publicIpPrefix() {
        return "144.175.1.";
    }

    @Singleton
    @Provides
    @Named(value="PRIVATE_IP_PREFIX")
    String privateIpPrefix() {
        return "10.1.1.";
    }

    @Singleton
    @Provides
    @Named(value="PASSWORD_PREFIX")
    String passwordPrefix() {
        return "password";
    }

    @Singleton
    @Provides
    SocketOpen socketOpen(StubSocketOpen in) {
        return in;
    }

    static Hardware stub(String type, int cores, int ram, float disk) {
        return new HardwareBuilder().ids(type).name(type).processors((Iterable<Processor>)ImmutableList.of((Object)new Processor(cores, 1.0))).ram(ram).volumes((Iterable<Volume>)ImmutableList.of((Object)new VolumeImpl(Float.valueOf(disk), true, false))).build();
    }

    @Singleton
    public static class StubSocketOpen
    implements SocketOpen {
        private final ConcurrentMap<String, NodeMetadata> nodes;
        private final String publicIpPrefix;

        @Inject
        public StubSocketOpen(ConcurrentMap<String, NodeMetadata> nodes, @Named(value="PUBLIC_IP_PREFIX") String publicIpPrefix) {
            this.nodes = nodes;
            this.publicIpPrefix = publicIpPrefix;
        }

        public boolean apply(HostAndPort input) {
            if (input.getHostText().indexOf(this.publicIpPrefix) == -1) {
                return false;
            }
            String id = input.getHostText().replace(this.publicIpPrefix, "");
            NodeMetadata node = (NodeMetadata)this.nodes.get(id);
            return node != null && node.getStatus() == NodeMetadata.Status.RUNNING;
        }
    }
}

