/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionMetadata;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.utils.CommandLineUtils$;
import kafka.utils.ToolsUtils$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class GetOffsetShell$ {
    public static final GetOffsetShell$ MODULE$;

    static {
        new GetOffsetShell$();
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "REQUIRED: The topic to get offset from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionOpt = parser.accepts("partitions", "comma separated list of partition ids. If not specified, it will find offsets for all partitions").withRequiredArg().describedAs("partition ids").ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec timeOpt = parser.accepts("time", "timestamp of the offsets before that").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class);
        ArgumentAcceptingOptionSpec nOffsetsOpt = parser.accepts("offsets", "number of offsets returned").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1000), (Object[])new Integer[0]);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "An interactive shell for getting consumer offsets.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt, topicOpt, timeOpt}));
        String clientId = "GetOffsetShell";
        String brokerList = (String)options.valueOf((OptionSpec)brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        Seq<BrokerEndPoint> metadataTargetBrokers = ClientUtils$.MODULE$.parseBrokerList(brokerList);
        String topic = (String)options.valueOf((OptionSpec)topicOpt);
        String partitionList = (String)options.valueOf((OptionSpec)partitionOpt);
        LongRef time = new LongRef(((Long)options.valueOf((OptionSpec)timeOpt)).longValue());
        int nOffsets = (Integer)options.valueOf((OptionSpec)nOffsetsOpt);
        int maxWaitMs = (Integer)options.valueOf((OptionSpec)maxWaitMsOpt);
        Seq<TopicMetadata> topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), metadataTargetBrokers, clientId, maxWaitMs, ClientUtils$.MODULE$.fetchTopicMetadata$default$5()).topicsMetadata();
        if (topicsMetadata.size() != 1 || !((TopicMetadata)topicsMetadata.apply(0)).topic().equals(topic)) {
            System.err.println(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Error: no valid topic metadata for topic: %s,  probably the topic does not exist, run ")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic}))).append((Object)"kafka-list-topic.sh to verify").toString());
            System.exit(1);
        }
        String string = partitionList;
        String string2 = "";
        Seq partitions = !(string != null ? !string.equals(string2) : string2 != null) ? (Seq)((TopicMetadata)topicsMetadata.head()).partitionsMetadata().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(PartitionMetadata x$1) {
                return x$1.partitionId();
            }
        }, Seq$.MODULE$.canBuildFrom()) : Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])partitionList.split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toSeq();
        partitions.foreach((Function1)new Serializable(clientId, topic, time, nOffsets, topicsMetadata){
            public static final long serialVersionUID = 0L;
            private final String clientId$1;
            private final String topic$1;
            private final LongRef time$1;
            private final int nOffsets$1;
            private final Seq topicsMetadata$1;

            public final void apply(int partitionId) {
                this.apply$mcVI$sp(partitionId);
            }

            public void apply$mcVI$sp(int partitionId) {
                Option option;
                block7: {
                    block6: {
                        block2: {
                            Option<BrokerEndPoint> option2;
                            block5: {
                                block4: {
                                    block3: {
                                        Option partitionMetadataOpt = ((TopicMetadata)this.topicsMetadata$1.head()).partitionsMetadata().find((Function1)new Serializable(this, partitionId){
                                            public static final long serialVersionUID = 0L;
                                            private final int partitionId$1;

                                            public final boolean apply(PartitionMetadata x$3) {
                                                return x$3.partitionId() == this.partitionId$1;
                                            }
                                            {
                                                this.partitionId$1 = partitionId$1;
                                            }
                                        });
                                        option = partitionMetadataOpt;
                                        if (!(option instanceof Some)) break block2;
                                        Some some = (Some)option;
                                        PartitionMetadata metadata = (PartitionMetadata)some.x();
                                        option2 = metadata.leader();
                                        if (!(option2 instanceof Some)) break block3;
                                        Some some2 = (Some)option2;
                                        BrokerEndPoint leader = (BrokerEndPoint)some2.x();
                                        SimpleConsumer consumer = new SimpleConsumer(leader.host(), leader.port(), 10000, 100000, this.clientId$1);
                                        TopicAndPartition topicAndPartition = new TopicAndPartition(this.topic$1, partitionId);
                                        OffsetRequest request = new OffsetRequest((Map<TopicAndPartition, PartitionOffsetRequestInfo>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(this.time$1.elem, this.nOffsets$1))}))), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                                        Seq<Object> offsets = ((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets();
                                        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s:%d:%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)partitionId), offsets.mkString(",")})));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option<BrokerEndPoint> option3 = option2;
                                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block5;
                                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: partition %d does not have a leader. Skip getting offsets")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId)})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block6;
                            }
                            throw new MatchError(option2);
                        }
                        None$ none$ = None$.MODULE$;
                        Option option4 = option;
                        if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                        System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: partition %d does not exist")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId)})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError((Object)option);
            }
            {
                this.clientId$1 = clientId$1;
                this.topic$1 = topic$1;
                this.time$1 = time$1;
                this.nOffsets$1 = nOffsets$1;
                this.topicsMetadata$1 = topicsMetadata$1;
            }
        });
    }

    private GetOffsetShell$() {
        MODULE$ = this;
    }
}

