/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.controller.KafkaController;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigHandler;
import kafka.server.Constants$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.Logging;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u0001\u001d\u0011!\u0003V8qS\u000e\u001cuN\u001c4jO\"\u000bg\u000e\u001a7fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u00119\u0011\u0002CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\ti1i\u001c8gS\u001eD\u0015M\u001c3mKJ\u0004\"a\u0005\f\u000e\u0003QQ!!\u0006\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005]!\"a\u0002'pO\u001eLgn\u001a\u0005\t3\u0001\u0011)\u0019!C\u00055\u0005QAn\\4NC:\fw-\u001a:\u0016\u0003m\u0001\"\u0001H\u0010\u000e\u0003uQ!A\b\u0003\u0002\u00071|w-\u0003\u0002!;\tQAj\\4NC:\fw-\u001a:\t\u0011\t\u0002!\u0011!Q\u0001\nm\t1\u0002\\8h\u001b\u0006t\u0017mZ3sA!AA\u0005\u0001B\u0001B\u0003%Q%A\u0006lC\u001a\\\u0017mQ8oM&<\u0007CA\b'\u0013\t9#AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002C\u0015\u0001\u0005\u000b\u0007I\u0011\u0001\u0016\u0002\rE,x\u000e^1t+\u0005Y\u0003C\u0001\u00177\u001d\tiCG\u0004\u0002/g9\u0011qFM\u0007\u0002a)\u0011\u0011GB\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015I!a\u0001\u0003\n\u0005U\u0012\u0011\u0001D)v_R\fg)Y2u_JL\u0018BA\u001c9\u00055\tVo\u001c;b\u001b\u0006t\u0017mZ3sg*\u0011QG\u0001\u0005\tu\u0001\u0011\t\u0011)A\u0005W\u00059\u0011/^8uCN\u0004\u0003\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\u0002\u001f-\fgm[1D_:$(o\u001c7mKJ\u0004\"AP!\u000e\u0003}R!\u0001\u0011\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0002C\u007f\ty1*\u00194lC\u000e{g\u000e\u001e:pY2,'\u000fC\u0003E\u0001\u0011\u0005Q)\u0001\u0004=S:LGO\u0010\u000b\u0006\r\u001eC\u0015J\u0013\t\u0003\u001f\u0001AQ!G\"A\u0002mAQ\u0001J\"A\u0002\u0015BQ!K\"A\u0002-BQ\u0001P\"A\u0002uBQ\u0001\u0014\u0001\u0005\u00025\u000bA\u0003\u001d:pG\u0016\u001c8oQ8oM&<7\t[1oO\u0016\u001cHc\u0001(R7B\u0011\u0011bT\u0005\u0003!*\u0011A!\u00168ji\")!k\u0013a\u0001'\u0006)Ao\u001c9jGB\u0011A\u000b\u0017\b\u0003+Z\u0003\"a\f\u0006\n\u0005]S\u0011A\u0002)sK\u0012,g-\u0003\u0002Z5\n11\u000b\u001e:j]\u001eT!a\u0016\u0006\t\u000bq[\u0005\u0019A/\u0002\u0017Q|\u0007/[2D_:4\u0017n\u001a\t\u0003=\u000el\u0011a\u0018\u0006\u0003A\u0006\fA!\u001e;jY*\t!-\u0001\u0003kCZ\f\u0017B\u00013`\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\u0006M\u0002!\taZ\u0001\u0019a\u0006\u00148/\u001a+ie>$H\u000f\\3e!\u0006\u0014H/\u001b;j_:\u001cH\u0003\u00025uk^\u00042!\u001b8r\u001d\tQGN\u0004\u00020W&\t1\"\u0003\u0002n\u0015\u00059\u0001/Y2lC\u001e,\u0017BA8q\u0005\r\u0019V-\u001d\u0006\u0003[*\u0001\"!\u0003:\n\u0005MT!aA%oi\")A,\u001aa\u0001;\")a/\u001aa\u0001c\u0006A!M]8lKJLE\rC\u0003yK\u0002\u00071+\u0001\u0003qe>\u0004\b\"\u0002>\u0001\t\u0003Y\u0018aD3yG2,H-\u001a3D_:4\u0017nZ:\u0015\tq|\u0018\u0011\u0001\t\u0004)v\u001c\u0016B\u0001@[\u0005\r\u0019V\r\u001e\u0005\u0006%f\u0004\ra\u0015\u0005\u00069f\u0004\r!\u0018")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final LogManager logManager;
    private final KafkaConfig kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private final KafkaController kafkaController;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TopicConfigHandler topicConfigHandler = this;
        synchronized (topicConfigHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        block1: {
            scala.collection.immutable.Set<String> configNamesToExclude = this.excludedConfigs(topic, topicConfig);
            Buffer logs = this.logManager().logsByTopic(topic).toBuffer();
            if (logs.nonEmpty()) {
                Properties props = new Properties();
                ((IterableLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfig).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    BoxedUnit boxedUnit = !configNamesToExclude.contains((Object)key) ? props.put(key, value) : BoxedUnit.UNIT;
                    return boxedUnit;
                });
                LogConfig logConfig = LogConfig$.MODULE$.fromProps(this.logManager().currentDefaultConfig().originals(), props);
                logs.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    x$1.updateConfig((Set<String>)((MapLike)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(topicConfig).asScala()).keySet(), logConfig);
                    return BoxedUnit.UNIT;
                });
            }
            this.updateThrottledList$1(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), this.quotas().leader(), topic, topicConfig);
            this.updateThrottledList$1(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), this.quotas().follower(), topic, topicConfig);
            if (!BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(topicConfig.getProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp()))).toBoolean()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))) break block1;
            this.kafkaController.enableTopicUncleanLeaderElection(topic);
        }
    }

    public Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        String configValue = topicConfig.get(prop).toString().trim();
        ThrottledReplicaListValidator$.MODULE$.ensureValidString(prop, configValue);
        String string = configValue;
        Seq seq = "".equals(string) ? (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$) : ("*".equals(string) ? Constants$.MODULE$.AllReplicas() : new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(","))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.split(":"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$parseThrottledPartitions$2(brokerId, x$3))))).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)TopicConfigHandler.$anonfun$parseThrottledPartitions$3(x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toSeq());
        return seq;
    }

    public scala.collection.immutable.Set<String> excludedConfigs(String topic, Properties topicConfig) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)topicConfig.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).flatMap((Function1 & Serializable & scala.Serializable)versionString -> {
            None$ none$;
            if ($this.kafkaConfig.interBrokerProtocolVersion().$less(ApiVersion$.MODULE$.apply((String)versionString))) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Log configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append(" is ignored for `").append(topic).append("` because `").append((String)versionString).append("` ").append(new StringBuilder(61).append("is not compatible with Kafka inter-broker protocol version `").append($this.kafkaConfig.interBrokerProtocolVersionString()).append("`").toString()).toString());
                none$ = new Some((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        })).toSet();
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, String topic$1, Properties topicConfig$1) {
        if (topicConfig$1.containsKey(prop) && topicConfig$1.getProperty(prop).length() > 0) {
            Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$1, partitions);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Setting ").append(prop).append(" on broker ").append($this.kafkaConfig.brokerId()).append(" for topic: ").append(topic$1).append(" and partitions ").append(partitions).toString());
        } else {
            quotaManager.removeThrottle(topic$1);
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Removing ").append(prop).append(" from broker ").append($this.kafkaConfig.brokerId()).append(" for topic ").append(topic$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseThrottledPartitions$2(int brokerId$1, String[] x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3[1])).toInt() == brokerId$1;
    }

    public static final /* synthetic */ int $anonfun$parseThrottledPartitions$3(String[] x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4[0])).toInt();
    }

    public TopicConfigHandler(LogManager logManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas, KafkaController kafkaController) {
        this.logManager = logManager;
        this.kafkaConfig = kafkaConfig;
        this.quotas = quotas;
        this.kafkaController = kafkaController;
        Logging.$init$(this);
    }
}

