/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.lens.cli.skel;

import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.shell.plugin.support.DefaultHistoryFileNameProvider;
import org.springframework.stereotype.Component;

/**
 * The Class LensHistoryFileProvider.
 */
@Component
@Order(Ordered.HIGHEST_PRECEDENCE)
public class LensHistoryFileProvider extends DefaultHistoryFileNameProvider {

  public String getHistoryFileName() {
    return "lens-cli-hist.log";
  }

  /*
   * (non-Javadoc)
   *
   * @see org.springframework.shell.plugin.support.DefaultHistoryFileNameProvider#name()
   */
  @Override
  public String getProviderName() {
    return "lens client history provider";
  }
}
