/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;

public final class LogManager {
    private LogManager() {
    }

    public static Logger getRootLogger() {
        return (Logger)Category.getInstance((LoggerContext)PrivateManager.getContext(), "");
    }

    public static Logger getLogger(String name) {
        return (Logger)Category.getInstance((LoggerContext)PrivateManager.getContext(), name);
    }

    public static Logger getLogger(Class clazz) {
        return (Logger)Category.getInstance((LoggerContext)PrivateManager.getContext(), clazz.getName());
    }

    public static Logger exists(String name) {
        LoggerContext ctx = (LoggerContext)PrivateManager.getContext();
        if (!ctx.hasLogger(name)) {
            return null;
        }
        return Logger.getLogger(name);
    }

    private static class PrivateManager
    extends org.apache.logging.log4j.LogManager {
        private static final String FQCN = LogManager.class.getName();

        private PrivateManager() {
        }

        public static org.apache.logging.log4j.spi.LoggerContext getContext() {
            return PrivateManager.getContext((String)FQCN, (boolean)false);
        }

        public static org.apache.logging.log4j.Logger getLogger(String name) {
            return PrivateManager.getLogger((String)FQCN, (String)name);
        }
    }
}

