/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.utils.DependencySilentLog;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.components.io.fileselectors.FileSelector;
import org.codehaus.plexus.components.io.fileselectors.IncludeExcludeFileSelector;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.ReflectionUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractDependencyMojo
extends AbstractMojo {
    @Component
    private ArchiverManager archiverManager;
    @Parameter(property="dependency.useJvmChmod", defaultValue="true")
    private boolean useJvmChmod = true;
    @Parameter(property="dependency.ignorePermissions", defaultValue="false")
    private boolean ignorePermissions;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(property="silent", defaultValue="false")
    private boolean silent;
    @Parameter(property="outputAbsoluteArtifactFilename", defaultValue="false")
    protected boolean outputAbsoluteArtifactFilename;
    @Parameter(property="mdep.skip", defaultValue="false")
    private boolean skip;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        this.doExecute();
    }

    protected abstract void doExecute() throws MojoExecutionException, MojoFailureException;

    public ArchiverManager getArchiverManager() {
        return this.archiverManager;
    }

    protected void copyFile(File artifact, File destFile) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)("Copying " + (this.outputAbsoluteArtifactFilename ? artifact.getAbsolutePath() : artifact.getName()) + " to " + destFile));
            if (artifact.isDirectory()) {
                throw new MojoExecutionException("Artifact has not been packaged yet. When used on reactor artifact, copy should be executed after packaging: see MDEP-187.");
            }
            FileUtils.copyFile((File)artifact, (File)destFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying artifact from " + artifact + " to " + destFile, (Exception)e);
        }
    }

    protected void unpack(Artifact artifact, File location, String encoding, FileMapper[] fileMappers) throws MojoExecutionException {
        this.unpack(artifact, location, null, null, encoding, fileMappers);
    }

    protected void unpack(Artifact artifact, File location, String includes, String excludes, String encoding, FileMapper[] fileMappers) throws MojoExecutionException {
        this.unpack(artifact, artifact.getType(), location, includes, excludes, encoding, fileMappers);
    }

    protected void unpack(Artifact artifact, String type, File location, String includes, String excludes, String encoding, FileMapper[] fileMappers) throws MojoExecutionException {
        File file = artifact.getFile();
        try {
            UnArchiver unArchiver;
            this.logUnpack(file, location, includes, excludes);
            location.mkdirs();
            if (!location.exists()) {
                throw new MojoExecutionException("Location to write unpacked files to could not be created: " + location);
            }
            if (file.isDirectory()) {
                throw new MojoExecutionException("Artifact has not been packaged yet. When used on reactor artifact, unpack should be executed after packaging: see MDEP-98.");
            }
            try {
                unArchiver = this.archiverManager.getUnArchiver(type);
                this.getLog().debug((CharSequence)("Found unArchiver by type: " + unArchiver));
            }
            catch (NoSuchArchiverException e) {
                unArchiver = this.archiverManager.getUnArchiver(file);
                this.getLog().debug((CharSequence)("Found unArchiver by extension: " + unArchiver));
            }
            if (encoding != null && unArchiver instanceof ZipUnArchiver) {
                ((ZipUnArchiver)unArchiver).setEncoding(encoding);
                this.getLog().info((CharSequence)("Unpacks '" + type + "' with encoding '" + encoding + "'."));
            }
            unArchiver.setIgnorePermissions(this.ignorePermissions);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            if (StringUtils.isNotEmpty((String)excludes) || StringUtils.isNotEmpty((String)includes)) {
                IncludeExcludeFileSelector[] selectors = new IncludeExcludeFileSelector[]{new IncludeExcludeFileSelector()};
                if (StringUtils.isNotEmpty((String)excludes)) {
                    selectors[0].setExcludes(excludes.split(","));
                }
                if (StringUtils.isNotEmpty((String)includes)) {
                    selectors[0].setIncludes(includes.split(","));
                }
                unArchiver.setFileSelectors((FileSelector[])selectors);
            }
            if (this.silent) {
                this.silenceUnarchiver(unArchiver);
            }
            unArchiver.setFileMappers(fileMappers);
            unArchiver.extract();
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Unknown archiver type", (Exception)((Object)e));
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + " to: " + location + System.lineSeparator() + e.toString(), (Exception)((Object)e));
        }
    }

    private void silenceUnarchiver(UnArchiver unArchiver) {
        try {
            Field field = ReflectionUtils.getFieldByNameIncludingSuperclasses((String)"logger", unArchiver.getClass());
            field.setAccessible(true);
            field.set(unArchiver, this.getLog());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ProjectBuildingRequest newResolveArtifactProjectBuildingRequest() {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.remoteRepositories);
        return buildingRequest;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setArchiverManager(ArchiverManager archiverManager) {
        this.archiverManager = archiverManager;
    }

    public boolean isUseJvmChmod() {
        return this.useJvmChmod;
    }

    public void setUseJvmChmod(boolean useJvmChmod) {
        this.useJvmChmod = useJvmChmod;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    protected final boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
        if (silent) {
            this.setLog(new DependencySilentLog());
        }
    }

    private void logUnpack(File file, File location, String includes, String excludes) {
        if (!this.getLog().isInfoEnabled()) {
            return;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("Unpacking ");
        msg.append(file);
        msg.append(" to ");
        msg.append(location);
        if (includes != null && excludes != null) {
            msg.append(" with includes \"");
            msg.append(includes);
            msg.append("\" and excludes \"");
            msg.append(excludes);
            msg.append("\"");
        } else if (includes != null) {
            msg.append(" with includes \"");
            msg.append(includes);
            msg.append("\"");
        } else if (excludes != null) {
            msg.append(" with excludes \"");
            msg.append(excludes);
            msg.append("\"");
        }
        this.getLog().info((CharSequence)msg.toString());
    }
}

