/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.resources;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.apache.maven.plugins:maven-resources-plugin:2.4.3", 0);
        this.append(sb, "", 0);
        this.append(sb, "Maven Resources Plugin", 0);
        this.append(sb, "The Resources Plugin handles the copying of project resources to the output directory. There are two different kinds of resources: main resources and test resources. The difference is that the main resources are the resources associated to the main source code while the test resources are associated to the test source code. Thus, this allows the separation of resources for the main source code and its unit tests.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "copy-resources".equals(this.goal)) {
            this.append(sb, "resources:copy-resources", 0);
            this.append(sb, "Copy resources of the configured plugin attribute resources", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "delimiters", 2);
                this.append(sb, "Set of delimiters for expressions to filter within the resources. These delimiters are specified in the form 'beginToken*endToken'. If no '*' is given, the delimiter is assumed to be the same for start and end.\n\nSo, the default filtering delimiters might be specified as:\n\n<delimiters>\n\u00a0\u00a0<delimiter>${*}</delimiter>\n\u00a0\u00a0<delimiter>@</delimiter>\n</delimiters>\n\nSince the '@' delimiter is the same on both ends, we don't need to specify '@*@' (though we can).\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The character encoding scheme to be applied when filtering resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapeString (Default: ${maven.resources.escapeString})", 2);
                this.append(sb, "Expression preceded with the String won't be interpolated \\${foo} will be replaced with ${foo}", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapeWindowsPaths (Default: true)", 2);
                this.append(sb, "Whether to escape backslashes and colons in windows-style paths.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filters", 2);
                this.append(sb, "The list of extra filter properties files to be used along with System properties, project properties, and filter properties files specified in the POM build/filters section, which should be used for the filtering during the current mojo execution.\nNormally, these will be configured from a plugin's execution section, to provide a different set of filters for a particular execution. For instance, starting in Maven 2.2.0, you have the option of configuring executions with the id's default-resources and default-testResources to supply different configurations for the two different types of resources. By supplying extraFilters configurations, you can separate which filters are used for which type of resource.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeEmptyDirs (Default: false)", 2);
                this.append(sb, "Copy any empty directories included in the Ressources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "nonFilteredFileExtensions", 2);
                this.append(sb, "Additionnal file extensions to not apply filtering (already defined are : jpg, jpeg, gif, bmp, png)", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The output directory into which to copy the resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "overwrite (Default: false)", 2);
                this.append(sb, "Overwrite existing files even if the destination files are newer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resources", 2);
                this.append(sb, "The list of resources we want to transfer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useBuildFilters (Default: true)", 2);
                this.append(sb, "If false, don't use the filters specified in the build/filters section of the POM when processing resources in this mojo execution.\nSee also: ResourcesMojo.buildFilters and ResourcesMojo.filters", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultDelimiters (Default: true)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "resources:help", 0);
            this.append(sb, "Display help information on maven-resources-plugin.\nCall\n\u00a0\u00a0mvn\u00a0resources:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "resources".equals(this.goal)) {
            this.append(sb, "resources:resources", 0);
            this.append(sb, "Copy resources for the main source code to the main output directory.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "delimiters", 2);
                this.append(sb, "Set of delimiters for expressions to filter within the resources. These delimiters are specified in the form 'beginToken*endToken'. If no '*' is given, the delimiter is assumed to be the same for start and end.\n\nSo, the default filtering delimiters might be specified as:\n\n<delimiters>\n\u00a0\u00a0<delimiter>${*}</delimiter>\n\u00a0\u00a0<delimiter>@</delimiter>\n</delimiters>\n\nSince the '@' delimiter is the same on both ends, we don't need to specify '@*@' (though we can).\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The character encoding scheme to be applied when filtering resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapeString (Default: ${maven.resources.escapeString})", 2);
                this.append(sb, "Expression preceded with the String won't be interpolated \\${foo} will be replaced with ${foo}", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapeWindowsPaths (Default: true)", 2);
                this.append(sb, "Whether to escape backslashes and colons in windows-style paths.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filters", 2);
                this.append(sb, "The list of extra filter properties files to be used along with System properties, project properties, and filter properties files specified in the POM build/filters section, which should be used for the filtering during the current mojo execution.\nNormally, these will be configured from a plugin's execution section, to provide a different set of filters for a particular execution. For instance, starting in Maven 2.2.0, you have the option of configuring executions with the id's default-resources and default-testResources to supply different configurations for the two different types of resources. By supplying extraFilters configurations, you can separate which filters are used for which type of resource.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeEmptyDirs (Default: false)", 2);
                this.append(sb, "Copy any empty directories included in the Ressources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "nonFilteredFileExtensions", 2);
                this.append(sb, "Additionnal file extensions to not apply filtering (already defined are : jpg, jpeg, gif, bmp, png)", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "The output directory into which to copy the resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "overwrite (Default: false)", 2);
                this.append(sb, "Overwrite existing files even if the destination files are newer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useBuildFilters (Default: true)", 2);
                this.append(sb, "If false, don't use the filters specified in the build/filters section of the POM when processing resources in this mojo execution.\nSee also: ResourcesMojo.buildFilters and ResourcesMojo.filters", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultDelimiters (Default: true)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "testResources".equals(this.goal)) {
            this.append(sb, "resources:testResources", 0);
            this.append(sb, "Copy resources for the test source code to the test output directory.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "delimiters", 2);
                this.append(sb, "Set of delimiters for expressions to filter within the resources. These delimiters are specified in the form 'beginToken*endToken'. If no '*' is given, the delimiter is assumed to be the same for start and end.\n\nSo, the default filtering delimiters might be specified as:\n\n<delimiters>\n\u00a0\u00a0<delimiter>${*}</delimiter>\n\u00a0\u00a0<delimiter>@</delimiter>\n</delimiters>\n\nSince the '@' delimiter is the same on both ends, we don't need to specify '@*@' (though we can).\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "The character encoding scheme to be applied when filtering resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapeString (Default: ${maven.resources.escapeString})", 2);
                this.append(sb, "Expression preceded with the String won't be interpolated \\${foo} will be replaced with ${foo}", 3);
                this.append(sb, "", 0);
                this.append(sb, "escapeWindowsPaths (Default: true)", 2);
                this.append(sb, "Whether to escape backslashes and colons in windows-style paths.", 3);
                this.append(sb, "", 0);
                this.append(sb, "filters", 2);
                this.append(sb, "The list of extra filter properties files to be used along with System properties, project properties, and filter properties files specified in the POM build/filters section, which should be used for the filtering during the current mojo execution.\nNormally, these will be configured from a plugin's execution section, to provide a different set of filters for a particular execution. For instance, starting in Maven 2.2.0, you have the option of configuring executions with the id's default-resources and default-testResources to supply different configurations for the two different types of resources. By supplying extraFilters configurations, you can separate which filters are used for which type of resource.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeEmptyDirs (Default: false)", 2);
                this.append(sb, "Copy any empty directories included in the Ressources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "nonFilteredFileExtensions", 2);
                this.append(sb, "Additionnal file extensions to not apply filtering (already defined are : jpg, jpeg, gif, bmp, png)", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory", 2);
                this.append(sb, "The output directory into which to copy the resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "overwrite (Default: false)", 2);
                this.append(sb, "Overwrite existing files even if the destination files are newer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "useBuildFilters (Default: true)", 2);
                this.append(sb, "If false, don't use the filters specified in the build/filters section of the POM when processing resources in this mojo execution.\nSee also: ResourcesMojo.buildFilters and ResourcesMojo.filters", 3);
                this.append(sb, "", 0);
                this.append(sb, "useDefaultDelimiters (Default: true)", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

