/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.shade.resource;

import com.google.common.io.LineReader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.shade.relocation.Relocator;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;

public class ServicesResourceTransformer
implements ResourceTransformer {
    private static final String SERVICES_PATH = "META-INF/services";
    private Map<String, ServiceStream> serviceEntries = new HashMap<String, ServiceStream>();
    private List<Relocator> relocators;

    @Override
    public boolean canTransformResource(String resource) {
        return resource.startsWith(SERVICES_PATH);
    }

    @Override
    public void processResource(String resource, InputStream is, List<Relocator> relocators) throws IOException {
        String line;
        ServiceStream out = this.serviceEntries.get(resource);
        if (out == null) {
            out = new ServiceStream();
            this.serviceEntries.put(resource, out);
        }
        ServiceStream fout = out;
        String content = IOUtils.toString((InputStream)is);
        StringReader reader = new StringReader(content);
        LineReader lineReader = new LineReader((Readable)reader);
        while ((line = lineReader.readLine()) != null) {
            String relContent = line;
            for (Relocator relocator : relocators) {
                if (!relocator.canRelocateClass(relContent)) continue;
                relContent = relocator.applyToSourceContent(relContent);
            }
            fout.append(relContent + "\n");
        }
        if (this.relocators == null) {
            this.relocators = relocators;
        }
    }

    @Override
    public boolean hasTransformedResource() {
        return this.serviceEntries.size() > 0;
    }

    @Override
    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        for (Map.Entry<String, ServiceStream> entry : this.serviceEntries.entrySet()) {
            String className;
            String key = entry.getKey();
            ServiceStream data = entry.getValue();
            if (this.relocators != null) {
                key = key.substring(SERVICES_PATH.length() + 1);
                for (Relocator relocator : this.relocators) {
                    if (!relocator.canRelocateClass(key)) continue;
                    key = relocator.relocateClass(key);
                    break;
                }
                key = "META-INF/services/" + key;
            }
            jos.putNextEntry(new JarEntry(key));
            PrintWriter writer = new PrintWriter(jos);
            InputStreamReader streamReader = new InputStreamReader(data.toInputStream());
            BufferedReader reader = new BufferedReader(streamReader);
            while ((className = reader.readLine()) != null) {
                writer.println(className);
                writer.flush();
            }
            reader.close();
            data.reset();
        }
    }

    static class ServiceStream
    extends ByteArrayOutputStream {
        ServiceStream() {
            super(1024);
        }

        public void append(String content) throws IOException {
            if (this.count > 0 && this.buf[this.count - 1] != 10 && this.buf[this.count - 1] != 13) {
                this.write(10);
            }
            byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
            this.write(contentBytes);
        }

        public InputStream toInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }
}

