/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war.packaging;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.input.XmlStreamReader;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.war.packaging.WarPackagingContext;
import org.apache.maven.plugin.war.packaging.WarPackagingTask;
import org.apache.maven.plugin.war.util.MappingUtils;
import org.apache.maven.plugin.war.util.PathSet;
import org.apache.maven.plugin.war.util.WebappStructure;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public abstract class AbstractWarPackagingTask
implements WarPackagingTask {
    public static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    public static final String WEB_INF_PATH = "WEB-INF";
    public static final String META_INF_PATH = "META-INF";
    public static final String CLASSES_PATH = "WEB-INF/classes/";
    public static final String LIB_PATH = "WEB-INF/lib/";

    protected void copyFiles(String sourceId, WarPackagingContext context, File sourceBaseDir, PathSet sourceFilesSet, String targetPrefix, boolean filtered) throws IOException, MojoExecutionException {
        for (String fileToCopyName : sourceFilesSet.paths()) {
            File sourceFile = new File(sourceBaseDir, fileToCopyName);
            String destinationFileName = targetPrefix == null ? fileToCopyName : targetPrefix + fileToCopyName;
            if (filtered && !context.isNonFilteredExtension(sourceFile.getName())) {
                this.copyFilteredFile(sourceId, context, sourceFile, destinationFileName);
                continue;
            }
            this.copyFile(sourceId, context, sourceFile, destinationFileName);
        }
    }

    protected void copyFiles(String sourceId, WarPackagingContext context, File sourceBaseDir, PathSet sourceFilesSet, boolean filtered) throws IOException, MojoExecutionException {
        this.copyFiles(sourceId, context, sourceBaseDir, sourceFilesSet, null, filtered);
    }

    protected void copyFile(String sourceId, final WarPackagingContext context, final File file, String targetFilename) throws IOException {
        final File targetFile = new File(context.getWebappDirectory(), targetFilename);
        if (file.isFile()) {
            context.getWebappStructure().registerFile(sourceId, targetFilename, new WebappStructure.RegistrationCallback(){

                public void registered(String ownerId, String targetFilename) throws IOException {
                    AbstractWarPackagingTask.this.copyFile(context, file, targetFile, targetFilename, false);
                }

                public void alreadyRegistered(String ownerId, String targetFilename) throws IOException {
                    AbstractWarPackagingTask.this.copyFile(context, file, targetFile, targetFilename, true);
                }

                public void refused(String ownerId, String targetFilename, String actualOwnerId) throws IOException {
                    context.getLog().debug((CharSequence)(" - " + targetFilename + " wasn't copied because it has " + "already been packaged for overlay [" + actualOwnerId + "]."));
                }

                public void superseded(String ownerId, String targetFilename, String deprecatedOwnerId) throws IOException {
                    context.getLog().info((CharSequence)("File [" + targetFilename + "] belonged to overlay [" + deprecatedOwnerId + "] so it will be overwritten."));
                    AbstractWarPackagingTask.this.copyFile(context, file, targetFile, targetFilename, false);
                }

                public void supersededUnknownOwner(String ownerId, String targetFilename, String unknownOwnerId) throws IOException {
                    context.getLog().warn((CharSequence)("File [" + targetFilename + "] belonged to overlay [" + unknownOwnerId + "] which does not exist anymore in the current project. It is recommended to invoke " + "clean if the dependencies of the project changed."));
                    AbstractWarPackagingTask.this.copyFile(context, file, targetFile, targetFilename, false);
                }
            });
        } else if (!targetFile.exists() && !targetFile.mkdirs()) {
            context.getLog().info((CharSequence)("Failed to create directory " + targetFile.getAbsolutePath()));
        }
    }

    protected boolean copyFilteredFile(String sourceId, WarPackagingContext context, File file, String targetFilename) throws IOException, MojoExecutionException {
        if (context.getWebappStructure().registerFile(sourceId, targetFilename)) {
            String encoding;
            File targetFile = new File(context.getWebappDirectory(), targetFilename);
            try {
                encoding = this.isXmlFile(file) ? this.getEncoding(file) : context.getResourceEncoding();
                targetFile.getParentFile().mkdirs();
                context.getMavenFileFilter().copyFile(file, targetFile, true, context.getFilterWrappers(), encoding);
            }
            catch (MavenFilteringException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            context.getLog().debug((CharSequence)(" + " + targetFilename + " has been copied (filtered encoding='" + encoding + "')."));
            return true;
        }
        context.getLog().debug((CharSequence)(" - " + targetFilename + " wasn't copied because it has already been packaged (filtered)."));
        return false;
    }

    protected void doUnpack(WarPackagingContext context, File file, File unpackDirectory) throws MojoExecutionException {
        String archiveExt = FileUtils.getExtension((String)file.getAbsolutePath()).toLowerCase();
        try {
            UnArchiver unArchiver = context.getArchiverManager().getUnArchiver(archiveExt);
            unArchiver.setSourceFile(file);
            unArchiver.setUseJvmChmod(context.isUseJvmChmod());
            unArchiver.setDestDirectory(unpackDirectory);
            unArchiver.setOverwrite(true);
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file [" + file.getAbsolutePath() + "]" + "to [" + unpackDirectory.getAbsolutePath() + "]", (Exception)((Object)e));
        }
        catch (NoSuchArchiverException e) {
            context.getLog().warn((CharSequence)("Skip unpacking dependency file [" + file.getAbsolutePath() + " with unknown extension [" + archiveExt + "]"));
        }
    }

    protected boolean copyFile(WarPackagingContext context, File source, File destination, String targetFilename, boolean onlyIfModified) throws IOException {
        if (onlyIfModified && destination.lastModified() >= source.lastModified()) {
            context.getLog().debug((CharSequence)(" * " + targetFilename + " is up to date."));
            return false;
        }
        if (source.isDirectory()) {
            context.getLog().warn((CharSequence)(" + " + targetFilename + " is packaged from the source folder"));
            try {
                JarArchiver archiver = context.getJarArchiver();
                archiver.addDirectory(source);
                archiver.setDestFile(destination);
                archiver.createArchive();
            }
            catch (ArchiverException e) {
                String msg = "Failed to create " + targetFilename;
                context.getLog().error((CharSequence)msg, (Throwable)e);
                IOException ioe = new IOException(msg);
                ioe.initCause(e);
                throw ioe;
            }
        } else {
            FileUtils.copyFile((File)source.getCanonicalFile(), (File)destination);
            destination.setLastModified(source.lastModified());
            context.getLog().debug((CharSequence)(" + " + targetFilename + " has been copied."));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getEncoding(File webXml) throws IOException {
        XmlStreamReader xmlReader = new XmlStreamReader(webXml);
        try {
            String string = xmlReader.getEncoding();
            return string;
        }
        finally {
            IOUtil.close((Reader)xmlReader);
        }
    }

    protected PathSet getFilesToIncludes(File baseDir, String[] includes, String[] excludes) {
        return this.getFilesToIncludes(baseDir, includes, excludes, false);
    }

    protected PathSet getFilesToIncludes(File baseDir, String[] includes, String[] excludes, boolean includeDirectories) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir);
        if (excludes != null) {
            scanner.setExcludes(excludes);
        }
        scanner.addDefaultExcludes();
        if (includes != null && includes.length > 0) {
            scanner.setIncludes(includes);
        } else {
            scanner.setIncludes(DEFAULT_INCLUDES);
        }
        scanner.scan();
        PathSet pathSet = new PathSet(scanner.getIncludedFiles());
        if (includeDirectories) {
            pathSet.addAll(scanner.getIncludedDirectories());
        }
        return pathSet;
    }

    protected String getArtifactFinalName(WarPackagingContext context, Artifact artifact) throws InterpolationException {
        if (context.getOutputFileNameMapping() != null) {
            return MappingUtils.evaluateFileNameMapping(context.getOutputFileNameMapping(), artifact);
        }
        String classifier = artifact.getClassifier();
        if (classifier != null && !"".equals(classifier.trim())) {
            return MappingUtils.evaluateFileNameMapping("@{artifactId}@-@{baseVersion}@-@{classifier}@.@{extension}@", artifact);
        }
        return MappingUtils.evaluateFileNameMapping("@{artifactId}@-@{baseVersion}@.@{extension}@", artifact);
    }

    private boolean isXmlFile(File file) {
        return file != null && file.isFile() && file.getName().endsWith(".xml");
    }
}

