/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import javax.jms.TransactionInProgressException;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicSession;
import javax.transaction.xa.XAResource;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQSession_0_10;
import org.apache.qpid.client.XAResourceImpl;
import org.apache.qpid.client.message.MessageFactoryRegistry;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.SessionListener;

public class XASessionImpl
extends AMQSession_0_10
implements XASession,
XATopicSession,
XAQueueSession {
    private final XAResourceImpl _xaResource;
    private org.apache.qpid.transport.Session _qpidDtxSession;
    private Session _jmsSession;

    public XASessionImpl(Connection qpidConnection, AMQConnection con, int channelId, int defaultPrefetchHigh, int defaultPrefetchLow) {
        this(qpidConnection, con, channelId, false, 1, MessageFactoryRegistry.newDefaultRegistry(), defaultPrefetchHigh, defaultPrefetchLow, null);
    }

    public XASessionImpl(Connection qpidConnection, AMQConnection con, int channelId, int ackMode, int defaultPrefetchHigh, int defaultPrefetchLow) {
        this(qpidConnection, con, channelId, false, ackMode, MessageFactoryRegistry.newDefaultRegistry(), defaultPrefetchHigh, defaultPrefetchLow, null);
    }

    public XASessionImpl(Connection qpidConnection, AMQConnection con, int channelId, boolean transacted, int ackMode, MessageFactoryRegistry registry, int defaultPrefetchHigh, int defaultPrefetchLow, String name) {
        super(qpidConnection, con, channelId, transacted, ackMode, registry, defaultPrefetchHigh, defaultPrefetchLow, name);
        this.createSession();
        this._xaResource = new XAResourceImpl(this);
    }

    public void createSession() {
        this._qpidDtxSession = this.getQpidConnection().createSession(0L, true);
        this._qpidDtxSession.setSessionListener((SessionListener)this);
        this._qpidDtxSession.dtxSelect(new Option[0]);
    }

    public Session getSession() throws JMSException {
        if (this._jmsSession == null) {
            this._jmsSession = this.getAMQConnection().createSession(true, this.getAcknowledgeMode());
        }
        return this._jmsSession;
    }

    public XAResource getXAResource() {
        return this._xaResource;
    }

    public void commit() throws JMSException {
        throw new TransactionInProgressException("XASession:  A direct invocation of the commit operation is probibited!");
    }

    public void rollback() throws JMSException {
        throw new TransactionInProgressException("XASession: A direct invocation of the rollback operation is probibited!");
    }

    protected org.apache.qpid.transport.Session getQpidSession() {
        return this._qpidDtxSession;
    }

    public QueueSession getQueueSession() throws JMSException {
        return (QueueSession)this.getSession();
    }

    public TopicSession getTopicSession() throws JMSException {
        return (TopicSession)this.getSession();
    }

    protected void acknowledgeImpl() {
        if (this._xaResource.isEnlisted()) {
            this.acknowledgeMessage(Long.MAX_VALUE, true);
        } else {
            super.acknowledgeImpl();
        }
    }

    void resubscribe() throws AMQException {
        super.resubscribe();
        this.createSession();
    }
}

