/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.OutputStream;

public class UnsyncByteArrayOutputStream
extends OutputStream {
    private static final int INITIAL_SIZE = 8192;
    private static ThreadLocal bufCache = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new byte[8192];
        }
    };
    private byte[] buf = (byte[])bufCache.get();
    private int size = 8192;
    private int pos = 0;

    public void write(byte[] byArray) {
        int n = this.pos + byArray.length;
        if (n > this.size) {
            this.expandSize(n);
        }
        System.arraycopy(byArray, 0, this.buf, this.pos, byArray.length);
        this.pos = n;
    }

    public void write(byte[] byArray, int n, int n2) {
        int n3 = this.pos + n2;
        if (n3 > this.size) {
            this.expandSize(n3);
        }
        System.arraycopy(byArray, n, this.buf, this.pos, n2);
        this.pos = n3;
    }

    public void write(int n) {
        int n2 = this.pos + 1;
        if (n2 > this.size) {
            this.expandSize(n2);
        }
        this.buf[this.pos++] = (byte)n;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.pos];
        System.arraycopy(this.buf, 0, byArray, 0, this.pos);
        return byArray;
    }

    public void reset() {
        this.pos = 0;
    }

    private void expandSize(int n) {
        int n2;
        for (n2 = this.size; n > n2; n2 <<= 2) {
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buf, 0, byArray, 0, this.pos);
        this.buf = byArray;
        this.size = n2;
    }
}

