/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.CreateMap$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GenArrayData$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="_FUNC_(key0, value0, key1, value1, ...) - Creates a map with the given key/value pairs.", examples="\n    Examples:\n      > SELECT _FUNC_(1.0, '2', 3.0, '4');\n       {1.0:\"2\",3.0:\"4\"}\n  ")
@ScalaSignature(bytes="\u0006\u0001\t5a\u0001\u0002\u0013&\u0001JB\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0005\"Aq\n\u0001BK\u0002\u0013\u0005\u0001\u000b\u0003\u0005U\u0001\tE\t\u0015!\u0003R\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015)\u0006\u0001\"\u0001[\u0011!a\u0006\u0001#b\u0001\n\u0003i\u0006\u0002\u00034\u0001\u0011\u000b\u0007I\u0011A/\t\u000f\u001d\u0004!\u0019!C\u0005Q\"1q\u000e\u0001Q\u0001\n%DQ\u0001\u001d\u0001\u0005BACQ!\u001d\u0001\u0005BIDQ!\u001f\u0001\u0005BiD!\"a\u0001\u0001\u0011\u000b\u0007I\u0011IA\u0003\u0011\u0019\ti\u0001\u0001C!!\"Q\u0011q\u0002\u0001\t\u0006\u0004%I!!\u0005\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!9\u0011q\u0006\u0001\u0005B\u0005E\u0002bBA'\u0001\u0011\u0005\u0013q\n\u0005\n\u0003C\u0002\u0011\u0011!C\u0001\u0003GB\u0011\"!\u001b\u0001#\u0003%\t!a\u001b\t\u0013\u0005\u0005\u0005!%A\u0005\u0002\u0005\r\u0005\"CAD\u0001\u0005\u0005I\u0011IAE\u0011%\tI\nAA\u0001\n\u0003\tY\nC\u0005\u0002$\u0002\t\t\u0011\"\u0001\u0002&\"I\u00111\u0016\u0001\u0002\u0002\u0013\u0005\u0013Q\u0016\u0005\n\u0003k\u0003\u0011\u0011!C\u0001\u0003oC\u0011\"a/\u0001\u0003\u0003%\t%!0\b\u000f\u0005UW\u0005#\u0001\u0002X\u001a1A%\nE\u0001\u00033Da!\u0016\u0010\u0005\u0002\u0005\u0005\bbBAr=\u0011\u0005\u0011Q\u001d\u0005\n\u0003Gt\u0012\u0011!CA\u0003SD\u0011\"a<\u001f\u0003\u0003%\t)!=\t\u0013\t\ra$!A\u0005\n\t\u0015!!C\"sK\u0006$X-T1q\u0015\t1s%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0015*\u0003!\u0019\u0017\r^1msN$(B\u0001\u0016,\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Y5\nQa\u001d9be.T!AL\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0014aA8sO\u000e\u00011\u0003\u0002\u00014ou\u0002\"\u0001N\u001b\u000e\u0003\u0015J!AN\u0013\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u00029w5\t\u0011HC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014HA\u0004Qe>$Wo\u0019;\u0011\u0005ar\u0014BA :\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003!\u0019\u0007.\u001b7ee\u0016tW#\u0001\"\u0011\u0007\r[5G\u0004\u0002E\u0013:\u0011Q\tS\u0007\u0002\r*\u0011q)M\u0001\u0007yI|w\u000e\u001e \n\u0003iJ!AS\u001d\u0002\u000fA\f7m[1hK&\u0011A*\u0014\u0002\u0004'\u0016\f(B\u0001&:\u0003%\u0019\u0007.\u001b7ee\u0016t\u0007%\u0001\fvg\u0016\u001cFO]5oORK\b/Z,iK:,U\u000e\u001d;z+\u0005\t\u0006C\u0001\u001dS\u0013\t\u0019\u0016HA\u0004C_>dW-\u00198\u0002/U\u001cXm\u0015;sS:<G+\u001f9f/\",g.R7qif\u0004\u0013A\u0002\u001fj]&$h\bF\u0002X1f\u0003\"\u0001\u000e\u0001\t\u000b\u0001+\u0001\u0019\u0001\"\t\u000b=+\u0001\u0019A)\u0015\u0005][\u0006\"\u0002!\u0007\u0001\u0004\u0011\u0015\u0001B6fsN,\u0012A\u0018\t\u0004?\u0012\u001cT\"\u00011\u000b\u0005\u0005\u0014\u0017!C5n[V$\u0018M\u00197f\u0015\t\u0019\u0017(\u0001\u0006d_2dWm\u0019;j_:L!!\u001a1\u0003\u0015%sG-\u001a=fIN+\u0017/\u0001\u0004wC2,Xm]\u0001\u0013I\u00164\u0017-\u001e7u\u000b2,W.\u001a8u)f\u0004X-F\u0001j!\tQW.D\u0001l\u0015\ta\u0017&A\u0003usB,7/\u0003\u0002oW\nAA)\u0019;b)f\u0004X-A\neK\u001a\fW\u000f\u001c;FY\u0016lWM\u001c;UsB,\u0007%\u0001\u0005g_2$\u0017M\u00197f\u0003)\u0019HO]5oO\u0006\u0013xm]\u000b\u0002gB\u00191\t\u001e<\n\u0005Ul%\u0001C%uKJ\fGo\u001c:\u0011\u0005a:\u0018B\u0001=:\u0005\r\te._\u0001\u0014G\",7m[%oaV$H)\u0019;b)f\u0004Xm\u001d\u000b\u0002wB\u0011Ap`\u0007\u0002{*\u0011apJ\u0001\tC:\fG._:jg&\u0019\u0011\u0011A?\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003\u000f\u00012A[A\u0005\u0013\r\tYa\u001b\u0002\b\u001b\u0006\u0004H+\u001f9f\u0003!qW\u000f\u001c7bE2,\u0017AC7ba\n+\u0018\u000e\u001c3feV\u0011\u00111\u0003\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D\u0014\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003;\t9B\u0001\u000bBeJ\f\u0017PQ1tK\u0012l\u0015\r\u001d\"vS2$WM]\u0001\u0005KZ\fG\u000eF\u0002w\u0003GA\u0011\"!\n\u0012!\u0003\u0005\r!a\n\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005%\u00121F\u0007\u0002O%\u0019\u0011QF\u0014\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$b!a\r\u0002@\u0005%\u0003\u0003BA\u001b\u0003wi!!a\u000e\u000b\u0007\u0005eR%A\u0004d_\u0012,w-\u001a8\n\t\u0005u\u0012q\u0007\u0002\t\u000bb\u0004(oQ8eK\"9\u0011\u0011\t\nA\u0002\u0005\r\u0013aA2uqB!\u0011QGA#\u0013\u0011\t9%a\u000e\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u00111\n\nA\u0002\u0005M\u0012AA3w\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003#\u0002B!a\u0015\u0002\\9!\u0011QKA,!\t)\u0015(C\u0002\u0002Ze\na\u0001\u0015:fI\u00164\u0017\u0002BA/\u0003?\u0012aa\u0015;sS:<'bAA-s\u0005!1m\u001c9z)\u00159\u0016QMA4\u0011\u001d\u0001E\u0003%AA\u0002\tCqa\u0014\u000b\u0011\u0002\u0003\u0007\u0011+\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u00055$f\u0001\"\u0002p-\u0012\u0011\u0011\u000f\t\u0005\u0003g\ni(\u0004\u0002\u0002v)!\u0011qOA=\u0003%)hn\u00195fG.,GMC\u0002\u0002|e\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty(!\u001e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0015%fA)\u0002p\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a#\u0011\t\u00055\u0015qS\u0007\u0003\u0003\u001fSA!!%\u0002\u0014\u0006!A.\u00198h\u0015\t\t)*\u0001\u0003kCZ\f\u0017\u0002BA/\u0003\u001f\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!(\u0011\u0007a\ny*C\u0002\u0002\"f\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2A^AT\u0011%\tI+GA\u0001\u0002\u0004\ti*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003_\u0003R!!-\u00024Zl\u0011AY\u0005\u0003k\n\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004#\u0006e\u0006\u0002CAU7\u0005\u0005\t\u0019\u0001<\u0002\r\u0015\fX/\u00197t)\r\t\u0016q\u0018\u0005\t\u0003Sc\u0012\u0011!a\u0001m\"Z\u0001!a1\u0002J\u0006-\u0017qZAi!\r!\u0014QY\u0005\u0004\u0003\u000f,#!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u001b\fqk\u0018$V\u001d\u000e{\u0006f[3za1\u0002c/\u00197vKBb\u0003e[3zc1\u0002c/\u00197vKFb\u0003E\f\u0018/S\u0001j\u0003e\u0011:fCR,7\u000fI1![\u0006\u0004\be^5uQ\u0002\"\b.\u001a\u0011hSZ,g\u000eI6fs>2\u0018\r\\;fAA\f\u0017N]:/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAj\u0003US\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\r\u00181Y\u0001:#g\n\u0017!g9\u0002D\u0006I\u00145O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e_\u0019/ai\u0012#G\t\u00174]AR$\u0005\u000e\u0012~\u0015\u0001\u0002\u0013!C\"sK\u0006$X-T1q!\t!dd\u0005\u0003\u001f\u00037l\u0004c\u0001\u001d\u0002^&\u0019\u0011q\\\u001d\u0003\r\u0005s\u0017PU3g)\t\t9.A\u0003baBd\u0017\u0010F\u0002X\u0003ODQ\u0001\u0011\u0011A\u0002\t#RaVAv\u0003[DQ\u0001Q\u0011A\u0002\tCQaT\u0011A\u0002E\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002t\u0006}\b#\u0002\u001d\u0002v\u0006e\u0018bAA|s\t1q\n\u001d;j_:\u0004R\u0001OA~\u0005FK1!!@:\u0005\u0019!V\u000f\u001d7fe!A!\u0011\u0001\u0012\u0002\u0002\u0003\u0007q+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!q\u0001\t\u0005\u0003\u001b\u0013I!\u0003\u0003\u0003\f\u0005=%AB(cU\u0016\u001cG\u000f")
public class CreateMap
extends Expression
implements scala.Serializable {
    private IndexedSeq<Expression> keys;
    private IndexedSeq<Expression> values;
    private MapType dataType;
    private ArrayBasedMapBuilder mapBuilder;
    private final Seq<Expression> children;
    private final boolean useStringTypeWhenEmpty;
    private final DataType defaultElementType;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(CreateMap createMap) {
        return CreateMap$.MODULE$.unapply(createMap);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean useStringTypeWhenEmpty() {
        return this.useStringTypeWhenEmpty;
    }

    private IndexedSeq<Expression> keys$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.keys = (IndexedSeq)((TraversableLike)this.children().indices().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 % 2 == 0)).map(this.children(), IndexedSeq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.keys;
    }

    public IndexedSeq<Expression> keys() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.keys$lzycompute() : this.keys;
    }

    private IndexedSeq<Expression> values$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.values = (IndexedSeq)((TraversableLike)this.children().indices().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> x$9 % 2 != 0)).map(this.children(), IndexedSeq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.values;
    }

    public IndexedSeq<Expression> values() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.values$lzycompute() : this.values;
    }

    private DataType defaultElementType() {
        return this.defaultElementType;
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.foldable()));
    }

    @Override
    public Iterator<Object> stringArgs() {
        return super.stringArgs().take(1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.children().size() % 2 != 0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(45).append(this.prettyName()).append(" expects a positive even number of arguments.").toString()) : (!TypeCoercion$.MODULE$.haveSameType((Seq<DataType>)((Seq)this.keys().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(73).append("The given keys of function map should all be the same type, but they are ").append(((TraversableOnce)this.keys().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.dataType().catalogString(), IndexedSeq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString()) : (!TypeCoercion$.MODULE$.haveSameType((Seq<DataType>)((Seq)this.values().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(75).append("The given values of function map should all be the same type, but they are ").append(((TraversableOnce)this.values().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.dataType().catalogString(), IndexedSeq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString()) : TypeUtils$.MODULE$.checkForMapKeyType(this.dataType().keyType())));
    }

    private MapType dataType$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.dataType = new MapType((DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags((Seq<DataType>)((Seq)this.keys().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.defaultElementType()), (DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags((Seq<DataType>)((Seq)this.values().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.defaultElementType()), this.values().exists((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.nullable())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.dataType;
    }

    @Override
    public MapType dataType() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.mapBuilder = new ArrayBasedMapBuilder(this.dataType().keyType(), this.dataType().valueType());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.mapBuilder$lzycompute() : this.mapBuilder;
    }

    @Override
    public Object eval(InternalRow input) {
        for (int i = 0; i < this.keys().length(); ++i) {
            this.mapBuilder().put(((Expression)this.keys().apply(i)).eval(input), ((Expression)this.values().apply(i)).eval(input));
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        MapType mapType = this.dataType();
        if (mapType == null) {
            throw new MatchError((Object)mapType);
        }
        DataType keyDt = mapType.keyType();
        DataType valueDt = mapType.valueType();
        Tuple2 tuple2 = new Tuple2((Object)keyDt, (Object)valueDt);
        Tuple2 tuple22 = tuple2;
        DataType keyDt2 = (DataType)tuple22._1();
        DataType valueDt2 = (DataType)tuple22._2();
        Tuple3<String, String, String> tuple3 = GenArrayData$.MODULE$.genCodeToCreateArrayData(ctx, keyDt2, (Seq<Expression>)this.keys(), "createMap");
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String allocationKeyData = (String)tuple3._1();
        String assignKeys = (String)tuple3._2();
        String keyArrayData = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)allocationKeyData, (Object)assignKeys, (Object)keyArrayData);
        Tuple3 tuple33 = tuple32;
        String allocationKeyData2 = (String)tuple33._1();
        String assignKeys2 = (String)tuple33._2();
        String keyArrayData2 = (String)tuple33._3();
        Tuple3<String, String, String> tuple34 = GenArrayData$.MODULE$.genCodeToCreateArrayData(ctx, valueDt2, (Seq<Expression>)this.values(), "createMap");
        if (tuple34 == null) {
            throw new MatchError(tuple34);
        }
        String allocationValueData = (String)tuple34._1();
        String assignValues = (String)tuple34._2();
        String valueArrayData = (String)tuple34._3();
        Tuple3 tuple35 = new Tuple3((Object)allocationValueData, (Object)assignValues, (Object)valueArrayData);
        Tuple3 tuple36 = tuple35;
        String allocationValueData2 = (String)tuple36._1();
        String assignValues2 = (String)tuple36._2();
        String valueArrayData2 = (String)tuple36._3();
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        Block code = Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       ", "\n       ", "\n       ", "\n       ", "\n       final MapData ", " = ", ".from(", ", ", ");\n      "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{allocationKeyData2, assignKeys2, allocationValueData2, assignValues2, ev.value(), builderTerm, keyArrayData2, valueArrayData2}));
        return ev.copy(code, FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return "map";
    }

    public CreateMap copy(Seq<Expression> children2, boolean useStringTypeWhenEmpty) {
        return new CreateMap(children2, useStringTypeWhenEmpty);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.useStringTypeWhenEmpty();
    }

    @Override
    public String productPrefix() {
        return "CreateMap";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.useStringTypeWhenEmpty());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateMap createMap = (CreateMap)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = createMap.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.useStringTypeWhenEmpty() != createMap.useStringTypeWhenEmpty()) return false;
        if (!createMap.canEqual(this)) return false;
        return true;
    }

    public CreateMap(Seq<Expression> children2, boolean useStringTypeWhenEmpty) {
        this.children = children2;
        this.useStringTypeWhenEmpty = useStringTypeWhenEmpty;
        this.defaultElementType = useStringTypeWhenEmpty ? StringType$.MODULE$ : NullType$.MODULE$;
    }

    public CreateMap(Seq<Expression> children2) {
        this(children2, BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_CREATE_EMPTY_COLLECTION_USING_STRING_TYPE())));
    }
}

