/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual$;
import org.apache.spark.sql.catalyst.expressions.package;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="expr1 _FUNC_ expr2 - Returns true if `expr1` is less than or equal to `expr2`.", arguments="\n    Arguments:\n      * expr1, expr2 - the two expressions must be same type or can be casted to a common type,\n          and must be a type that can be ordered. For example, map type is not orderable, so it\n          is not supported. For complex types such array/struct, the data types of fields must\n          be orderable.\n  ", examples="\n    Examples:\n      > SELECT 2 _FUNC_ 2;\n       true\n      > SELECT 1.0 _FUNC_ '1';\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-07-30 04:17:52');\n       true\n      > SELECT to_date('2009-07-30 04:17:52') _FUNC_ to_date('2009-08-01 04:17:52');\n       true\n      > SELECT 1 _FUNC_ NULL;\n       NULL\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001\u0002\r\u001a\u0001\u001aB\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0012)A\u0005{!A\u0011\t\u0001BK\u0002\u0013\u0005A\b\u0003\u0005C\u0001\tE\t\u0015!\u0003>\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u0015A\u0005\u0001\"\u0011J\u0011\u0015)\u0006\u0001\"\u0015W\u0011\u001dq\u0006!!A\u0005\u0002}CqA\u0019\u0001\u0012\u0002\u0013\u00051\rC\u0004o\u0001E\u0005I\u0011A2\t\u000f=\u0004\u0011\u0011!C!a\"9\u0001\u0010AA\u0001\n\u0003I\bbB?\u0001\u0003\u0003%\tA \u0005\n\u0003\u0007\u0001\u0011\u0011!C!\u0003\u000bA\u0011\"a\u0005\u0001\u0003\u0003%\t!!\u0006\t\u0013\u0005}\u0001!!A\u0005B\u0005\u0005r!CA 3\u0005\u0005\t\u0012AA!\r!A\u0012$!A\t\u0002\u0005\r\u0003BB\"\u0013\t\u0003\t\t\u0006C\u0005\u0002TI\t\t\u0011\"\u0012\u0002V!I\u0011q\u000b\n\u0002\u0002\u0013\u0005\u0015\u0011\f\u0005\n\u0003?\u0012\u0012\u0011!CA\u0003CB\u0011\"a\u001d\u0013\u0003\u0003%I!!\u001e\u0003\u001f1+7o\u001d+iC:|%/R9vC2T!AG\u000e\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u00039u\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003=}\t1a]9m\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0006\u0001\u001dZ#\u0007\u000f\t\u0003Q%j\u0011!G\u0005\u0003Ue\u0011\u0001CQ5oCJL8i\\7qCJL7o\u001c8\u0011\u00051zcB\u0001\u0015.\u0013\tq\u0013$A\u0004qC\u000e\\\u0017mZ3\n\u0005A\n$A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003]e\u0001\"a\r\u001c\u000e\u0003QR\u0011!N\u0001\u0006g\u000e\fG.Y\u0005\u0003oQ\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00024s%\u0011!\b\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005Y\u00164G/F\u0001>!\tAc(\u0003\u0002@3\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u0019QIR$\u0011\u0005!\u0002\u0001\"B\u001e\u0006\u0001\u0004i\u0004\"B!\u0006\u0001\u0004i\u0014AB:z[\n|G.F\u0001K!\tY%K\u0004\u0002M!B\u0011Q\nN\u0007\u0002\u001d*\u0011q*J\u0001\u0007yI|w\u000e\u001e \n\u0005E#\u0014A\u0002)sK\u0012,g-\u0003\u0002T)\n11\u000b\u001e:j]\u001eT!!\u0015\u001b\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0007]SF\f\u0005\u000241&\u0011\u0011\f\u000e\u0002\u0004\u0003:L\b\"B.\b\u0001\u00049\u0016AB5oaV$\u0018\u0007C\u0003^\u000f\u0001\u0007q+\u0001\u0004j]B,HOM\u0001\u0005G>\u0004\u0018\u0010F\u0002FA\u0006Dqa\u000f\u0005\u0011\u0002\u0003\u0007Q\bC\u0004B\u0011A\u0005\t\u0019A\u001f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tAM\u000b\u0002>K.\na\r\u0005\u0002hY6\t\u0001N\u0003\u0002jU\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003WR\n!\"\u00198o_R\fG/[8o\u0013\ti\u0007NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002cB\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0005Y\u0006twMC\u0001w\u0003\u0011Q\u0017M^1\n\u0005M\u001b\u0018\u0001\u00049s_\u0012,8\r^!sSRLX#\u0001>\u0011\u0005MZ\u0018B\u0001?5\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\t9v\u0010\u0003\u0005\u0002\u00025\t\t\u00111\u0001{\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0001\t\u0006\u0003\u0013\tyaV\u0007\u0003\u0003\u0017Q1!!\u00045\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003#\tYA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\f\u0003;\u00012aMA\r\u0013\r\tY\u0002\u000e\u0002\b\u0005>|G.Z1o\u0011!\t\taDA\u0001\u0002\u00049\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0018\u0005\r\u0002\u0002CA\u0001!\u0005\u0005\t\u0019A,)\u001f\u0001\t9#!\f\u00020\u0005M\u0012QGA\u001d\u0003w\u00012\u0001KA\u0015\u0013\r\tY#\u0007\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t$\u0001(fqB\u0014\u0018\u0007I0G+:\u001bu\fI3yaJ\u0014\u0004%\f\u0011SKR,(O\\:!iJ,X\rI5gA\u0001,\u0007\u0010\u001d:2A\u0002J7\u000f\t7fgN\u0004C\u000f[1oA=\u0014\b%Z9vC2\u0004Co\u001c\u0011aKb\u0004(O\r1/\u0003%\t'oZ;nK:$8/\t\u0002\u00028\u0005\u0011\u0019J\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!Kb\u0004(/\r\u0017!Kb\u0004(O\r\u0011.AQDW\r\t;x_\u0002*\u0007\u0010\u001d:fgNLwN\\:![V\u001cH\u000f\t2fAM\fW.\u001a\u0011usB,\u0007e\u001c:!G\u0006t\u0007EY3!G\u0006\u001cH/\u001a3!i>\u0004\u0013\rI2p[6|g\u000e\t;za\u0016d#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!C:$\u0007%\\;ti\u0002\u0012W\rI1!if\u0004X\r\t;iCR\u00043-\u00198!E\u0016\u0004sN\u001d3fe\u0016$g\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003%\\1qAQL\b/\u001a\u0011jg\u0002rw\u000e\u001e\u0011pe\u0012,'/\u00192mK2\u00023o\u001c\u0011ji*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I5tA9|G\u000fI:vaB|'\u000f^3e]\u00012uN\u001d\u0011d_6\u0004H.\u001a=!if\u0004Xm\u001d\u0011tk\u000eD\u0007%\u0019:sCf|3\u000f\u001e:vGRd\u0003\u0005\u001e5fA\u0011\fG/\u0019\u0011usB,7\u000fI8gA\u0019LW\r\u001c3tA5,8\u000f\u001e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0012W\rI8sI\u0016\u0014\u0018M\u00197f])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\ti$\u0001BP\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002\u0012\u0004e\u0018$V\u001d\u000e{\u0006EM\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u00112]A\u0002sLR+O\u0007~\u0003s%M\u0014<\u0015\u0001\u0002\u0003\u0005\t\u0011!AQ\u0014X/\u001a\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!i>|F-\u0019;fQ\u001d\u0012\u0004\u0007M\u001d.a]j3\u0007\r\u00111ii\ntGO\u001b3O%\u0002sLR+O\u0007~\u0003Co\\0eCR,\u0007f\n\u001a1aej\u0003gN\u00174a\u0001\u0002DGO\u00198uU\u0012t%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011u_~#\u0017\r^3)OI\u0002\u0004'O\u00171o5\u001a\u0004\u0007\t\u00195uE:$(\u000e\u001a(S\u0001zf)\u0016(D?\u0002\"xn\u00183bi\u0016DsE\r\u00191s5\u0002\u0004(\f\u00192AA\"$(M\u001c;kI:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011ueV,'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI\u0019!?\u001a+fjQ0!\u001dVcEj\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u001f1+7o\u001d+iC:|%/R9vC2\u0004\"\u0001\u000b\n\u0014\tI\t)\u0005\u000f\t\b\u0003\u000f\ni%P\u001fF\u001b\t\tIEC\u0002\u0002LQ\nqA];oi&lW-\u0003\u0003\u0002P\u0005%#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u0011\u0011I\u0001\ti>\u001cFO]5oOR\t\u0011/A\u0003baBd\u0017\u0010F\u0003F\u00037\ni\u0006C\u0003<+\u0001\u0007Q\bC\u0003B+\u0001\u0007Q(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\r\u0014q\u000e\t\u0006g\u0005\u0015\u0014\u0011N\u0005\u0004\u0003O\"$AB(qi&|g\u000eE\u00034\u0003WjT(C\u0002\u0002nQ\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CA9-\u0005\u0005\t\u0019A#\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAA<!\r\u0011\u0018\u0011P\u0005\u0004\u0003w\u001a(AB(cU\u0016\u001cG\u000f")
public class LessThanOrEqual
extends BinaryComparison
implements package.NullIntolerant,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(LessThanOrEqual lessThanOrEqual) {
        return LessThanOrEqual$.MODULE$.unapply(lessThanOrEqual);
    }

    public static Function1<Tuple2<Expression, Expression>, LessThanOrEqual> tupled() {
        return LessThanOrEqual$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, LessThanOrEqual>> curried() {
        return LessThanOrEqual$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String symbol() {
        return "<=";
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        return BoxesRunTime.boxToBoolean((boolean)this.ordering().lteq(input1, input2));
    }

    public LessThanOrEqual copy(Expression left, Expression right) {
        return new LessThanOrEqual(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "LessThanOrEqual";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof LessThanOrEqual;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof LessThanOrEqual)) return false;
        boolean bl = true;
        if (!bl) return false;
        LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)x$1;
        Expression expression = this.left();
        Expression expression2 = lessThanOrEqual.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = lessThanOrEqual.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!lessThanOrEqual.canEqual(this)) return false;
        return true;
    }

    public LessThanOrEqual(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

