/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MonthsBetween$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(timestamp1, timestamp2[, roundOff]) - If `timestamp1` is later than `timestamp2`, then the result\n      is positive. If `timestamp1` and `timestamp2` are on the same day of month, or both\n      are the last day of month, time of day will be ignored. Otherwise, the difference is\n      calculated based on 31 days per month, and rounded to 8 digits unless roundOff=false.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30');\n       3.94959677\n      > SELECT _FUNC_('1997-02-28 10:30:00', '1996-10-30', false);\n       3.9495967741935485\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\t%b\u0001B\u0014)\u0001VB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u001d\u0002\u0011\t\u0012)A\u0005\u0017\"Aq\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003L\u0011!\t\u0006A!f\u0001\n\u0003Q\u0005\u0002\u0003*\u0001\u0005#\u0005\u000b\u0011B&\t\u0011M\u0003!Q3A\u0005\u0002QC\u0001b\u0019\u0001\u0003\u0012\u0003\u0006I!\u0016\u0005\u0006I\u0002!\t!\u001a\u0005\u0006I\u0002!\ta\u001b\u0005\u0006I\u0002!\tA\u001c\u0005\u0006e\u0002!\te\u001d\u0005\u0006{\u0002!\tE \u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011\u001d\t9\u0002\u0001C!\u00033Aq!!\b\u0001\t\u0003\ny\u0002C\u0004\u00022\u0001!\t%a\r\t\u000f\u0005=\u0003\u0001\"\u0011\u0002R!I\u00111\u000b\u0001\u0002\u0002\u0013\u0005\u0011Q\u000b\u0005\n\u0003?\u0002\u0011\u0013!C\u0001\u0003CB\u0011\"a\u001e\u0001#\u0003%\t!!\u0019\t\u0013\u0005e\u0004!%A\u0005\u0002\u0005\u0005\u0004\"CA>\u0001E\u0005I\u0011AA?\u0011%\t\t\tAA\u0001\n\u0003\n\u0019\tC\u0005\u0002\u0014\u0002\t\t\u0011\"\u0001\u0002\u0016\"I\u0011Q\u0014\u0001\u0002\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003K\u0003\u0011\u0011!C!\u0003OC\u0011\"!.\u0001\u0003\u0003%\t!a.\t\u0013\u0005\u0005\u0007!!A\u0005B\u0005\rw!CAtQ\u0005\u0005\t\u0012AAu\r!9\u0003&!A\t\u0002\u0005-\bB\u00023 \t\u0003\tI\u0010C\u0005\u0002|~\t\t\u0011\"\u0012\u0002~\"I\u0011q`\u0010\u0002\u0002\u0013\u0005%\u0011\u0001\u0005\n\u0005\u0017y\u0012\u0013!C\u0001\u0003{B\u0011B!\u0004 \u0003\u0003%\tIa\u0004\t\u0013\tuq$%A\u0005\u0002\u0005u\u0004\"\u0003B\u0010?\u0005\u0005I\u0011\u0002B\u0011\u00055iuN\u001c;ig\n+Go^3f]*\u0011\u0011FK\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002,Y\u0005A1-\u0019;bYf\u001cHO\u0003\u0002.]\u0005\u00191/\u001d7\u000b\u0005=\u0002\u0014!B:qCJ\\'BA\u00193\u0003\u0019\t\u0007/Y2iK*\t1'A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001mij\u0004I\u0012\t\u0003oaj\u0011\u0001K\u0005\u0003s!\u0012\u0011\u0003V3s]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\t94(\u0003\u0002=Q\t9B+[7f5>tW-Q<be\u0016,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003oyJ!a\u0010\u0015\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"!\u0011#\u000e\u0003\tS\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\n\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002B\u000f&\u0011\u0001J\u0011\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006I\u0006$X-M\u000b\u0002\u0017B\u0011q\u0007T\u0005\u0003\u001b\"\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019!\u0017\r^32A\u0005)A-\u0019;fe\u00051A-\u0019;fe\u0001\n\u0001B]8v]\u0012|eMZ\u0001\ne>,h\u000eZ(gM\u0002\n!\u0002^5nKj{g.Z%e+\u0005)\u0006cA!W1&\u0011qK\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005e\u0003gB\u0001._!\tY&)D\u0001]\u0015\tiF'\u0001\u0004=e>|GOP\u0005\u0003?\n\u000ba\u0001\u0015:fI\u00164\u0017BA1c\u0005\u0019\u0019FO]5oO*\u0011qLQ\u0001\fi&lWMW8oK&#\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0006M\u001eD\u0017N\u001b\t\u0003o\u0001AQ!S\u0005A\u0002-CQaT\u0005A\u0002-CQ!U\u0005A\u0002-CqaU\u0005\u0011\u0002\u0003\u0007Q\u000bF\u0002gY6DQ!\u0013\u0006A\u0002-CQa\u0014\u0006A\u0002-#BAZ8qc\")\u0011j\u0003a\u0001\u0017\")qj\u0003a\u0001\u0017\")\u0011k\u0003a\u0001\u0017\u0006A1\r[5mIJ,g.F\u0001u!\r)(p\u0013\b\u0003mbt!aW<\n\u0003\rK!!\u001f\"\u0002\u000fA\f7m[1hK&\u00111\u0010 \u0002\u0004'\u0016\f(BA=C\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002\u007fB!QO_A\u0001!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004Y\u0005)A/\u001f9fg&!\u00111BA\u0003\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\t\t\t\u0002\u0005\u0003\u0002\u0004\u0005M\u0011\u0002BA\u000b\u0003\u000b\u0011\u0001\u0002R1uCRK\b/Z\u0001\ro&$\b\u000eV5nKj{g.\u001a\u000b\u0004u\u0005m\u0001\"B*\u0010\u0001\u0004A\u0016\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003CA\u0011\u0003O\tY#a\f\u0011\u0007\u0005\u000b\u0019#C\u0002\u0002&\t\u00131!\u00118z\u0011\u001d\tI\u0003\u0005a\u0001\u0003C\t!\u0001^\u0019\t\u000f\u00055\u0002\u00031\u0001\u0002\"\u0005\u0011AO\r\u0005\u0007#B\u0001\r!!\t\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u001b\u0003\u0003\nY\u0005\u0005\u0003\u00028\u0005uRBAA\u001d\u0015\r\tY\u0004K\u0001\bG>$WmZ3o\u0013\u0011\ty$!\u000f\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u0011\u0012\u0001\u0004\t)%A\u0002dib\u0004B!a\u000e\u0002H%!\u0011\u0011JA\u001d\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\u0014\u0012\u0001\u0004\t)$\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003a\u000bAaY8qsRIa-a\u0016\u0002Z\u0005m\u0013Q\f\u0005\b\u0013N\u0001\n\u00111\u0001L\u0011\u001dy5\u0003%AA\u0002-Cq!U\n\u0011\u0002\u0003\u00071\nC\u0004T'A\u0005\t\u0019A+\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\r\u0016\u0004\u0017\u0006\u00154FAA4!\u0011\tI'a\u001d\u000e\u0005\u0005-$\u0002BA7\u0003_\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005E$)\u0001\u0006b]:|G/\u0019;j_:LA!!\u001e\u0002l\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u007fR3!VA3\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0011\t\u0005\u0003\u000f\u000b\t*\u0004\u0002\u0002\n*!\u00111RAG\u0003\u0011a\u0017M\\4\u000b\u0005\u0005=\u0015\u0001\u00026bm\u0006L1!YAE\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\nE\u0002B\u00033K1!a'C\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t#!)\t\u0013\u0005\r&$!AA\u0002\u0005]\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002*B1\u00111VAY\u0003Ci!!!,\u000b\u0007\u0005=&)\u0001\u0006d_2dWm\u0019;j_:LA!a-\u0002.\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI,a0\u0011\u0007\u0005\u000bY,C\u0002\u0002>\n\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002$r\t\t\u00111\u0001\u0002\"\u00051Q-];bYN$B!!/\u0002F\"I\u00111U\u000f\u0002\u0002\u0003\u0007\u0011\u0011\u0005\u0015\u0014\u0001\u0005%\u0017qZAi\u0003+\f9.a7\u0002^\u0006\u0005\u00181\u001d\t\u0004o\u0005-\u0017bAAgQ\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAj\u0003\r\r!\u0002\t\u0011!A}3UKT\"`QQLW.Z:uC6\u0004\u0018\u0007\f\u0011uS6,7\u000f^1naJZF\u0006\t:pk:$wJ\u001a4^S\u0001j\u0003%\u00134!ARLW.Z:uC6\u0004\u0018\u0007\u0019\u0011jg\u0002b\u0017\r^3sAQD\u0017M\u001c\u0011ai&lWm\u001d;b[B\u0014\u0004\r\f\u0011uQ\u0016t\u0007\u0005\u001e5fAI,7/\u001e7u\u0015\u0001\u0002\u0003\u0005\t\u0011!SN\u0004\u0003o\\:ji&4XM\f\u0011JM\u0002\u0002G/[7fgR\fW\u000e]\u0019aA\u0005tG\r\t1uS6,7\u000f^1naJ\u0002\u0007%\u0019:fA=t\u0007\u0005\u001e5fAM\fW.\u001a\u0011eCf\u0004sN\u001a\u0011n_:$\b\u000e\f\u0011pe\u0002\u0012w\u000e\u001e5\u000bA\u0001\u0002\u0003\u0005\t\u0011be\u0016\u0004C\u000f[3!Y\u0006\u001cH\u000f\t3bs\u0002zg\rI7p]RDG\u0006\t;j[\u0016\u0004sN\u001a\u0011eCf\u0004s/\u001b7mA\t,\u0007%[4o_J,GM\f\u0011Pi\",'o^5tK2\u0002C\u000f[3!I&4g-\u001a:f]\u000e,\u0007%[:\u000bA\u0001\u0002\u0003\u0005\t\u0011dC2\u001cW\u000f\\1uK\u0012\u0004#-Y:fI\u0002zg\u000eI\u001a2A\u0011\f\u0017p\u001d\u0011qKJ\u0004Sn\u001c8uQ2\u0002\u0013M\u001c3!e>,h\u000eZ3eAQ|\u0007\u0005\u000f\u0011eS\u001eLGo\u001d\u0011v]2,7o\u001d\u0011s_VtGm\u00144g{\u0019\fGn]3/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005e\u0017!!\u001f\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\n\u0014(O\u001c.aIj#\u0007\u000f\u00112ai\u001a\u0004G\u000f\u00191O1\u0002s%M\u001d:m5\n\u0004'L\u001a1O%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\r\u0018:ie*\u0014HN\u001c8\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":\u0013'O\u001d8[A\u0012TF\r\u001d!cAR4\u0007\r\u001e1a\u001db\u0003eJ\u0019:sYj\u0013\u0007M\u00174a\u001db\u0003EZ1mg\u0016L3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a/sQJT'\u000f\u001c8oQ\n\u0014hM\u001b5qUR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003?\fa\u0002Z1uKRLW.Z0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002f\u0006)\u0011GL\u001b/a\u0005iQj\u001c8uQN\u0014U\r^<fK:\u0004\"aN\u0010\u0014\t}\tiO\u0012\t\n\u0003_\f)pS&L+\u001al!!!=\u000b\u0007\u0005M()A\u0004sk:$\u0018.\\3\n\t\u0005]\u0018\u0011\u001f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DCAAu\u0003!!xn\u0015;sS:<GCAAC\u0003\u0015\t\u0007\u000f\u001d7z)%1'1\u0001B\u0003\u0005\u000f\u0011I\u0001C\u0003JE\u0001\u00071\nC\u0003PE\u0001\u00071\nC\u0003RE\u0001\u00071\nC\u0004TEA\u0005\t\u0019A+\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQ\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\u0012\te\u0001\u0003B!W\u0005'\u0001r!\u0011B\u000b\u0017.[U+C\u0002\u0003\u0018\t\u0013a\u0001V;qY\u0016$\u0004\u0002\u0003B\u000eI\u0005\u0005\t\u0019\u00014\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003$A!\u0011q\u0011B\u0013\u0013\u0011\u00119#!#\u0003\r=\u0013'.Z2u\u0001")
public class MonthsBetween
extends TernaryExpression
implements TimeZoneAwareExpression,
ImplicitCastInputTypes,
scala.Serializable {
    private final Expression date1;
    private final Expression date2;
    private final Expression roundOff;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private transient ZoneId zoneId;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$4() {
        return MonthsBetween$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<Expression, Expression, Expression, Option<String>>> unapply(MonthsBetween monthsBetween) {
        return MonthsBetween$.MODULE$.unapply(monthsBetween);
    }

    public static Option<String> apply$default$4() {
        return MonthsBetween$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<Expression, Expression, Expression, Option<String>>, MonthsBetween> tupled() {
        return MonthsBetween$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<String>, MonthsBetween>>>> curried() {
        return MonthsBetween$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    private ZoneId zoneId$lzycompute() {
        MonthsBetween monthsBetween = this;
        synchronized (monthsBetween) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return !this.bitmap$trans$0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    public Expression date1() {
        return this.date1;
    }

    public Expression date2() {
        return this.date2;
    }

    public Expression roundOff() {
        return this.roundOff;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.date1(), this.date2(), this.roundOff()}));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{TimestampType$.MODULE$, TimestampType$.MODULE$, BooleanType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object t1, Object t2, Object roundOff) {
        return BoxesRunTime.boxToDouble((double)DateTimeUtils$.MODULE$.monthsBetween(BoxesRunTime.unboxToLong((Object)t1), BoxesRunTime.unboxToLong((Object)t2), BoxesRunTime.unboxToBoolean((Object)roundOff), this.zoneId()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
        String dtu = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable & scala.Serializable)(d1, d2, roundOff) -> new StringBuilder(22).append(dtu).append(".monthsBetween(").append((String)d1).append(", ").append((String)d2).append(", ").append((String)roundOff).append(", ").append(zid).append(")").toString());
    }

    @Override
    public String prettyName() {
        return "months_between";
    }

    public MonthsBetween copy(Expression date1, Expression date2, Expression roundOff, Option<String> timeZoneId) {
        return new MonthsBetween(date1, date2, roundOff, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.date1();
    }

    public Expression copy$default$2() {
        return this.date2();
    }

    public Expression copy$default$3() {
        return this.roundOff();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "MonthsBetween";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.date1();
                break;
            }
            case 1: {
                option = this.date2();
                break;
            }
            case 2: {
                option = this.roundOff();
                break;
            }
            case 3: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MonthsBetween;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MonthsBetween)) return false;
        boolean bl = true;
        if (!bl) return false;
        MonthsBetween monthsBetween = (MonthsBetween)x$1;
        Expression expression = this.date1();
        Expression expression2 = monthsBetween.date1();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.date2();
        Expression expression4 = monthsBetween.date2();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.roundOff();
        Expression expression6 = monthsBetween.roundOff();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = monthsBetween.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!monthsBetween.canEqual(this)) return false;
        return true;
    }

    public MonthsBetween(Expression date1, Expression date2, Expression roundOff, Option<String> timeZoneId) {
        this.date1 = date1;
        this.date2 = date2;
        this.roundOff = roundOff;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public MonthsBetween(Expression date1, Expression date2) {
        this(date1, date2, Literal$.MODULE$.TrueLiteral(), (Option<String>)None$.MODULE$);
    }

    public MonthsBetween(Expression date1, Expression date2, Expression roundOff) {
        this(date1, date2, roundOff, (Option<String>)None$.MODULE$);
    }
}

