/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Size$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr) - Returns the size of an array or a map.\n    The function returns null for null input if spark.sql.legacy.sizeOfNull is set to false or\n    spark.sql.ansi.enabled is set to true. Otherwise, the function returns -1 for null input.\n    With the default settings, the function returns -1 for null input.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array('b', 'd', 'c', 'a'));\n       4\n      > SELECT _FUNC_(map('a', 1, 'b', 2));\n       2\n      > SELECT _FUNC_(NULL);\n       -1\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001\u0002\u000f\u001e\u0001*B\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t\u0001\u0002\u0011\t\u0012)A\u0005{!A\u0011\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005G\u0001\tE\t\u0015!\u0003D\u0011\u00159\u0005\u0001\"\u0001I\u0011\u00159\u0005\u0001\"\u0001M\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u00151\u0006\u0001\"\u0011X\u0011\u00159\u0007\u0001\"\u0011C\u0011\u0015A\u0007\u0001\"\u0011j\u0011\u0015\u0019\b\u0001\"\u0011u\u0011%\t)\u0001AA\u0001\n\u0003\t9\u0001C\u0005\u0002\u000e\u0001\t\n\u0011\"\u0001\u0002\u0010!I\u0011Q\u0005\u0001\u0012\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003W\u0001\u0011\u0011!C!\u0003[A\u0011\"a\u0010\u0001\u0003\u0003%\t!!\u0011\t\u0013\u0005%\u0003!!A\u0005\u0002\u0005-\u0003\"CA)\u0001\u0005\u0005I\u0011IA*\u0011%\t\t\u0007AA\u0001\n\u0003\t\u0019\u0007C\u0005\u0002h\u0001\t\t\u0011\"\u0011\u0002j\u001d9\u0011\u0011Q\u000f\t\u0002\u0005\reA\u0002\u000f\u001e\u0011\u0003\t)\t\u0003\u0004H-\u0011\u0005\u0011Q\u0012\u0005\b\u0003\u001f3B\u0011AAI\u0011%\tyIFA\u0001\n\u0003\u000b)\nC\u0005\u0002\u001cZ\t\t\u0011\"!\u0002\u001e\"I\u0011q\u0016\f\u0002\u0002\u0013%\u0011\u0011\u0017\u0002\u0005'&TXM\u0003\u0002\u001f?\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0001\u0013%\u0001\u0005dCR\fG._:u\u0015\t\u00113%A\u0002tc2T!\u0001J\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\u0002\u0001'\u0015\u00011f\f\u001a9!\taS&D\u0001\u001e\u0013\tqSDA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ta\u0003'\u0003\u00022;\t\tR\t\u001f9fGR\u001c\u0018J\u001c9viRK\b/Z:\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\u000fA\u0013x\u000eZ;diB\u00111'O\u0005\u0003uQ\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fQa\u00195jY\u0012,\u0012!\u0010\t\u0003YyJ!aP\u000f\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\rI\u0001\u0011Y\u0016<\u0017mY=TSj,wJ\u001a(vY2,\u0012a\u0011\t\u0003g\u0011K!!\u0012\u001b\u0003\u000f\t{w\u000e\\3b]\u0006\tB.Z4bGf\u001c\u0016N_3PM:+H\u000e\u001c\u0011\u0002\rqJg.\u001b;?)\rI%j\u0013\t\u0003Y\u0001AQaO\u0003A\u0002uBQ!Q\u0003A\u0002\r#\"!S'\t\u000bm2\u0001\u0019A\u001f\u0002\u0011\u0011\fG/\u0019+za\u0016,\u0012\u0001\u0015\t\u0003#Rk\u0011A\u0015\u0006\u0003'\u0006\nQ\u0001^=qKNL!!\u0016*\u0003\u0011\u0011\u000bG/\u0019+za\u0016\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005A\u0006cA-bI:\u0011!l\u0018\b\u00037zk\u0011\u0001\u0018\u0006\u0003;&\na\u0001\u0010:p_Rt\u0014\"A\u001b\n\u0005\u0001$\u0014a\u00029bG.\fw-Z\u0005\u0003E\u000e\u00141aU3r\u0015\t\u0001G\u0007\u0005\u0002RK&\u0011aM\u0015\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u0001\u0005KZ\fG\u000e\u0006\u0002k[B\u00111g[\u0005\u0003YR\u00121!\u00118z\u0011\u001dq'\u0002%AA\u0002=\fQ!\u001b8qkR\u0004\"\u0001]9\u000e\u0003}I!A]\u0010\u0003\u0017%sG/\u001a:oC2\u0014vn^\u0001\nI><UM\\\"pI\u0016$B!^>\u0002\u0002A\u0011a/_\u0007\u0002o*\u0011\u00010H\u0001\bG>$WmZ3o\u0013\tQxO\u0001\u0005FqB\u00148i\u001c3f\u0011\u0015a8\u00021\u0001~\u0003\r\u0019G\u000f\u001f\t\u0003mzL!a`<\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"1\u00111A\u0006A\u0002U\f!!\u001a<\u0002\t\r|\u0007/\u001f\u000b\u0006\u0013\u0006%\u00111\u0002\u0005\bw1\u0001\n\u00111\u0001>\u0011\u001d\tE\u0002%AA\u0002\r\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0012)\u001aQ(a\u0005,\u0005\u0005U\u0001\u0003BA\f\u0003Ci!!!\u0007\u000b\t\u0005m\u0011QD\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\b5\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\tIBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002*)\u001a1)a\u0005\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u0003\u0005\u0003\u00022\u0005mRBAA\u001a\u0015\u0011\t)$a\u000e\u0002\t1\fgn\u001a\u0006\u0003\u0003s\tAA[1wC&!\u0011QHA\u001a\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\t\t\u0004g\u0005\u0015\u0013bAA$i\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019!.!\u0014\t\u0013\u0005=\u0013#!AA\u0002\u0005\r\u0013a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002VA)\u0011qKA/U6\u0011\u0011\u0011\f\u0006\u0004\u00037\"\u0014AC2pY2,7\r^5p]&!\u0011qLA-\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\r\u000b)\u0007\u0003\u0005\u0002PM\t\t\u00111\u0001k\u0003\u0019)\u0017/^1mgR\u00191)a\u001b\t\u0011\u0005=C#!AA\u0002)D3\u0002AA8\u0003k\n9(a\u001f\u0002~A\u0019A&!\u001d\n\u0007\u0005MTDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005e\u0014Aa!\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043/\u001b>fA=4\u0007%\u00198!CJ\u0014\u0018-\u001f\u0011pe\u0002\n\u0007%\\1q])\u0001\u0003\u0005\t\u0011UQ\u0016\u0004c-\u001e8di&|g\u000e\t:fiV\u0014hn\u001d\u0011ok2d\u0007EZ8sA9,H\u000e\u001c\u0011j]B,H\u000fI5gAM\u0004\u0018M]6/gFdg\u0006\\3hC\u000eLhf]5{K>3g*\u001e7mA%\u001c\be]3uAQ|\u0007EZ1mg\u0016\u0004sN\u001d\u0006!A\u0001\u00023\u000f]1sW:\u001a\u0018\u000f\u001c\u0018b]NLg&\u001a8bE2,G\rI5tAM,G\u000f\t;pAQ\u0014X/\u001a\u0018!\u001fRDWM]<jg\u0016d\u0003\u0005\u001e5fA\u0019,hn\u0019;j_:\u0004#/\u001a;ve:\u001c\b%L\u0019!M>\u0014\bE\\;mY\u0002Jg\u000e];u])\u0001\u0003\u0005\t\u0011XSRD\u0007\u0005\u001e5fA\u0011,g-Y;mi\u0002\u001aX\r\u001e;j]\u001e\u001cH\u0006\t;iK\u00022WO\\2uS>t\u0007E]3ukJt7\u000fI\u00172A\u0019|'\u000f\t8vY2\u0004\u0013N\u001c9vi:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qP\u0001\u0002R)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\":#m\n\u0017!O\u0011<C\u0006I\u0014dO1\u0002s%Y\u0014*SmR\u0001\u0005\t\u0011!A\u0001\u0002CG\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015nCBDs%Y\u0014-AEb\u0003e\n2(Y\u0001\u0012\u0014&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!e)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cc*\u0016'MSmR\u0001\u0005\t\u0011!A\u0001\u0002S&\r\u0006!A\u0005!1+\u001b>f!\tacc\u0005\u0003\u0017\u0003\u000fC\u0004cA\u001a\u0002\n&\u0019\u00111\u0012\u001b\u0003\r\u0005s\u0017PU3g)\t\t\u0019)A\u0003baBd\u0017\u0010F\u0002J\u0003'CQa\u000f\rA\u0002u\"R!SAL\u00033CQaO\rA\u0002uBQ!Q\rA\u0002\r\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002 \u0006-\u0006#B\u001a\u0002\"\u0006\u0015\u0016bAARi\t1q\n\u001d;j_:\u0004RaMAT{\rK1!!+5\u0005\u0019!V\u000f\u001d7fe!A\u0011Q\u0016\u000e\u0002\u0002\u0003\u0007\u0011*A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0017\t\u0005\u0003c\t),\u0003\u0003\u00028\u0006M\"AB(cU\u0016\u001cG\u000f")
public class Size
extends UnaryExpression
implements ExpectsInputTypes,
scala.Serializable {
    private final Expression child;
    private final boolean legacySizeOfNull;

    public static Option<Tuple2<Expression, Object>> unapply(Size size) {
        return Size$.MODULE$.unapply(size);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean legacySizeOfNull() {
        return this.legacySizeOfNull;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{ArrayType$.MODULE$, MapType$.MODULE$}))}));
    }

    @Override
    public boolean nullable() {
        return this.legacySizeOfNull() ? false : super.nullable();
    }

    @Override
    public Object eval(InternalRow input) {
        Integer n;
        Object value = this.child().eval(input);
        if (value == null) {
            n = this.legacySizeOfNull() ? BoxesRunTime.boxToInteger((int)-1) : null;
        } else {
            Integer n2;
            DataType dataType = this.child().dataType();
            if (dataType instanceof ArrayType) {
                n2 = BoxesRunTime.boxToInteger((int)((ArrayData)value).numElements());
            } else if (dataType instanceof MapType) {
                n2 = BoxesRunTime.boxToInteger((int)((MapData)value).numElements());
            } else {
                throw new UnsupportedOperationException(new StringBuilder(51).append("The size function doesn't support the operand type ").append(dataType.getClass().getCanonicalName()).toString());
            }
            n = n2;
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        if (this.legacySizeOfNull()) {
            ExprCode childGen = this.child().genCode(ctx);
            exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      boolean ", " = false;\n      ", "\n      ", " ", " = ", " ? -1 :\n        (", ").numElements();"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), childGen.code(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), childGen.isNull(), childGen.value()})), FalseLiteral$.MODULE$, ev.copy$default$3());
        } else {
            exprCode = this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(16).append("(").append((String)c).append(").numElements()").toString());
        }
        return exprCode;
    }

    public Size copy(Expression child, boolean legacySizeOfNull) {
        return new Size(child, legacySizeOfNull);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.legacySizeOfNull();
    }

    @Override
    public String productPrefix() {
        return "Size";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.legacySizeOfNull());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Size;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Size)) return false;
        boolean bl = true;
        if (!bl) return false;
        Size size = (Size)x$1;
        Expression expression = this.child();
        Expression expression2 = size.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.legacySizeOfNull() != size.legacySizeOfNull()) return false;
        if (!size.canEqual(this)) return false;
        return true;
    }

    public Size(Expression child, boolean legacySizeOfNull) {
        this.child = child;
        this.legacySizeOfNull = legacySizeOfNull;
        ExpectsInputTypes.$init$(this);
    }

    public Size(Expression child) {
        this(child, SQLConf$.MODULE$.get().legacySizeOfNull());
    }
}

