/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.SparkOrcNewRecordReader;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.hive.orc.OrcFileOperator$;
import org.apache.spark.sql.hive.orc.OrcFilters$;
import org.apache.spark.sql.hive.orc.OrcOptions;
import org.apache.spark.sql.hive.orc.OrcOutputWriter;
import org.apache.spark.sql.hive.orc.OrcRelation$;
import org.apache.spark.sql.hive.orc.OrcTableScan$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]c!B\u0001\u0003\u0001\u0019q!!D(sG\u001aKG.\u001a$pe6\fGO\u0003\u0002\u0004\t\u0005\u0019qN]2\u000b\u0005\u00151\u0011\u0001\u00025jm\u0016T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h'\u0015\u0001q\"F\u000f$!\t\u00012#D\u0001\u0012\u0015\u0005\u0011\u0012!B:dC2\f\u0017B\u0001\u000b\u0012\u0005\u0019\te.\u001f*fMB\u0011acG\u0007\u0002/)\u0011\u0001$G\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u001b\r\u0005IQ\r_3dkRLwN\\\u0005\u00039]\u0011!BR5mK\u001a{'/\\1u!\tq\u0012%D\u0001 \u0015\t\u0001c!A\u0004t_V\u00148-Z:\n\u0005\tz\"A\u0005#bi\u0006\u001cv.\u001e:dKJ+w-[:uKJ\u0004\"\u0001\u0005\u0013\n\u0005\u0015\n\"\u0001D*fe&\fG.\u001b>bE2,\u0007\"B\u0014\u0001\t\u0003I\u0013A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003)\u0002\"a\u000b\u0001\u000e\u0003\tAQ!\f\u0001\u0005B9\n\u0011b\u001d5peRt\u0015-\\3\u0015\u0003=\u0002\"\u0001M\u001a\u000f\u0005A\t\u0014B\u0001\u001a\u0012\u0003\u0019\u0001&/\u001a3fM&\u0011A'\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I\n\u0002\"B\u001c\u0001\t\u0003r\u0013\u0001\u0003;p'R\u0014\u0018N\\4\t\u000be\u0002A\u0011\t\u001e\u0002\u0017%tg-\u001a:TG\",W.\u0019\u000b\u0005w\u0011Su\nE\u0002\u0011yyJ!!P\t\u0003\r=\u0003H/[8o!\ty$)D\u0001A\u0015\t\te!A\u0003usB,7/\u0003\u0002D\u0001\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000b\u0015C\u0004\u0019\u0001$\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005\u001dCU\"\u0001\u0004\n\u0005%3!\u0001D*qCJ\\7+Z:tS>t\u0007\"B&9\u0001\u0004a\u0015aB8qi&|gn\u001d\t\u0005a5{s&\u0003\u0002Ok\t\u0019Q*\u00199\t\u000bAC\u0004\u0019A)\u0002\u000b\u0019LG.Z:\u0011\u0007ISVL\u0004\u0002T1:\u0011AkV\u0007\u0002+*\u0011a\u000bK\u0001\u0007yI|w\u000e\u001e \n\u0003II!!W\t\u0002\u000fA\f7m[1hK&\u00111\f\u0018\u0002\u0004'\u0016\f(BA-\u0012!\tq6-D\u0001`\u0015\t\u0001\u0017-\u0001\u0002gg*\u0011!MC\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u0011|&A\u0003$jY\u0016\u001cF/\u0019;vg\")a\r\u0001C!O\u0006a\u0001O]3qCJ,wK]5uKR)\u0001n\u001b7ukB\u0011a#[\u0005\u0003U^\u00111cT;uaV$xK]5uKJ4\u0015m\u0019;pefDQ!R3A\u0002\u0019CQ!\\3A\u00029\f1A[8c!\ty'/D\u0001q\u0015\t\t\u0018-A\u0005nCB\u0014X\rZ;dK&\u00111\u000f\u001d\u0002\u0004\u0015>\u0014\u0007\"B&f\u0001\u0004a\u0005\"\u0002<f\u0001\u0004q\u0014A\u00033bi\u0006\u001c6\r[3nC\")\u0001\u0010\u0001C!s\u0006Y\u0011n]*qY&$\u0018M\u00197f)\u0011QXP`@\u0011\u0005AY\u0018B\u0001?\u0012\u0005\u001d\u0011un\u001c7fC:DQ!R<A\u0002\u0019CQaS<A\u00021Cq!!\u0001x\u0001\u0004\t\u0019!\u0001\u0003qCRD\u0007c\u00010\u0002\u0006%\u0019\u0011qA0\u0003\tA\u000bG\u000f\u001b\u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0003-\u0011W/\u001b7e%\u0016\fG-\u001a:\u0015!\u0005=\u0011QFA\u0018\u0003c\t)$!\u000f\u0002F\u0005\u001d\u0003c\u0002\t\u0002\u0012\u0005U\u00111D\u0005\u0004\u0003'\t\"!\u0003$v]\u000e$\u0018n\u001c82!\r1\u0012qC\u0005\u0004\u000339\"a\u0004)beRLG/[8oK\u00124\u0015\u000e\\3\u0011\u000bI\u000bi\"!\t\n\u0007\u0005}AL\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014\r\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002,\u0005\u0015\"aC%oi\u0016\u0014h.\u00197S_^Da!RA\u0005\u0001\u00041\u0005B\u0002<\u0002\n\u0001\u0007a\bC\u0004\u00024\u0005%\u0001\u0019\u0001 \u0002\u001fA\f'\u000f^5uS>t7k\u00195f[\u0006Dq!a\u000e\u0002\n\u0001\u0007a(\u0001\bsKF,\u0018N]3e'\u000eDW-\\1\t\u0011\u0005m\u0012\u0011\u0002a\u0001\u0003{\tqAZ5mi\u0016\u00148\u000f\u0005\u0003S5\u0006}\u0002c\u0001\u0010\u0002B%\u0019\u00111I\u0010\u0003\r\u0019KG\u000e^3s\u0011\u0019Y\u0015\u0011\u0002a\u0001\u0019\"A\u0011\u0011JA\u0005\u0001\u0004\tY%\u0001\u0006iC\u0012|w\u000e]\"p]\u001a\u0004B!!\u0014\u0002T5\u0011\u0011q\n\u0006\u0004\u0003#\n\u0017\u0001B2p]\u001aLA!!\u0016\u0002P\ti1i\u001c8gS\u001e,(/\u0019;j_:\u0004")
public class OrcFileFormat
implements FileFormat,
DataSourceRegister,
Serializable {
    public boolean supportBatch(SparkSession sparkSession, StructType dataSchema) {
        return FileFormat.class.supportBatch((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        return FileFormat.class.buildReaderWithPartitionValues((FileFormat)this, (SparkSession)sparkSession, (StructType)dataSchema, (StructType)partitionSchema, (StructType)requiredSchema, filters, options, (Configuration)hadoopConf);
    }

    public OutputWriterFactory buildWriter(SQLContext sqlContext, StructType dataSchema, Map<String, String> options) {
        return FileFormat.class.buildWriter((FileFormat)this, (SQLContext)sqlContext, (StructType)dataSchema, options);
    }

    public String shortName() {
        return "orc";
    }

    public String toString() {
        return "ORC";
    }

    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return OrcFileOperator$.MODULE$.readSchema((Seq<String>)((Seq)files.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$1) {
                return x$1.getPath().toUri().toString();
            }
        }, Seq$.MODULE$.canBuildFrom())), (Option<Configuration>)new Some((Object)sparkSession.sessionState().newHadoopConf()));
    }

    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        OrcOptions orcOptions = new OrcOptions(options);
        Configuration configuration = job.getConfiguration();
        configuration.set(OrcRelation$.MODULE$.ORC_COMPRESSION(), orcOptions.compressionCodec());
        Configuration configuration2 = configuration;
        if (configuration2 instanceof JobConf) {
            JobConf jobConf = (JobConf)configuration2;
            jobConf.setOutputFormat(OrcOutputFormat.class);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            configuration2.setClass("mapred.output.format.class", OrcOutputFormat.class, OutputFormat.class);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return new OutputWriterFactory(this){

            public OutputWriter newInstance(String path, Option<Object> bucketId, StructType dataSchema, TaskAttemptContext context) {
                return new OrcOutputWriter(path, bucketId, dataSchema, context);
            }
        };
    }

    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        return true;
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        if (sparkSession.sessionState().conf().orcFilterPushDown()) {
            OrcFilters$.MODULE$.createFilter(requiredSchema, (Filter[])filters.toArray(ClassTag$.MODULE$.apply(Filter.class))).foreach((Function1)new Serializable(this, hadoopConf){
                public static final long serialVersionUID = 0L;
                private final Configuration hadoopConf$1;

                public final void apply(SearchArgument f) {
                    this.hadoopConf$1.set(OrcTableScan$.MODULE$.SARG_PUSHDOWN(), f.toKryo());
                    this.hadoopConf$1.setBoolean(HiveConf.ConfVars.HIVEOPTINDEXFILTER.varname, true);
                }
                {
                    this.hadoopConf$1 = hadoopConf$1;
                }
            });
        }
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return new Serializable(this, requiredSchema, broadcastedHadoopConf){
            public static final long serialVersionUID = 0L;
            private final StructType requiredSchema$1;
            private final Broadcast broadcastedHadoopConf$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                Iterator<InternalRow> iterator;
                Configuration conf = ((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value();
                Option<StructType> maybePhysicalSchema = OrcFileOperator$.MODULE$.readSchema((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{file.filePath()}))), (Option<Configuration>)new Some((Object)conf));
                if (maybePhysicalSchema.isEmpty()) {
                    iterator = package$.MODULE$.Iterator().empty();
                } else {
                    StructType physicalSchema = (StructType)maybePhysicalSchema.get();
                    OrcRelation$.MODULE$.setRequiredColumns(conf, physicalSchema, this.requiredSchema$1);
                    Job job = Job.getInstance((Configuration)conf);
                    FileInputFormat.setInputPaths((Job)job, (String)file.filePath());
                    FileSplit fileSplit = new FileSplit(new Path(new URI(file.filePath())), file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                    Reader orcReader = OrcFile.createReader((Path)new Path(new URI(file.filePath())), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
                    SparkOrcNewRecordReader orcRecordReader = new SparkOrcNewRecordReader(orcReader, conf, fileSplit.getStart(), fileSplit.getLength());
                    iterator = OrcRelation$.MODULE$.unwrapOrcStructs(conf, this.requiredSchema$1, (Option<StructObjectInspector>)new Some((Object)((StructObjectInspector)orcRecordReader.getObjectInspector())), (Iterator<Writable>)new RecordReaderIterator((RecordReader)orcRecordReader));
                }
                return iterator;
            }
            {
                this.requiredSchema$1 = requiredSchema$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
            }
        };
    }

    public OrcFileFormat() {
        FileFormat.class.$init$((FileFormat)this);
    }
}

