/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser$;
import org.apache.spark.sql.hive.orc.OrcFileOperator$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;

public final class OrcFileOperator$
implements Logging {
    public static final OrcFileOperator$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new OrcFileOperator$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public Option<Reader> getFileReader(String basePath, Option<Configuration> config) {
        Configuration conf = (Configuration)config.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Configuration apply() {
                return new Configuration();
            }
        });
        Path hdfsPath = new Path(basePath);
        FileSystem fs = hdfsPath.getFileSystem(conf);
        return this.listOrcFiles(basePath, conf).iterator().map((Function1)new Serializable(fs){
            public static final long serialVersionUID = 0L;
            private final FileSystem fs$1;

            public final Tuple2<Path, Reader> apply(Path path) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)path), (Object)OrcFile.createReader((FileSystem)this.fs$1, (Path)path));
            }
            {
                this.fs$1 = fs$1;
            }
        }).collectFirst((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<Path, Reader>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Reader reader;
                Path path;
                A1 A1 = x1;
                Object object = A1 != null && OrcFileOperator$.MODULE$.org$apache$spark$sql$hive$orc$OrcFileOperator$$isWithNonEmptySchema$1(path = (Path)A1._1(), reader = (Reader)A1._2()) ? reader : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Path, Reader> x1) {
                Reader reader;
                Path path;
                Tuple2<Path, Reader> tuple2 = x1;
                boolean bl = tuple2 != null && OrcFileOperator$.MODULE$.org$apache$spark$sql$hive$orc$OrcFileOperator$$isWithNonEmptySchema$1(path = (Path)tuple2._1(), reader = (Reader)tuple2._2());
                return bl;
            }
        });
    }

    public Option<Configuration> getFileReader$default$2() {
        return None$.MODULE$;
    }

    public Option<StructType> readSchema(Seq<String> paths, Option<Configuration> conf) {
        return ((TraversableLike)paths.flatMap((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final Option conf$1;

            public final Iterable<Reader> apply(String x$1) {
                return Option$.MODULE$.option2Iterable(OrcFileOperator$.MODULE$.getFileReader(x$1, (Option<Configuration>)this.conf$1));
            }
            {
                this.conf$1 = conf$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).headOption().map((Function1)new Serializable(paths){
            public static final long serialVersionUID = 0L;
            public final Seq paths$1;

            public final StructType apply(Reader reader) {
                StructObjectInspector readerInspector = (StructObjectInspector)reader.getObjectInspector();
                String schema = readerInspector.getTypeName();
                OrcFileOperator$.MODULE$.logDebug((Function0<String>)new Serializable(this, schema){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.readSchema.2 $outer;
                    private final String schema$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Reading schema from file ", ", got Hive schema string: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.paths$1, this.schema$1}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.schema$1 = schema$1;
                    }
                });
                return (StructType)CatalystSqlParser$.MODULE$.parseDataType(schema);
            }
            {
                this.paths$1 = paths$1;
            }
        });
    }

    public Option<StructObjectInspector> getObjectInspector(String path, Option<Configuration> conf) {
        return this.getFileReader(path, conf).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructObjectInspector apply(Reader x$2) {
                return (StructObjectInspector)x$2.getObjectInspector();
            }
        });
    }

    public Seq<Path> listOrcFiles(String pathStr, Configuration conf) {
        Path origPath = new Path(pathStr);
        FileSystem fs = origPath.getFileSystem(conf);
        Seq paths = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)SparkHadoopUtil$.MODULE$.get().listLeafStatuses(fs, origPath).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$3) {
                return x$3.isDirectory();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Path apply(FileStatus x$4) {
                return x$4.getPath();
            }
        }, Seq$.MODULE$.canBuildFrom())).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$5) {
                return x$5.getName().startsWith("_");
            }
        })).filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Path x$6) {
                return x$6.getName().startsWith(".");
            }
        });
        return paths;
    }

    public final boolean org$apache$spark$sql$hive$orc$OrcFileOperator$$isWithNonEmptySchema$1(Path path, Reader reader) {
        boolean bl;
        StructObjectInspector structObjectInspector;
        ObjectInspector objectInspector = reader.getObjectInspector();
        if (objectInspector instanceof StructObjectInspector && (structObjectInspector = (StructObjectInspector)objectInspector).getAllStructFieldRefs().size() == 0) {
            this.logInfo((Function0<String>)new Serializable(path){
                public static final long serialVersionUID = 0L;
                private final Path path$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ORC file ", " has empty schema, it probably contains no rows. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}))).append((Object)"Trying to read another ORC file to figure out the schema.").toString();
                }
                {
                    this.path$1 = path$1;
                }
            });
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    private OrcFileOperator$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

