/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.orc;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.Progressable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.command.CreateDataSourceTableUtils$;
import org.apache.spark.sql.execution.datasources.BucketingUtils$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.hive.orc.OrcRelation$;
import org.apache.spark.sql.hive.orc.OrcSerializer;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ma!B\u0001\u0003\u0001\tq!aD(sG>+H\u000f];u/JLG/\u001a:\u000b\u0005\r!\u0011aA8sG*\u0011QAB\u0001\u0005Q&4XM\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\"\u0001A\b\u0011\u0005A)R\"A\t\u000b\u0005I\u0019\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT!\u0001\u0006\u0004\u0002\u0013\u0015DXmY;uS>t\u0017B\u0001\f\u0012\u00051yU\u000f\u001e9vi^\u0013\u0018\u000e^3s\u0011!A\u0002A!A!\u0002\u0013Q\u0012\u0001\u00029bi\"\u001c\u0001\u0001\u0005\u0002\u001cC9\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\u00051\u0001K]3eK\u001aL!AI\u0012\u0003\rM#(/\u001b8h\u0015\t\u0001S\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0003!\u0011WoY6fi&#\u0007c\u0001\u000f(S%\u0011\u0001&\b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005qQ\u0013BA\u0016\u001e\u0005\rIe\u000e\u001e\u0005\t[\u0001\u0011\t\u0011)A\u0005]\u0005QA-\u0019;b'\u000eDW-\\1\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E2\u0011!\u0002;za\u0016\u001c\u0018BA\u001a1\u0005)\u0019FO];diRK\b/\u001a\u0005\tk\u0001\u0011\t\u0011)A\u0005m\u000591m\u001c8uKb$\bCA\u001c=\u001b\u0005A$BA\u001d;\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002<\u0015\u00051\u0001.\u00193p_BL!!\u0010\u001d\u0003%Q\u000b7o[!ui\u0016l\u0007\u000f^\"p]R,\u0007\u0010\u001e\u0005\u0006\u007f\u0001!\t\u0001Q\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0005\u001bE)\u0012$\u0011\u0005\t\u0003Q\"\u0001\u0002\t\u000baq\u0004\u0019\u0001\u000e\t\u000b\u0015r\u0004\u0019\u0001\u0014\t\u000b5r\u0004\u0019\u0001\u0018\t\u000bUr\u0004\u0019\u0001\u001c\t\r!\u0003\u0001\u0015!\u0003J\u0003\u0011\u0019wN\u001c4\u0011\u0005)cU\"A&\u000b\u0005!S\u0014BA'L\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"1q\n\u0001Q\u0001\nA\u000b!b]3sS\u0006d\u0017N_3s!\t\u0011\u0015+\u0003\u0002S\u0005\tiqJ]2TKJL\u0017\r\\5{KJDq\u0001\u0016\u0001A\u0002\u0013%Q+\u0001\rsK\u000e|'\u000fZ,sSR,'/\u00138ti\u0006tG/[1uK\u0012,\u0012A\u0016\t\u00039]K!\u0001W\u000f\u0003\u000f\t{w\u000e\\3b]\"9!\f\u0001a\u0001\n\u0013Y\u0016\u0001\b:fG>\u0014Hm\u0016:ji\u0016\u0014\u0018J\\:uC:$\u0018.\u0019;fI~#S-\u001d\u000b\u00039~\u0003\"\u0001H/\n\u0005yk\"\u0001B+oSRDq\u0001Y-\u0002\u0002\u0003\u0007a+A\u0002yIEBaA\u0019\u0001!B\u00131\u0016!\u0007:fG>\u0014Hm\u0016:ji\u0016\u0014\u0018J\\:uC:$\u0018.\u0019;fI\u0002B\u0001\u0002\u001a\u0001\t\u0006\u0004%I!Z\u0001\re\u0016\u001cwN\u001d3Xe&$XM]\u000b\u0002MB!qM\u001b7s\u001b\u0005A'BA5;\u0003\u0019i\u0017\r\u001d:fI&\u00111\u000e\u001b\u0002\r%\u0016\u001cwN\u001d3Xe&$XM\u001d\t\u0003[Bl\u0011A\u001c\u0006\u0003_j\n!![8\n\u0005Et'\u0001\u0004(vY2<&/\u001b;bE2,\u0007CA7t\u0013\t!hN\u0001\u0005Xe&$\u0018M\u00197f\u0011!1\b\u0001#A!B\u00131\u0017!\u0004:fG>\u0014Hm\u0016:ji\u0016\u0014\b\u0005C\u0003y\u0001\u0011\u0005\u00130A\u0003xe&$X\r\u0006\u0002]u\")1p\u001ea\u0001y\u0006\u0019!o\\<\u0011\u0005utX\"\u0001\u0004\n\u0005}4!a\u0001*po\"A\u00111\u0001\u0001\u0005R\u0019\t)!A\u0007xe&$X-\u00138uKJt\u0017\r\u001c\u000b\u00049\u0006\u001d\u0001bB>\u0002\u0002\u0001\u0007\u0011\u0011\u0002\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011q\u0002\u0004\u0002\u0011\r\fG/\u00197zgRLA!a\u0005\u0002\u000e\tY\u0011J\u001c;fe:\fGNU8x\u0011\u001d\t9\u0002\u0001C!\u00033\tQa\u00197pg\u0016$\u0012\u0001\u0018")
public class OrcOutputWriter
extends OutputWriter {
    private final String path;
    private final Option<Object> bucketId;
    private final TaskAttemptContext context;
    private final Configuration conf;
    private final OrcSerializer serializer;
    private boolean recordWriterInstantiated;
    private RecordWriter<NullWritable, Writable> recordWriter;
    private volatile boolean bitmap$0;

    private RecordWriter recordWriter$lzycompute() {
        OrcOutputWriter orcOutputWriter = this;
        synchronized (orcOutputWriter) {
            if (!this.bitmap$0) {
                this.recordWriterInstantiated_$eq(true);
                String uniqueWriteJobId = this.conf.get(CreateDataSourceTableUtils$.MODULE$.DATASOURCE_WRITEJOBUUID());
                TaskAttemptID taskAttemptId = this.context.getTaskAttemptID();
                int partition = taskAttemptId.getTaskID().getId();
                String bucketString = (String)this.bucketId.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(int id) {
                        return BucketingUtils$.MODULE$.bucketIdToString(id);
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                String name = this.conf.get(OrcRelation$.MODULE$.ORC_COMPRESSION());
                String compressionExtension = (String)OrcRelation$.MODULE$.extensionsForCompressionCodecNames().getOrElse((Object)name, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                int arg$1 = partition;
                String arg$2 = uniqueWriteJobId;
                String arg$3 = bucketString;
                String arg$4 = compressionExtension;
                String filename = new StringOps(Predef$.MODULE$.augmentString("part-r-%05d-%s%s%s.orc")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$1), arg$2, arg$3, arg$4}));
                this.recordWriter = new OrcOutputFormat().getRecordWriter(new Path(this.path, filename).getFileSystem(this.conf), (JobConf)this.conf, new Path(this.path, filename).toString(), (Progressable)Reporter.NULL);
                this.bitmap$0 = true;
            }
            return this.recordWriter;
        }
    }

    private boolean recordWriterInstantiated() {
        return this.recordWriterInstantiated;
    }

    private void recordWriterInstantiated_$eq(boolean x$1) {
        this.recordWriterInstantiated = x$1;
    }

    private RecordWriter<NullWritable, Writable> recordWriter() {
        return this.bitmap$0 ? this.recordWriter : this.recordWriter$lzycompute();
    }

    public void write(Row row) {
        throw new UnsupportedOperationException("call writeInternal");
    }

    public void writeInternal(InternalRow row) {
        this.recordWriter().write((Object)NullWritable.get(), (Object)this.serializer.serialize(row));
    }

    public void close() {
        if (this.recordWriterInstantiated()) {
            this.recordWriter().close(Reporter.NULL);
        }
    }

    public OrcOutputWriter(String path, Option<Object> bucketId, StructType dataSchema, TaskAttemptContext context) {
        this.path = path;
        this.bucketId = bucketId;
        this.context = context;
        this.conf = context.getConfiguration();
        this.serializer = new OrcSerializer(dataSchema, this.conf);
        this.recordWriterInstantiated = false;
    }
}

