/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.csv.BulkCsvReader;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat$;
import org.apache.spark.sql.execution.datasources.csv.CSVInferSchema$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVOutputWriterFactory;
import org.apache.spark.sql.execution.datasources.csv.CSVRelation$;
import org.apache.spark.sql.execution.datasources.csv.LineCsvReader;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\u0001\u0003\u0001E\u0011QbQ*W\r&dWMR8s[\u0006$(BA\u0002\u0005\u0003\r\u00197O\u001e\u0006\u0003\u000b\u0019\t1\u0002Z1uCN|WO]2fg*\u0011q\u0001C\u0001\nKb,7-\u001e;j_:T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0017!\t\u0019B#D\u0001\u0005\u0013\t)BAA\nUKb$()Y:fI\u001aKG.\u001a$pe6\fG\u000f\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\u0011\u000591o\\;sG\u0016\u001c\u0018BA\u000e\u0019\u0005I!\u0015\r^1T_V\u00148-\u001a*fO&\u001cH/\u001a:\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\u0011\u0001\"\u0002\u0012\u0001\t\u0003\u001a\u0013!C:i_J$h*Y7f)\u0005!\u0003CA\u0013,\u001d\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0003\u0019\u0001&/\u001a3fM&\u0011A&\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005):\u0003\"B\u0018\u0001\t\u0003\u001a\u0013\u0001\u0003;p'R\u0014\u0018N\\4\t\u000bE\u0002A\u0011\t\u001a\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\r\t\u0003MQJ!!N\u0014\u0003\u0007%sG\u000fC\u00038\u0001\u0011\u0005\u0003(\u0001\u0004fcV\fGn\u001d\u000b\u0003sq\u0002\"A\n\u001e\n\u0005m:#a\u0002\"p_2,\u0017M\u001c\u0005\u0006{Y\u0002\rAP\u0001\u0006_RDWM\u001d\t\u0003M}J!\u0001Q\u0014\u0003\u0007\u0005s\u0017\u0010C\u0003C\u0001\u0011\u00053)A\u0006j]\u001a,'oU2iK6\fG\u0003\u0002#N'b\u00032AJ#H\u0013\t1uE\u0001\u0004PaRLwN\u001c\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015\"\tQ\u0001^=qKNL!\u0001T%\u0003\u0015M#(/^2u)f\u0004X\rC\u0003O\u0003\u0002\u0007q*\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002Q#6\t\u0001\"\u0003\u0002S\u0011\ta1\u000b]1sWN+7o]5p]\")A+\u0011a\u0001+\u00069q\u000e\u001d;j_:\u001c\b\u0003B\u0013WI\u0011J!aV\u0017\u0003\u00075\u000b\u0007\u000fC\u0003Z\u0003\u0002\u0007!,A\u0003gS2,7\u000fE\u0002\\G\u001at!\u0001X1\u000f\u0005u\u0003W\"\u00010\u000b\u0005}\u0003\u0012A\u0002\u001fs_>$h(C\u0001)\u0013\t\u0011w%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0011,'aA*fc*\u0011!m\n\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\f!AZ:\u000b\u0005-d\u0011A\u00025bI>|\u0007/\u0003\u0002nQ\nQa)\u001b7f'R\fG/^:\t\u000b=\u0004A\u0011\t9\u0002\u0019A\u0014X\r]1sK^\u0013\u0018\u000e^3\u0015\u000bE$X/ @\u0011\u0005M\u0011\u0018BA:\u0005\u0005MyU\u000f\u001e9vi^\u0013\u0018\u000e^3s\r\u0006\u001cGo\u001c:z\u0011\u0015qe\u000e1\u0001P\u0011\u00151h\u000e1\u0001x\u0003\rQwN\u0019\t\u0003qnl\u0011!\u001f\u0006\u0003u*\f\u0011\"\\1qe\u0016$WoY3\n\u0005qL(a\u0001&pE\")AK\u001ca\u0001+\")qP\u001ca\u0001\u000f\u0006QA-\u0019;b'\u000eDW-\\1\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006\u0005Y!-^5mIJ+\u0017\rZ3s)A\t9!!\n\u0002(\u0005%\u0012QFA\u0019\u0003{\ty\u0004E\u0004'\u0003\u0013\ti!a\u0005\n\u0007\u0005-qEA\u0005Gk:\u001cG/[8ocA\u00191#a\u0004\n\u0007\u0005EAAA\bQCJ$\u0018\u000e^5p]\u0016$g)\u001b7f!\u0015Y\u0016QCA\r\u0013\r\t9\"\u001a\u0002\t\u0013R,'/\u0019;peB!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 !\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003G\tiBA\u0006J]R,'O\\1m%><\bB\u0002(\u0002\u0002\u0001\u0007q\n\u0003\u0004\u0000\u0003\u0003\u0001\ra\u0012\u0005\b\u0003W\t\t\u00011\u0001H\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007bBA\u0018\u0003\u0003\u0001\raR\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b\u0011!\t\u0019$!\u0001A\u0002\u0005U\u0012a\u00024jYR,'o\u001d\t\u00057\u000e\f9\u0004E\u0002\u0018\u0003sI1!a\u000f\u0019\u0005\u00191\u0015\u000e\u001c;fe\"1A+!\u0001A\u0002UC\u0001\"!\u0011\u0002\u0002\u0001\u0007\u00111I\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\u0003BA#\u0003\u0017j!!a\u0012\u000b\u0007\u0005%#.\u0001\u0003d_:4\u0017\u0002BA'\u0003\u000f\u0012QbQ8oM&<WO]1uS>t\u0007bBA)\u0001\u0011%\u00111K\u0001\bE\u0006\u001cXM\u00153e)!\t)&!\u0019\u0002d\u0005-\u0004#BA,\u0003;\"SBAA-\u0015\r\tYFC\u0001\u0004e\u0012$\u0017\u0002BA0\u00033\u00121A\u0015#E\u0011\u0019q\u0015q\na\u0001\u001f\"9A+a\u0014A\u0002\u0005\u0015\u0004c\u0001\u0011\u0002h%\u0019\u0011\u0011\u000e\u0002\u0003\u0015\r\u001bfk\u00149uS>t7\u000f\u0003\u0005\u0002n\u0005=\u0003\u0019AA8\u0003)Ig\u000e];u!\u0006$\bn\u001d\t\u00047\u000e$\u0003bBA:\u0001\u0011%\u0011QO\u0001\ti>\\WM\u001c*eIRQ\u0011qOA@\u0003\u0003\u000b\u0019)a\"\u0011\r\u0005]\u0013QLA=!\u00111\u00131\u0010\u0013\n\u0007\u0005utEA\u0003BeJ\f\u0017\u0010\u0003\u0004O\u0003c\u0002\ra\u0014\u0005\b)\u0006E\u0004\u0019AA3\u0011!\t))!\u001dA\u0002\u0005e\u0014A\u00025fC\u0012,'\u000f\u0003\u0005\u0002n\u0005E\u0004\u0019AA8\u0011\u001d\tY\t\u0001C\u0005\u0003\u001b\u000bQBZ5oI\u001aK'o\u001d;MS:,G#\u0002\u0013\u0002\u0010\u0006E\u0005b\u0002+\u0002\n\u0002\u0007\u0011Q\r\u0005\t\u00037\nI\t1\u0001\u0002V!9\u0011Q\u0013\u0001\u0005\n\u0005]\u0015\u0001\u0003:fC\u0012$V\r\u001f;\u0015\u0011\u0005U\u0013\u0011TAN\u0003;CaATAJ\u0001\u0004y\u0005b\u0002+\u0002\u0014\u0002\u0007\u0011Q\r\u0005\b\u0003?\u000b\u0019\n1\u0001%\u0003!awnY1uS>t\u0007bBAR\u0001\u0011%\u0011QU\u0001\rm\u0016\u0014\u0018NZ=TG\",W.\u0019\u000b\u0005\u0003O\u000bi\u000bE\u0002'\u0003SK1!a+(\u0005\u0011)f.\u001b;\t\u000f\u0005=\u0016\u0011\u0015a\u0001\u000f\u000611o\u00195f[\u0006\u0004")
public class CSVFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    @Override
    public String shortName() {
        return "csv";
    }

    public String toString() {
        return "CSV";
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof CSVFileFormat;
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        StructType structType;
        CSVOptions csvOptions = new CSVOptions(options);
        Seq paths = (Seq)((TraversableLike)files.filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus x$1) {
                return x$1.getPath().getName().startsWith("_");
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$2) {
                return x$2.getPath().toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        RDD<String> rdd2 = this.baseRdd(sparkSession, csvOptions, (Seq<String>)paths);
        String firstLine = this.findFirstLine(csvOptions, rdd2);
        String[] firstRow = new LineCsvReader(csvOptions).parseLine(firstLine);
        String[] header = csvOptions.headerFlag() ? (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])firstRow).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this, csvOptions){
            public static final long serialVersionUID = 0L;
            private final CSVOptions csvOptions$1;

            /*
             * Unable to fully structure code
             */
            public final String apply(Tuple2<String, Object> x0$1) {
                block2: {
                    var2_2 = x0$1;
                    if (var2_2 == null) break block2;
                    value = (String)var2_2._1();
                    index = var2_2._2$mcI$sp();
                    if (value == null || value.isEmpty()) ** GOTO lbl-1000
                    v0 = value;
                    var5_5 = this.csvOptions$1.nullValue();
                    if (!(v0 != null ? v0.equals(var5_5) == false : var5_5 != null)) lbl-1000:
                    // 2 sources

                    {
                        v1 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_c", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)}));
                    } else {
                        v1 = value;
                    }
                    var6_6 = v1;
                    return var6_6;
                }
                throw new MatchError(var2_2);
            }
            {
                this.csvOptions$1 = csvOptions$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))) : (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])firstRow).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x0$2) {
                Tuple2<String, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    int index = tuple2._2$mcI$sp();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_c", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index)}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        RDD<String[]> parsedRdd = this.tokenRdd(sparkSession, csvOptions, header, (Seq<String>)paths);
        if (csvOptions.inferSchemaFlag()) {
            structType = CSVInferSchema$.MODULE$.infer(parsedRdd, header, csvOptions);
        } else {
            StructField[] schemaFields = (StructField[])Predef$.MODULE$.refArrayOps((Object[])header).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final StructField apply(String fieldName) {
                    return new StructField(fieldName.toString(), (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
            structType = new StructType(schemaFields);
        }
        StructType schema = structType;
        return new Some((Object)schema);
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema);
        Configuration conf = job.getConfiguration();
        CSVOptions csvOptions = new CSVOptions(options);
        csvOptions.compressionCodec().foreach((Function1)new Serializable(this, conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(String codec) {
                CompressionCodecs$.MODULE$.setCodecConfiguration(this.conf$1, codec);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        return new CSVOutputWriterFactory(csvOptions);
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        CSVOptions csvOptions = new CSVOptions(options);
        String[] headers = (String[])Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$3) {
                return x$3.name();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return new Serializable(this, dataSchema, requiredSchema, csvOptions, headers, broadcastedHadoopConf){
            public static final long serialVersionUID = 0L;
            private final StructType dataSchema$1;
            private final StructType requiredSchema$1;
            public final CSVOptions csvOptions$2;
            private final String[] headers$1;
            private final Broadcast broadcastedHadoopConf$1;

            public final Iterator<InternalRow> apply(PartitionedFile file) {
                Configuration conf = ((SerializableConfiguration)this.broadcastedHadoopConf$1.value()).value();
                Iterator<B> lineIterator = new HadoopFileLinesReader(file, conf).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$buildReader$1 $outer;

                    public final String apply(Text line) {
                        return new String(line.getBytes(), 0, line.getLength(), this.$outer.csvOptions$2.charset());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                CSVRelation$.MODULE$.dropHeaderLine(file, lineIterator, this.csvOptions$2);
                BulkCsvReader tokenizedIterator = new BulkCsvReader(lineIterator, this.csvOptions$2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.headers$1));
                Function2<String[], Object, Option<InternalRow>> parser = CSVRelation$.MODULE$.csvParser(this.dataSchema$1, this.requiredSchema$1.fieldNames(), this.csvOptions$2);
                IntRef numMalformedRecords = new IntRef(0);
                return tokenizedIterator.flatMap(new Serializable(this, parser, numMalformedRecords){
                    public static final long serialVersionUID = 0L;
                    private final Function2 parser$1;
                    private final IntRef numMalformedRecords$1;

                    public final Iterable<InternalRow> apply(String[] recordTokens) {
                        Option row = (Option)this.parser$1.apply((Object)recordTokens, (Object)BoxesRunTime.boxToInteger((int)this.numMalformedRecords$1.elem));
                        if (row.isEmpty()) {
                            ++this.numMalformedRecords$1.elem;
                        }
                        return Option$.MODULE$.option2Iterable(row);
                    }
                    {
                        this.parser$1 = parser$1;
                        this.numMalformedRecords$1 = numMalformedRecords$1;
                    }
                });
            }
            {
                this.dataSchema$1 = dataSchema$1;
                this.requiredSchema$1 = requiredSchema$1;
                this.csvOptions$2 = csvOptions$2;
                this.headers$1 = headers$1;
                this.broadcastedHadoopConf$1 = broadcastedHadoopConf$1;
            }
        };
    }

    private RDD<String> baseRdd(SparkSession sparkSession, CSVOptions options, Seq<String> inputPaths) {
        return this.readText(sparkSession, options, inputPaths.mkString(","));
    }

    private RDD<String[]> tokenRdd(SparkSession sparkSession, CSVOptions options, String[] header, Seq<String> inputPaths) {
        RDD<String> rdd2 = this.baseRdd(sparkSession, options, inputPaths);
        String firstLine = options.headerFlag() ? this.findFirstLine(options, rdd2) : null;
        return CSVRelation$.MODULE$.univocityTokenizer(rdd2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])header), firstLine, options);
    }

    private String findFirstLine(CSVOptions options, RDD<String> rdd2) {
        String string;
        if (options.isCommentSet()) {
            String comment = ((Object)BoxesRunTime.boxToCharacter((char)options.comment())).toString();
            string = (String)rdd2.filter((Function1)new Serializable(this, comment){
                public static final long serialVersionUID = 0L;
                private final String comment$1;

                public final boolean apply(String line) {
                    return new StringOps(Predef$.MODULE$.augmentString(line.trim())).nonEmpty() && !line.startsWith(this.comment$1);
                }
                {
                    this.comment$1 = comment$1;
                }
            }).first();
        } else {
            string = (String)rdd2.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String line) {
                    return new StringOps(Predef$.MODULE$.augmentString(line.trim())).nonEmpty();
                }
            }).first();
        }
        return string;
    }

    private RDD<String> readText(SparkSession sparkSession, CSVOptions options, String location) {
        RDD rDD;
        Charset charset = Charset.forName(options.charset());
        Charset charset2 = StandardCharsets.UTF_8;
        if (!(charset != null ? !((Object)charset).equals(charset2) : charset2 != null)) {
            rDD = sparkSession.sparkContext().textFile(location, sparkSession.sparkContext().textFile$default$2());
        } else {
            String charset3 = options.charset();
            RDD qual$1 = sparkSession.sparkContext().hadoopFile(location, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(Text.class), ClassTag$.MODULE$.apply(TextInputFormat.class));
            Serializable x$5 = new Serializable(this, charset3){
                public static final long serialVersionUID = 0L;
                public final String charset$1;

                public final Iterator<String> apply(Iterator<Tuple2<LongWritable, Text>> x$4) {
                    return x$4.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$8 $outer;

                        public final String apply(Tuple2<LongWritable, Text> pair) {
                            return new String(((Text)pair._2()).getBytes(), 0, ((Text)pair._2()).getLength(), this.$outer.charset$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.charset$1 = charset$1;
                }
            };
            boolean x$6 = qual$1.mapPartitions$default$2();
            rDD = qual$1.mapPartitions((Function1)x$5, x$6, ClassTag$.MODULE$.apply(String.class));
        }
        return rDD;
    }

    private void verifySchema(StructType schema) {
        schema.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(StructField field) {
                DataType dataType = field.dataType();
                boolean bl = dataType instanceof ArrayType ? true : (dataType instanceof MapType ? true : dataType instanceof StructType);
                if (bl) {
                    throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CSV data source does not support ", " data type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{field.dataType().simpleString()})));
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        });
    }
}

