/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.memory.MemoryMode;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.execution.vectorized.ColumnVector;
import org.apache.spark.sql.execution.vectorized.ColumnarBatch;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.CalendarIntervalType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public class ColumnVectorUtils {
    public static void populate(ColumnVector col, InternalRow row, int fieldIdx) {
        int capacity = col.capacity;
        DataType t = col.dataType();
        if (row.isNullAt(fieldIdx)) {
            col.putNulls(0, capacity);
        } else if (t == DataTypes.BooleanType) {
            col.putBooleans(0, capacity, row.getBoolean(fieldIdx));
        } else if (t == DataTypes.ByteType) {
            col.putBytes(0, capacity, row.getByte(fieldIdx));
        } else if (t == DataTypes.ShortType) {
            col.putShorts(0, capacity, row.getShort(fieldIdx));
        } else if (t == DataTypes.IntegerType) {
            col.putInts(0, capacity, row.getInt(fieldIdx));
        } else if (t == DataTypes.LongType) {
            col.putLongs(0, capacity, row.getLong(fieldIdx));
        } else if (t == DataTypes.FloatType) {
            col.putFloats(0, capacity, row.getFloat(fieldIdx));
        } else if (t == DataTypes.DoubleType) {
            col.putDoubles(0, capacity, row.getDouble(fieldIdx));
        } else if (t == DataTypes.StringType) {
            UTF8String v = row.getUTF8String(fieldIdx);
            byte[] bytes = v.getBytes();
            for (int i = 0; i < capacity; ++i) {
                col.putByteArray(i, bytes);
            }
        } else if (t instanceof DecimalType) {
            DecimalType dt = (DecimalType)t;
            Decimal d = row.getDecimal(fieldIdx, dt.precision(), dt.scale());
            if (dt.precision() <= Decimal.MAX_INT_DIGITS()) {
                col.putInts(0, capacity, (int)d.toUnscaledLong());
            } else if (dt.precision() <= Decimal.MAX_LONG_DIGITS()) {
                col.putLongs(0, capacity, d.toUnscaledLong());
            } else {
                BigInteger integer = d.toJavaBigDecimal().unscaledValue();
                byte[] bytes = integer.toByteArray();
                for (int i = 0; i < capacity; ++i) {
                    col.putByteArray(i, bytes, 0, bytes.length);
                }
            }
        } else if (t instanceof CalendarIntervalType) {
            CalendarInterval c = (CalendarInterval)row.get(fieldIdx, t);
            col.getChildColumn(0).putInts(0, capacity, c.months);
            col.getChildColumn(1).putLongs(0, capacity, c.microseconds);
        } else if (t instanceof DateType) {
            Date date = (Date)row.get(fieldIdx, t);
            col.putInts(0, capacity, DateTimeUtils.fromJavaDate((Date)date));
        }
    }

    public static Object toPrimitiveJavaArray(ColumnVector.Array array2) {
        DataType dt = array2.data.dataType();
        if (dt instanceof IntegerType) {
            int[] result = new int[array2.length];
            ColumnVector data = array2.data;
            for (int i = 0; i < result.length; ++i) {
                if (data.isNullAt(array2.offset + i)) {
                    throw new RuntimeException("Cannot handle NULL values.");
                }
                result[i] = data.getInt(array2.offset + i);
            }
            return result;
        }
        throw new UnsupportedOperationException();
    }

    private static void appendValue(ColumnVector dst, DataType t, Object o) {
        if (o == null) {
            if (t instanceof CalendarIntervalType) {
                dst.appendStruct(true);
            } else {
                dst.appendNull();
            }
        } else if (t == DataTypes.BooleanType) {
            dst.appendBoolean((Boolean)o);
        } else if (t == DataTypes.ByteType) {
            dst.appendByte((Byte)o);
        } else if (t == DataTypes.ShortType) {
            dst.appendShort((Short)o);
        } else if (t == DataTypes.IntegerType) {
            dst.appendInt((Integer)o);
        } else if (t == DataTypes.LongType) {
            dst.appendLong((Long)o);
        } else if (t == DataTypes.FloatType) {
            dst.appendFloat(((Float)o).floatValue());
        } else if (t == DataTypes.DoubleType) {
            dst.appendDouble((Double)o);
        } else if (t == DataTypes.StringType) {
            byte[] b = ((String)o).getBytes(StandardCharsets.UTF_8);
            dst.appendByteArray(b, 0, b.length);
        } else if (t instanceof DecimalType) {
            DecimalType dt = (DecimalType)t;
            Decimal d = Decimal.apply((BigDecimal)((BigDecimal)o), (int)dt.precision(), (int)dt.scale());
            if (dt.precision() <= Decimal.MAX_INT_DIGITS()) {
                dst.appendInt((int)d.toUnscaledLong());
            } else if (dt.precision() <= Decimal.MAX_LONG_DIGITS()) {
                dst.appendLong(d.toUnscaledLong());
            } else {
                BigInteger integer = d.toJavaBigDecimal().unscaledValue();
                byte[] bytes = integer.toByteArray();
                dst.appendByteArray(bytes, 0, bytes.length);
            }
        } else if (t instanceof CalendarIntervalType) {
            CalendarInterval c = (CalendarInterval)o;
            dst.appendStruct(false);
            dst.getChildColumn(0).appendInt(c.months);
            dst.getChildColumn(1).appendLong(c.microseconds);
        } else if (t instanceof DateType) {
            dst.appendInt(DateTimeUtils.fromJavaDate((Date)((Date)o)));
        } else {
            throw new UnsupportedOperationException("Type " + t);
        }
    }

    private static void appendValue(ColumnVector dst, DataType t, Row src, int fieldIdx) {
        if (t instanceof ArrayType) {
            ArrayType at = (ArrayType)t;
            if (src.isNullAt(fieldIdx)) {
                dst.appendNull();
            } else {
                List values = src.getList(fieldIdx);
                dst.appendArray(values.size());
                for (Object o : values) {
                    ColumnVectorUtils.appendValue(dst.arrayData(), at.elementType(), o);
                }
            }
        } else if (t instanceof StructType) {
            StructType st = (StructType)t;
            if (src.isNullAt(fieldIdx)) {
                dst.appendStruct(true);
            } else {
                dst.appendStruct(false);
                Row c = src.getStruct(fieldIdx);
                for (int i = 0; i < st.fields().length; ++i) {
                    ColumnVectorUtils.appendValue(dst.getChildColumn(i), st.fields()[i].dataType(), c, i);
                }
            }
        } else {
            ColumnVectorUtils.appendValue(dst, t, src.get(fieldIdx));
        }
    }

    public static ColumnarBatch toBatch(StructType schema, MemoryMode memMode, Iterator<Row> row) {
        ColumnarBatch batch = ColumnarBatch.allocate(schema, memMode);
        int n = 0;
        while (row.hasNext()) {
            Row r2 = row.next();
            for (int i = 0; i < schema.fields().length; ++i) {
                ColumnVectorUtils.appendValue(batch.column(i), schema.fields()[i].dataType(), r2, i);
            }
            ++n;
        }
        batch.setNumRows(n);
        return batch;
    }
}

