/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.BucketSpec;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.streaming.StreamingRelation$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\rf\u0001B\u0001\u0003\u00055\u0011\u0001\u0003R1uCN#(/Z1n%\u0016\fG-\u001a:\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UAR\"\u0001\f\u000b\u0005]1\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005e1\"a\u0002'pO\u001eLgn\u001a\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005a1\u000f]1sWN+7o]5p]B\u0011QDH\u0007\u0002\t%\u0011q\u0004\u0002\u0002\r'B\f'o[*fgNLwN\u001c\u0005\u0007C\u0001!\t\u0001\u0002\u0012\u0002\rqJg.\u001b;?)\t\u0019S\u0005\u0005\u0002%\u00015\t!\u0001C\u0003\u001cA\u0001\u0007A\u0004C\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004g_Jl\u0017\r\u001e\u000b\u0003G%BQA\u000b\u0014A\u0002-\naa]8ve\u000e,\u0007C\u0001\u00170\u001d\tyQ&\u0003\u0002/!\u00051\u0001K]3eK\u001aL!\u0001M\u0019\u0003\rM#(/\u001b8h\u0015\tq\u0003\u0003\u000b\u0002'gA\u0011AgN\u0007\u0002k)\u0011aGB\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001\u001d6\u00051)\u0005\u0010]3sS6,g\u000e^1m\u0011\u0015Q\u0004\u0001\"\u0001<\u0003\u0019\u00198\r[3nCR\u00111\u0005\u0010\u0005\u0006ue\u0002\r!\u0010\t\u0003}\u0005k\u0011a\u0010\u0006\u0003\u0001\u0012\tQ\u0001^=qKNL!AQ \u0003\u0015M#(/^2u)f\u0004X\r\u000b\u0002:g!)Q\t\u0001C\u0001\r\u00061q\u000e\u001d;j_:$2aI$J\u0011\u0015AE\t1\u0001,\u0003\rYW-\u001f\u0005\u0006\u0015\u0012\u0003\raK\u0001\u0006m\u0006dW/\u001a\u0015\u0003\tNBQ!\u0012\u0001\u0005\u00025#2a\t(P\u0011\u0015AE\n1\u0001,\u0011\u0015QE\n1\u0001Q!\ty\u0011+\u0003\u0002S!\t9!i\\8mK\u0006t\u0007F\u0001'4\u0011\u0015)\u0005\u0001\"\u0001V)\r\u0019ck\u0016\u0005\u0006\u0011R\u0003\ra\u000b\u0005\u0006\u0015R\u0003\r\u0001\u0017\t\u0003\u001feK!A\u0017\t\u0003\t1{gn\u001a\u0015\u0003)NBQ!\u0012\u0001\u0005\u0002u#2a\t0`\u0011\u0015AE\f1\u0001,\u0011\u0015QE\f1\u0001a!\ty\u0011-\u0003\u0002c!\t1Ai\\;cY\u0016D#\u0001X\u001a\t\u000b\u0015\u0004A\u0011\u00014\u0002\u000f=\u0004H/[8ogR\u00111e\u001a\u0005\u0006K\u0012\u0004\r\u0001\u001b\t\u0005S2\\3&D\u0001k\u0015\tY\u0007#\u0001\u0006d_2dWm\u0019;j_:L!!\u001c6\u0003\u00075\u000b\u0007\u000f\u000b\u0002eg!)Q\r\u0001C\u0001aR\u00111%\u001d\u0005\u0006K>\u0004\rA\u001d\t\u0005gb\\3&D\u0001u\u0015\t)h/\u0001\u0003vi&d'\"A<\u0002\t)\fg/Y\u0005\u0003[RD#a\\\u001a\t\u000bm\u0004A\u0011\u0001?\u0002\t1|\u0017\r\u001a\u000b\u0002{B\u0019a0!\u0007\u000f\u0007}\f)B\u0004\u0003\u0002\u0002\u0005Ma\u0002BA\u0002\u0003#qA!!\u0002\u0002\u00109!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f1\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!C\u0002\u0002\u0018\u0011\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u001c\u0005u!!\u0003#bi\u00064%/Y7f\u0015\r\t9\u0002\u0002\u0015\u0003uNBaa\u001f\u0001\u0005\u0002\u0005\rBcA?\u0002&!9\u0011qEA\u0011\u0001\u0004Y\u0013\u0001\u00029bi\"D3!!\t4\u0011\u001d\ti\u0003\u0001C\u0001\u0003_\tAA[:p]R\u0019Q0!\r\t\u000f\u0005\u001d\u00121\u0006a\u0001W!\u001a\u00111F\u001a\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:\u0005\u00191m\u001d<\u0015\u0007u\fY\u0004C\u0004\u0002(\u0005U\u0002\u0019A\u0016)\u0007\u0005U2\u0007C\u0004\u0002B\u0001!\t!a\u0011\u0002\u000fA\f'/];fiR\u0019Q0!\u0012\t\u000f\u0005\u001d\u0012q\ba\u0001W!\u001a\u0011qH\u001a\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N\u0005!A/\u001a=u)\ri\u0018q\n\u0005\b\u0003O\tI\u00051\u0001,Q\r\tIe\r\u0005\tU\u0001\u0001\r\u0011\"\u0003\u0002VU\t1\u0006C\u0005\u0002Z\u0001\u0001\r\u0011\"\u0003\u0002\\\u0005Q1o\\;sG\u0016|F%Z9\u0015\t\u0005u\u00131\r\t\u0004\u001f\u0005}\u0013bAA1!\t!QK\\5u\u0011%\t)'a\u0016\u0002\u0002\u0003\u00071&A\u0002yIEBq!!\u001b\u0001A\u0003&1&A\u0004t_V\u00148-\u001a\u0011\t\u0013\u00055\u0004\u00011A\u0005\n\u0005=\u0014aE;tKJ\u001c\u0006/Z2jM&,GmU2iK6\fWCAA9!\u0011y\u00111O\u001f\n\u0007\u0005U\u0004C\u0001\u0004PaRLwN\u001c\u0005\n\u0003s\u0002\u0001\u0019!C\u0005\u0003w\nq#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006|F%Z9\u0015\t\u0005u\u0013Q\u0010\u0005\u000b\u0003K\n9(!AA\u0002\u0005E\u0004\u0002CAA\u0001\u0001\u0006K!!\u001d\u0002)U\u001cXM]*qK\u000eLg-[3e'\u000eDW-\\1!\u0011%\t)\t\u0001a\u0001\n\u0013\t9)\u0001\u0007fqR\u0014\u0018m\u00149uS>t7/\u0006\u0002\u0002\nB1\u00111RAIW-j!!!$\u000b\u0007\u0005=%.A\u0004nkR\f'\r\\3\n\t\u0005M\u0015Q\u0012\u0002\b\u0011\u0006\u001c\b.T1q\u0011%\t9\n\u0001a\u0001\n\u0013\tI*\u0001\tfqR\u0014\u0018m\u00149uS>t7o\u0018\u0013fcR!\u0011QLAN\u0011)\t)'!&\u0002\u0002\u0003\u0007\u0011\u0011\u0012\u0005\t\u0003?\u0003\u0001\u0015)\u0003\u0002\n\u0006iQ\r\u001f;sC>\u0003H/[8og\u0002B#\u0001A\u001a")
public final class DataStreamReader
implements Logging {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private HashMap<String, String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    @Experimental
    public DataStreamReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    @Experimental
    public DataStreamReader schema(StructType schema) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)schema));
        return this;
    }

    @Experimental
    public DataStreamReader option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    @Experimental
    public DataStreamReader option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    @Experimental
    public DataStreamReader option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    @Experimental
    public DataStreamReader option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    @Experimental
    public DataStreamReader options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    @Experimental
    public DataStreamReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    @Experimental
    public Dataset<Row> load() {
        SparkSession x$1 = this.sparkSession;
        Option<StructType> x$2 = this.userSpecifiedSchema();
        String x$3 = this.source();
        scala.collection.immutable.Map x$4 = this.extraOptions().toMap(Predef$.MODULE$.conforms());
        Seq<String> x$5 = DataSource$.MODULE$.apply$default$3();
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        DataSource dataSource = new DataSource(x$1, x$3, x$5, x$2, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$4);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)StreamingRelation$.MODULE$.apply(dataSource));
    }

    @Experimental
    public Dataset<Row> load(String path) {
        return this.option("path", path).load();
    }

    @Experimental
    public Dataset<Row> json(String path) {
        return this.format("json").load(path);
    }

    @Experimental
    public Dataset<Row> csv(String path) {
        return this.format("csv").load(path);
    }

    @Experimental
    public Dataset<Row> parquet(String path) {
        return this.format("parquet").load(path);
    }

    @Experimental
    public Dataset<Row> text(String path) {
        return this.format("text").load(path);
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private void extraOptions_$eq(HashMap<String, String> x$1) {
        this.extraOptions = x$1;
    }

    public DataStreamReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.class.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = new HashMap();
    }
}

