/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeWatermark;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.connector.read.streaming.SparkDataStream;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.MicroBatchScanExec;
import org.apache.spark.sql.execution.datasources.v2.StreamWriterCommitProgress;
import org.apache.spark.sql.execution.datasources.v2.StreamingDataSourceV2Relation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.streaming.EventTimeStats;
import org.apache.spark.sql.execution.streaming.EventTimeWatermarkExec;
import org.apache.spark.sql.execution.streaming.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.ProgressReporter$;
import org.apache.spark.sql.execution.streaming.ProgressReporter$ExecutionStats$;
import org.apache.spark.sql.execution.streaming.StateStoreWriter;
import org.apache.spark.sql.execution.streaming.StreamProgress;
import org.apache.spark.sql.execution.streaming.StreamingExecutionRelation;
import org.apache.spark.sql.streaming.SinkProgress;
import org.apache.spark.sql.streaming.SinkProgress$;
import org.apache.spark.sql.streaming.SourceProgress;
import org.apache.spark.sql.streaming.StateOperatorProgress;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.StreamingQueryStatus;
import org.apache.spark.util.Clock;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\rMga\u0002'N!\u0003\r\tA\u0017\u0005\u0006O\u0002!\t\u0001\u001b\u0004\u0005Y\u0002\u0001U\u000e\u0003\u0005u\u0005\tU\r\u0011\"\u0001v\u0011%\tYB\u0001B\tB\u0003%a\u000f\u0003\u0006\u0002\u001e\t\u0011)\u001a!C\u0001\u0003?A!\"!\u0010\u0003\u0005#\u0005\u000b\u0011BA\u0011\u0011)\tyD\u0001BK\u0002\u0013\u0005\u0011\u0011\t\u0005\u000b\u0003\u0017\u0012!\u0011#Q\u0001\n\u0005\r\u0003bBA'\u0005\u0011\u0005\u0011q\n\u0005\n\u00037\u0012\u0011\u0011!C\u0001\u0003;B\u0011\"!\u001a\u0003#\u0003%\t!a\u001a\t\u0013\u0005u$!%A\u0005\u0002\u0005}\u0004\"CAB\u0005E\u0005I\u0011AAC\u0011%\tIIAA\u0001\n\u0003\nY\tC\u0005\u0002\u001c\n\t\t\u0011\"\u0001\u0002\u001e\"I\u0011Q\u0015\u0002\u0002\u0002\u0013\u0005\u0011q\u0015\u0005\n\u0003g\u0013\u0011\u0011!C!\u0003kC\u0011\"a1\u0003\u0003\u0003%\t!!2\t\u0013\u0005='!!A\u0005B\u0005E\u0007\"CAj\u0005\u0005\u0005I\u0011IAk\u0011%\t9NAA\u0001\n\u0003\nInB\u0005\u0002^\u0002\t\t\u0011#\u0001\u0002`\u001aAA\u000eAA\u0001\u0012\u0003\t\t\u000fC\u0004\u0002N]!\t!a<\t\u0013\u0005Mw#!A\u0005F\u0005U\u0007\"CAy/\u0005\u0005I\u0011QAz\u0011%\tYpFA\u0001\n\u0003\u000bi\u0010C\u0004\u0003\u0010\u00011\tB!\u0005\t\u000f\t}\u0001A\"\u0005\u0003\u0012!9!\u0011\u0005\u0001\u0007\u0012\t\r\u0002b\u0002B\u0013\u0001\u0019E!q\u0005\u0005\b\u0005g\u0001a\u0011\u0003B\u001b\u0011\u001d\u0011Y\u0005\u0001D\t\u0005\u001bBqAa\u0016\u0001\r#\u0011I\u0006C\u0004\u0003^\u00011\tBa\u0018\t\u000f\tM\u0004A\"\u0005\u0003v!9!\u0011\u0010\u0001\u0007\u0012\tm\u0004b\u0002BE\u0001\u0019E!1\u0012\u0005\b\u0005+\u0003a\u0011\u0003BL\u0011\u001d\u0011I\n\u0001D\t\u00057CqA!*\u0001\r#\u00119\u000bC\u0005\u0003<\u0002\u0001\r\u0011\"\u0003\u0003\u0018\"I!Q\u0018\u0001A\u0002\u0013%!q\u0018\u0005\n\u0005\u0007\u0004\u0001\u0019!C\u0005\u0005/C\u0011B!2\u0001\u0001\u0004%IAa2\t\u0017\t-\u0007\u00011AA\u0002\u0013%!Q\u001a\u0005\f\u0005#\u0004\u0001\u0019!a\u0001\n\u0013\u0011\u0019\u000eC\u0006\u0003X\u0002\u0001\r\u00111A\u0005\n\t5\u0007b\u0003Bm\u0001\u0001\u0007\t\u0019!C\u0005\u00057D\u0011Ba8\u0001\u0001\u0004%IAa&\t\u0013\t\u0005\b\u00011A\u0005\n\t\r\b\"\u0003Bt\u0001\t\u0007I\u0011\u0002Bu\u0011%\u00119\u0010\u0001a\u0001\n\u0013\u0011I\u0010C\u0005\u0003|\u0002\u0001\r\u0011\"\u0003\u0003~\"I1\u0011\u0001\u0001C\u0002\u0013%11\u0001\u0005\n\u0007#\u0001!\u0019!C\u0005\u0005/C\u0011ba\u0005\u0001\u0001\u0004%IAa&\t\u0013\rU\u0001\u00011A\u0005\n\r]\u0001\"CB\u000e\u0001\t\u0007I\u0011BB\u000f\u0011%\u0019Y\u0003\u0001a\u0001\n#\u0019i\u0003C\u0005\u0004>\u0001\u0001\r\u0011\"\u0005\u0004@!911\t\u0001\u0005\u0002\r5\u0002bBB#\u0001\u0011\u00051q\t\u0005\b\u0007\u001f\u0002A\u0011AB)\u0011\u0019\u0019\u0019\u0006\u0001C\tQ\"91Q\u000b\u0001\u0005\u0012\r]\u0003bBB4\u0001\u0011%1\u0011\u000e\u0005\b\u0007_\u0002A\u0011CB9\u0011\u001d\u0019Y\b\u0001C\u0005\u0007{Bqa!!\u0001\t\u0013\u0019\u0019\tC\u0004\u0004\n\u0002!Iaa#\t\u000f\r5\u0005\u0001\"\u0003\u0004\u0010\"91Q\u0014\u0001\u0005\u0012\r}\u0005bBBb\u0001\u0011E1Q\u0019\u0005\b\u0007\u0017\u0004A\u0011CBg\u0005A\u0001&o\\4sKN\u001c(+\u001a9peR,'O\u0003\u0002O\u001f\u0006I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003!F\u000b\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005I\u001b\u0016aA:rY*\u0011A+V\u0001\u0006gB\f'o\u001b\u0006\u0003-^\u000ba!\u00199bG\",'\"\u0001-\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Y\u0016\r\u0005\u0002]?6\tQLC\u0001_\u0003\u0015\u00198-\u00197b\u0013\t\u0001WL\u0001\u0004B]f\u0014VM\u001a\t\u0003E\u0016l\u0011a\u0019\u0006\u0003IN\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003M\u000e\u0014q\u0001T8hO&tw-\u0001\u0004%S:LG\u000f\n\u000b\u0002SB\u0011AL[\u0005\u0003Wv\u0013A!\u00168ji\nqQ\t_3dkRLwN\\*uCR\u001c8\u0003\u0002\u0002\\]F\u0004\"\u0001X8\n\u0005Al&a\u0002)s_\u0012,8\r\u001e\t\u00039JL!a]/\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0013%t\u0007/\u001e;S_^\u001cX#\u0001<\u0011\r]t\u00181AA\u000b\u001d\tAH\u0010\u0005\u0002z;6\t!P\u0003\u0002|3\u00061AH]8pizJ!!`/\u0002\rA\u0013X\rZ3g\u0013\ry\u0018\u0011\u0001\u0002\u0004\u001b\u0006\u0004(BA?^!\u0011\t)!!\u0005\u000e\u0005\u0005\u001d!b\u0001(\u0002\n)!\u00111BA\u0007\u0003\u0011\u0011X-\u00193\u000b\u0007\u0005=\u0011+A\u0005d_:tWm\u0019;pe&!\u00111CA\u0004\u0005=\u0019\u0006/\u0019:l\t\u0006$\u0018m\u0015;sK\u0006l\u0007c\u0001/\u0002\u0018%\u0019\u0011\u0011D/\u0003\t1{gnZ\u0001\u000bS:\u0004X\u000f\u001e*poN\u0004\u0013AD:uCR,w\n]3sCR|'o]\u000b\u0003\u0003C\u0001b!a\t\u0002.\u0005Mb\u0002BA\u0013\u0003Sq1!_A\u0014\u0013\u0005q\u0016bAA\u0016;\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0018\u0003c\u00111aU3r\u0015\r\tY#\u0018\t\u0005\u0003k\tI$\u0004\u0002\u00028)\u0011a*U\u0005\u0005\u0003w\t9DA\u000bTi\u0006$Xm\u00149fe\u0006$xN\u001d)s_\u001e\u0014Xm]:\u0002\u001fM$\u0018\r^3Pa\u0016\u0014\u0018\r^8sg\u0002\na\"\u001a<f]R$\u0016.\\3Ti\u0006$8/\u0006\u0002\u0002DA1qO`A#\u0003\u000b\u00022a^A$\u0013\u0011\tI%!\u0001\u0003\rM#(/\u001b8h\u0003=)g/\u001a8u)&lWm\u0015;biN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0005\u0002R\u0005U\u0013qKA-!\r\t\u0019FA\u0007\u0002\u0001!)A/\u0003a\u0001m\"9\u0011QD\u0005A\u0002\u0005\u0005\u0002bBA \u0013\u0001\u0007\u00111I\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0002R\u0005}\u0013\u0011MA2\u0011\u001d!(\u0002%AA\u0002YD\u0011\"!\b\u000b!\u0003\u0005\r!!\t\t\u0013\u0005}\"\u0002%AA\u0002\u0005\r\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003SR3A^A6W\t\ti\u0007\u0005\u0003\u0002p\u0005eTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA<;\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0014\u0011\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0003SC!!\t\u0002l\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTCAADU\u0011\t\u0019%a\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\t\u0005\u0003\u0002\u0010\u0006eUBAAI\u0015\u0011\t\u0019*!&\u0002\t1\fgn\u001a\u0006\u0003\u0003/\u000bAA[1wC&!\u0011\u0011JAI\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty\nE\u0002]\u0003CK1!a)^\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI+a,\u0011\u0007q\u000bY+C\u0002\u0002.v\u00131!\u00118z\u0011%\t\t\fEA\u0001\u0002\u0004\ty*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003o\u0003b!!/\u0002@\u0006%VBAA^\u0015\r\ti,X\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAa\u0003w\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011qYAg!\ra\u0016\u0011Z\u0005\u0004\u0003\u0017l&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003c\u0013\u0012\u0011!a\u0001\u0003S\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003?\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001b\u000ba!Z9vC2\u001cH\u0003BAd\u00037D\u0011\"!-\u0016\u0003\u0003\u0005\r!!+\u0002\u001d\u0015CXmY;uS>t7\u000b^1ugB\u0019\u00111K\f\u0014\t]\t\u0019/\u001d\t\f\u0003K\fYO^A\u0011\u0003\u0007\n\t&\u0004\u0002\u0002h*\u0019\u0011\u0011^/\u0002\u000fI,h\u000e^5nK&!\u0011Q^At\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0003?\fQ!\u00199qYf$\u0002\"!\u0015\u0002v\u0006]\u0018\u0011 \u0005\u0006ij\u0001\rA\u001e\u0005\b\u0003;Q\u0002\u0019AA\u0011\u0011\u001d\tyD\u0007a\u0001\u0003\u0007\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0000\n-\u0001#\u0002/\u0003\u0002\t\u0015\u0011b\u0001B\u0002;\n1q\n\u001d;j_:\u0004\u0002\u0002\u0018B\u0004m\u0006\u0005\u00121I\u0005\u0004\u0005\u0013i&A\u0002+va2,7\u0007C\u0005\u0003\u000em\t\t\u00111\u0001\u0002R\u0005\u0019\u0001\u0010\n\u0019\u0002\u0005%$WC\u0001B\n!\u0011\u0011)Ba\u0007\u000e\u0005\t]!\u0002\u0002B\r\u0003+\u000bA!\u001e;jY&!!Q\u0004B\f\u0005\u0011)V+\u0013#\u0002\u000bI,h.\u00133\u0002\t9\fW.Z\u000b\u0003\u0003\u000b\nA\u0002\u001e:jO\u001e,'o\u00117pG.,\"A!\u000b\u0011\t\t-\"qF\u0007\u0003\u0005[Q1A!\u0007T\u0013\u0011\u0011\tD!\f\u0003\u000b\rcwnY6\u0002\u00171|w-[2bYBc\u0017M\\\u000b\u0003\u0005o\u0001BA!\u000f\u0003H5\u0011!1\b\u0006\u0005\u0005{\u0011y$A\u0004m_\u001eL7-\u00197\u000b\t\t\u0005#1I\u0001\u0006a2\fgn\u001d\u0006\u0004\u0005\u000b\n\u0016\u0001C2bi\u0006d\u0017p\u001d;\n\t\t%#1\b\u0002\f\u0019><\u0017nY1m!2\fg.A\u0007mCN$X\t_3dkRLwN\\\u000b\u0003\u0005\u001f\u0002BA!\u0015\u0003T5\tq*C\u0002\u0003V=\u0013a\"U;fef,\u00050Z2vi&|g.A\u0004oK^$\u0015\r^1\u0016\u0005\tm\u0003CB<\u007f\u0003\u0007\u00119$\u0001\ntS:\\7i\\7nSR\u0004&o\\4sKN\u001cXC\u0001B1!\u0015a&\u0011\u0001B2!\u0011\u0011)Ga\u001c\u000e\u0005\t\u001d$\u0002\u0002B5\u0005W\n!A\u001e\u001a\u000b\u0007\t5t*A\u0006eCR\f7o\\;sG\u0016\u001c\u0018\u0002\u0002B9\u0005O\u0012!d\u0015;sK\u0006lwK]5uKJ\u001cu.\\7jiB\u0013xn\u001a:fgN\fqa]8ve\u000e,7/\u0006\u0002\u0003xA1\u00111EA\u0017\u0003\u0007\tAa]5oWV\u0011!Q\u0010\t\u0005\u0005\u007f\u0012))\u0004\u0002\u0003\u0002*!!1QA\u0007\u0003\u001d\u0019\u0017\r^1m_\u001eLAAa\"\u0003\u0002\n)A+\u00192mK\u0006\trN\u001a4tKR\u001cV-]'fi\u0006$\u0017\r^1\u0016\u0005\t5\u0005\u0003\u0002BH\u0005#k\u0011!T\u0005\u0004\u0005'k%!E(gMN,GoU3r\u001b\u0016$\u0018\rZ1uC\u0006q1-\u001e:sK:$()\u0019;dQ&#WCAA\u000b\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o+\t\u0011i\n\u0005\u0003\u0003 \n\u0005V\"A)\n\u0007\t\r\u0016K\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0005q_N$XI^3oiR\u0019\u0011N!+\t\u000f\t-\u0016\u00061\u0001\u0003.\u0006)QM^3oiB!!q\u0016B[\u001d\u0011\t)D!-\n\t\tM\u0016qG\u0001\u0017'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0019&\u001cH/\u001a8fe&!!q\u0017B]\u0005\u0015)e/\u001a8u\u0015\u0011\u0011\u0019,a\u000e\u00029\r,(O]3oiR\u0013\u0018nZ4feN#\u0018M\u001d;US6,7\u000f^1na\u0006\u00013-\u001e:sK:$HK]5hO\u0016\u00148\u000b^1siRKW.Z:uC6\u0004x\fJ3r)\rI'\u0011\u0019\u0005\n\u0003c[\u0013\u0011!a\u0001\u0003+\t!dY;se\u0016tG\u000f\u0016:jO\u001e,'/\u00128e)&lWm\u001d;b[B\fadY;se\u0016tG\u000f\u0016:jO\u001e,'/\u00128e)&lWm\u001d;b[B|F%Z9\u0015\u0007%\u0014I\rC\u0005\u000226\n\t\u00111\u0001\u0002\u0016\u0005Q2-\u001e:sK:$HK]5hO\u0016\u00148\u000b^1si>3gm]3ugV\u0011!q\u001a\t\u0007oz\f\u0019!!\u0012\u0002=\r,(O]3oiR\u0013\u0018nZ4feN#\u0018M\u001d;PM\u001a\u001cX\r^:`I\u0015\fHcA5\u0003V\"I\u0011\u0011W\u0018\u0002\u0002\u0003\u0007!qZ\u0001\u0019GV\u0014(/\u001a8u)JLwmZ3s\u000b:$wJ\u001a4tKR\u001c\u0018\u0001H2veJ,g\u000e\u001e+sS\u001e<WM]#oI>3gm]3ug~#S-\u001d\u000b\u0004S\nu\u0007\"CAYc\u0005\u0005\t\u0019\u0001Bh\u0003ea\u0017m\u001d;Ue&<w-\u001a:Ti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9\u0002;1\f7\u000f\u001e+sS\u001e<WM]*uCJ$H+[7fgR\fW\u000e]0%KF$2!\u001bBs\u0011%\t\tlMA\u0001\u0002\u0004\t)\"\u0001\ndkJ\u0014XM\u001c;EkJ\fG/[8og6\u001bXC\u0001Bv!!\u0011iOa=\u0002F\u0005UQB\u0001Bx\u0015\u0011\u0011\t0a/\u0002\u000f5,H/\u00192mK&!!Q\u001fBx\u0005\u001dA\u0015m\u001d5NCB\f1#\\3ue&\u001cw+\u0019:oS:<Gj\\4hK\u0012,\"!a2\u0002/5,GO]5d/\u0006\u0014h.\u001b8h\u0019><w-\u001a3`I\u0015\fHcA5\u0003\u0000\"I\u0011\u0011\u0017\u001c\u0002\u0002\u0003\u0007\u0011qY\u0001\u000faJ|wM]3tg\n+hMZ3s+\t\u0019)\u0001\u0005\u0004\u0003n\u000e\u001d11B\u0005\u0005\u0007\u0013\u0011yOA\u0003Rk\u0016,X\r\u0005\u0003\u00026\r5\u0011\u0002BB\b\u0003o\u0011ac\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010\u0015:pOJ,7o]\u0001\u001c]>$\u0015\r^1Qe><'/Z:t\u000bZ,g\u000e^%oi\u0016\u0014h/\u00197\u0002A1\f7\u000f\u001e(p\u000bb,7-\u001e;j_:\u0004&o\\4sKN\u001cXI^3oiRKW.Z\u0001%Y\u0006\u001cHOT8Fq\u0016\u001cW\u000f^5p]B\u0013xn\u001a:fgN,e/\u001a8u)&lWm\u0018\u0013fcR\u0019\u0011n!\u0007\t\u0013\u0005E&(!AA\u0002\u0005U\u0011a\u0004;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;\u0016\u0005\r}\u0001\u0003BB\u0011\u0007Oi!aa\t\u000b\t\r\u0015\u0012QS\u0001\u0005i\u0016DH/\u0003\u0003\u0004*\r\r\"\u0001E*j[BdW\rR1uK\u001a{'/\\1u\u00035\u0019WO\u001d:f]R\u001cF/\u0019;vgV\u00111q\u0006\t\u0005\u0003k\u0019\t$\u0003\u0003\u00044\u0005]\"\u0001F*ue\u0016\fW.\u001b8h#V,'/_*uCR,8\u000fK\u0002=\u0007o\u00012\u0001XB\u001d\u0013\r\u0019Y$\u0018\u0002\tm>d\u0017\r^5mK\u0006\t2-\u001e:sK:$8\u000b^1ukN|F%Z9\u0015\u0007%\u001c\t\u0005C\u0005\u00022v\n\t\u00111\u0001\u00040\u000511\u000f^1ukN\faB]3dK:$\bK]8he\u0016\u001c8/\u0006\u0002\u0004JA)Ala\u0013\u0004\f%\u00191QJ/\u0003\u000b\u0005\u0013(/Y=\u0002\u00191\f7\u000f\u001e)s_\u001e\u0014Xm]:\u0016\u0005\r-\u0011\u0001D:uCJ$HK]5hO\u0016\u0014\u0018\u0001\u0006:fG>\u0014H\r\u0016:jO\u001e,'o\u00144gg\u0016$8\u000fF\u0003j\u00073\u001a\u0019\u0007C\u0004\u0004\\\t\u0003\ra!\u0018\u0002\t\u0019\u0014x.\u001c\t\u0005\u0005\u001f\u001by&C\u0002\u0004b5\u0013ab\u0015;sK\u0006l\u0007K]8he\u0016\u001c8\u000fC\u0004\u0004f\t\u0003\ra!\u0018\u0002\u0005Q|\u0017AD;qI\u0006$X\r\u0015:pOJ,7o\u001d\u000b\u0004S\u000e-\u0004bBB7\u0007\u0002\u000711B\u0001\f]\u0016<\bK]8he\u0016\u001c8/A\u0007gS:L7\u000f\u001b+sS\u001e<WM\u001d\u000b\u0006S\u000eM4q\u000f\u0005\b\u0007k\"\u0005\u0019AAd\u0003)A\u0017m\u001d(fo\u0012\u000bG/\u0019\u0005\b\u0007s\"\u0005\u0019AAd\u0003-A\u0017m]#yK\u000e,H/\u001a3\u00027\u0015DHO]1diN#\u0018\r^3Pa\u0016\u0014\u0018\r^8s\u001b\u0016$(/[2t)\u0011\t\tca \t\u000f\reT\t1\u0001\u0002H\u0006)R\r\u001f;sC\u000e$X\t_3dkRLwN\\*uCR\u001cHCBA)\u0007\u000b\u001b9\tC\u0004\u0004v\u0019\u0003\r!a2\t\u000f\red\t1\u0001\u0002H\u0006YR\r\u001f;sC\u000e$8k\\;sG\u0016$vNT;n\u0013:\u0004X\u000f\u001e*poN$\u0012A^\u0001\u0017Kb$(/Y2u\u001f\n\u001cXM\u001d<fI6+GO]5dgR11\u0011SBM\u00077\u0003ba\u001e@\u0002F\rM\u0005\u0003\u0002BP\u0007+K1aa&R\u0005\r\u0011vn\u001e\u0005\b\u0007kB\u0005\u0019AAd\u0011\u001d\u0011Y\u0005\u0013a\u0001\u0005\u001f\nqB]3q_J$H+[7f)\u0006\\WM\\\u000b\u0005\u0007C\u001bI\u000b\u0006\u0003\u0004$\u000e}F\u0003BBS\u0007k\u0003Baa*\u0004*2\u0001AaBBV\u0013\n\u00071Q\u0016\u0002\u0002)F!1qVAU!\ra6\u0011W\u0005\u0004\u0007gk&a\u0002(pi\"Lgn\u001a\u0005\t\u0007oKE\u00111\u0001\u0004:\u0006!!m\u001c3z!\u0015a61XBS\u0013\r\u0019i,\u0018\u0002\ty\tLh.Y7f}!91\u0011Y%A\u0002\u0005\u0015\u0013\u0001\u0005;sS\u001e<WM\u001d#fi\u0006LGnS3z\u0003=1wN]7biRKW.Z:uC6\u0004H\u0003BA#\u0007\u000fDqa!3K\u0001\u0004\t)\"\u0001\u0004nS2d\u0017n]\u0001\u0014kB$\u0017\r^3Ti\u0006$Xo]'fgN\fw-\u001a\u000b\u0004S\u000e=\u0007bBBi\u0017\u0002\u0007\u0011QI\u0001\b[\u0016\u001c8/Y4f\u0001")
public interface ProgressReporter
extends Logging {
    public ProgressReporter$ExecutionStats$ ExecutionStats();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs_$eq(scala.collection.mutable.HashMap<String, Object> var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer_$eq(Queue<StreamingQueryProgress> var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval_$eq(long var1);

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat_$eq(SimpleDateFormat var1);

    public UUID id();

    public UUID runId();

    public String name();

    public Clock triggerClock();

    public LogicalPlan logicalPlan();

    public QueryExecution lastExecution();

    public scala.collection.immutable.Map<SparkDataStream, LogicalPlan> newData();

    public Option<StreamWriterCommitProgress> sinkCommitProgress();

    public Seq<SparkDataStream> sources();

    public Table sink();

    public OffsetSeqMetadata offsetSeqMetadata();

    public long currentBatchId();

    public SparkSession sparkSession();

    public void postEvent(StreamingQueryListener.Event var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(long var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(long var1);

    public scala.collection.immutable.Map<SparkDataStream, String> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq(scala.collection.immutable.Map<SparkDataStream, String> var1);

    public scala.collection.immutable.Map<SparkDataStream, String> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq(scala.collection.immutable.Map<SparkDataStream, String> var1);

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(long var1);

    public scala.collection.mutable.HashMap<String, Object> org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs();

    public boolean org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(boolean var1);

    public Queue<StreamingQueryProgress> org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval();

    public long org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime();

    public void org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime_$eq(long var1);

    public SimpleDateFormat org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat();

    public StreamingQueryStatus currentStatus();

    public void currentStatus_$eq(StreamingQueryStatus var1);

    public static /* synthetic */ StreamingQueryStatus status$(ProgressReporter $this) {
        return $this.status();
    }

    default public StreamingQueryStatus status() {
        return this.currentStatus();
    }

    public static /* synthetic */ StreamingQueryProgress[] recentProgress$(ProgressReporter $this) {
        return $this.recentProgress();
    }

    default public StreamingQueryProgress[] recentProgress() {
        StreamingQueryProgress[] streamingQueryProgressArray;
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            streamingQueryProgressArray = (StreamingQueryProgress[])this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().toArray(ClassTag$.MODULE$.apply(StreamingQueryProgress.class));
        }
        return streamingQueryProgressArray;
    }

    public static /* synthetic */ StreamingQueryProgress lastProgress$(ProgressReporter $this) {
        return $this.lastProgress();
    }

    default public StreamingQueryProgress lastProgress() {
        StreamingQueryProgress streamingQueryProgress;
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            streamingQueryProgress = (StreamingQueryProgress)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().lastOption().orNull(Predef$.MODULE$.$conforms());
        }
        return streamingQueryProgress;
    }

    public static /* synthetic */ void startTrigger$(ProgressReporter $this) {
        $this.startTrigger();
    }

    default public void startTrigger() {
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> "Starting Trigger Calculation");
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp());
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(this.triggerClock().getTimeMillis());
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq(null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq(null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().clear();
    }

    public static /* synthetic */ void recordTriggerOffsets$(ProgressReporter $this, StreamProgress from, StreamProgress to) {
        $this.recordTriggerOffsets(from, to);
    }

    default public void recordTriggerOffsets(StreamProgress from, StreamProgress to) {
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets_$eq(from.mapValues((Function1 & Serializable & scala.Serializable)x$1 -> x$1.json()));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets_$eq(to.mapValues((Function1 & Serializable & scala.Serializable)x$2 -> x$2.json()));
    }

    private void updateProgress(StreamingQueryProgress newProgress) {
        Queue<StreamingQueryProgress> queue = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer();
        synchronized (queue) {
            this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().$plus$eq((Object)newProgress);
            while (this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().length() >= this.sparkSession().sqlContext().conf().streamingProgressRetention()) {
                this.org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer().dequeue();
            }
        }
        this.postEvent(new StreamingQueryListener.QueryProgressEvent(newProgress));
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Streaming query made progress: ").append(newProgress).toString());
    }

    public static /* synthetic */ void finishTrigger$(ProgressReporter $this, boolean hasNewData, boolean hasExecuted) {
        $this.finishTrigger(hasNewData, hasExecuted);
    }

    default public void finishTrigger(boolean hasNewData, boolean hasExecuted) {
        Predef$.MODULE$.assert(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets() != null && this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets() != null);
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(this.triggerClock().getTimeMillis());
        ExecutionStats executionStats = this.extractExecutionStats(hasNewData, hasExecuted);
        long processingTimeMills = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp() - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp();
        double processingTimeSec = (double)Math.max(1L, processingTimeMills) / (double)1000L;
        double inputTimeSec = this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp() >= 0L ? (double)(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp() - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp()) / (double)1000L : Double.NaN;
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Execution stats: ").append(executionStats).toString());
        Seq sourceProgress = (Seq)((TraversableLike)this.sources().distinct()).map((Function1 & Serializable & scala.Serializable)source -> {
            long numRecords = BoxesRunTime.unboxToLong((Object)executionStats.inputRows().getOrElse(source, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            return new SourceProgress(source.toString(), (String)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartOffsets().get(source).orNull(Predef$.MODULE$.$conforms()), (String)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndOffsets().get(source).orNull(Predef$.MODULE$.$conforms()), numRecords, (double)numRecords / inputTimeSec, (double)numRecords / processingTimeSec);
        }, Seq$.MODULE$.canBuildFrom());
        Option sinkOutput = hasExecuted ? this.sinkCommitProgress().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.numOutputRows())) : this.sinkCommitProgress().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)ProgressReporter.$anonfun$finishTrigger$5(x$4)));
        SinkProgress sinkProgress = SinkProgress$.MODULE$.apply(this.sink().toString(), (Option<Object>)sinkOutput);
        scala.collection.immutable.Map<String, Row> observedMetrics = this.extractObservedMetrics(hasNewData, this.lastExecution());
        StreamingQueryProgress newProgress = new StreamingQueryProgress(this.id(), this.runId(), this.name(), this.formatTimestamp(this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp()), this.currentBatchId(), processingTimeMills, new HashMap<String, Long>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().toMap(Predef$.MODULE$.$conforms()).mapValues((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)x)))).asJava()), new HashMap<String, String>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(executionStats.eventTimeStats()).asJava()), (StateOperatorProgress[])executionStats.stateOperators().toArray(ClassTag$.MODULE$.apply(StateOperatorProgress.class)), (SourceProgress[])sourceProgress.toArray(ClassTag$.MODULE$.apply(SourceProgress.class)), sinkProgress, new HashMap<String, Row>((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(observedMetrics).asJava()));
        if (hasExecuted) {
            this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime_$eq(this.triggerClock().getTimeMillis());
            this.updateProgress(newProgress);
        } else {
            long now = this.triggerClock().getTimeMillis();
            if (now - this.org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval() >= this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime()) {
                this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime_$eq(now);
                this.updateProgress(newProgress);
            }
        }
        StreamingQueryStatus qual$1 = this.currentStatus();
        boolean x$1 = false;
        String x$2 = qual$1.copy$default$1();
        boolean x$32 = qual$1.copy$default$2();
        this.currentStatus_$eq(qual$1.copy(x$2, x$32, x$1));
    }

    private Seq<StateOperatorProgress> extractStateOperatorMetrics(boolean hasExecuted) {
        if (this.lastExecution() == null) {
            return Nil$.MODULE$;
        }
        return this.lastExecution().executedPlan().collect((PartialFunction)new scala.Serializable(null, hasExecuted){
            public static final long serialVersionUID = 0L;
            private final boolean hasExecuted$1;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StateStoreWriter) {
                    StateOperatorProgress progress = ((StateStoreWriter)((Object)A1)).getProgress();
                    object = this.hasExecuted$1 ? progress : progress.copy(0L);
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof StateStoreWriter;
                return bl;
            }
            {
                this.hasExecuted$1 = hasExecuted$1;
            }
        });
    }

    private ExecutionStats extractExecutionStats(boolean hasNewData, boolean hasExecuted) {
        boolean hasEventTime = this.logicalPlan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                EventTimeWatermark eventTimeWatermark;
                A1 A1 = x1;
                Object object = A1 instanceof EventTimeWatermark ? (eventTimeWatermark = (EventTimeWatermark)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof EventTimeWatermark;
                return bl;
            }
        }).nonEmpty();
        scala.collection.immutable.Map watermarkTimestamp = hasEventTime ? (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"watermark"), (Object)this.formatTimestamp(this.offsetSeqMetadata().batchWatermarkMs()))})) : Predef$.MODULE$.Map().empty();
        Seq<StateOperatorProgress> stateOperators = this.extractStateOperatorMetrics(hasExecuted);
        if (!hasNewData) {
            return new ExecutionStats(this, (scala.collection.immutable.Map<SparkDataStream, Object>)Predef$.MODULE$.Map().empty(), stateOperators, (scala.collection.immutable.Map<String, String>)watermarkTimestamp);
        }
        scala.collection.immutable.Map<SparkDataStream, Object> numInputRows = this.extractSourceToNumInputRows();
        scala.collection.immutable.Map eventTimeStats = ((MapLike)this.lastExecution().executedPlan().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProgressReporter $outer;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                EventTimeWatermarkExec eventTimeWatermarkExec;
                A1 A1 = x2;
                if (A1 instanceof EventTimeWatermarkExec && (eventTimeWatermarkExec = (EventTimeWatermarkExec)A1).eventTimeStats().value().count() > 0L) {
                    EventTimeStats stats = eventTimeWatermarkExec.eventTimeStats().value();
                    object = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max"), (Object)BoxesRunTime.boxToLong((long)stats.max())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min"), (Object)BoxesRunTime.boxToLong((long)stats.min())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"avg"), (Object)BoxesRunTime.boxToLong((long)((long)stats.avg())))}))).mapValues((Function1 & Serializable & scala.Serializable)millis -> $anonfun$2.$anonfun$applyOrElse$1(this, BoxesRunTime.unboxToLong((Object)millis)));
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                EventTimeWatermarkExec eventTimeWatermarkExec;
                SparkPlan sparkPlan = x2;
                boolean bl = sparkPlan instanceof EventTimeWatermarkExec && (eventTimeWatermarkExec = (EventTimeWatermarkExec)sparkPlan).eventTimeStats().value().count() > 0L;
                return bl;
            }

            public static final /* synthetic */ String $anonfun$applyOrElse$1($anonfun$2 $this, long millis) {
                return $this.$outer.formatTimestamp(millis);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.execution.streaming.ProgressReporter$$anonfun$2 java.lang.Object )}, serializedLambda);
            }
        }).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)watermarkTimestamp);
        return new ExecutionStats(this, numInputRows, stateOperators, (scala.collection.immutable.Map<String, String>)eventTimeStats);
    }

    private scala.collection.immutable.Map<SparkDataStream, Object> extractSourceToNumInputRows() {
        scala.collection.immutable.Map map;
        Seq allStreamingLeaves = this.logicalPlan().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof StreamingDataSourceV2Relation) {
                    StreamingDataSourceV2Relation streamingDataSourceV2Relation = (StreamingDataSourceV2Relation)A1;
                    object = BoxesRunTime.boxToBoolean((boolean)(streamingDataSourceV2Relation.stream() instanceof MicroBatchStream));
                } else {
                    object = A1 instanceof StreamingExecutionRelation ? BoxesRunTime.boxToBoolean((boolean)false) : function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof StreamingDataSourceV2Relation ? true : logicalPlan2 instanceof StreamingExecutionRelation;
                return bl;
            }
        });
        boolean onlyDataSourceV2Sources = allStreamingLeaves.forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ProgressReporter.$anonfun$extractSourceToNumInputRows$4(BoxesRunTime.unboxToBoolean((Object)x$8))));
        if (onlyDataSourceV2Sources) {
            Seq sourceToInputRowsTuples = this.lastExecution().executedPlan().collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof MicroBatchScanExec) {
                        MicroBatchScanExec microBatchScanExec = (MicroBatchScanExec)A1;
                        long numRows = BoxesRunTime.unboxToLong((Object)microBatchScanExec.metrics().get((Object)"numOutputRows").map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)$anonfun$4.$anonfun$applyOrElse$2(x$9))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                        MicroBatchStream source = microBatchScanExec.stream();
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source), (Object)BoxesRunTime.boxToLong((long)numRows));
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(SparkPlan x2) {
                    SparkPlan sparkPlan = x2;
                    boolean bl = sparkPlan instanceof MicroBatchScanExec;
                    return bl;
                }

                public static final /* synthetic */ long $anonfun$applyOrElse$2(SQLMetric x$9) {
                    return x$9.value();
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2$adapted(org.apache.spark.sql.execution.metric.SQLMetric ), $anonfun$applyOrElse$3()}, serializedLambda);
                }
            });
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Source -> # input rows\n\t").append(sourceToInputRowsTuples.mkString("\n\t")).toString());
            map = ProgressReporter.sumRows$1(sourceToInputRowsTuples);
        } else {
            scala.collection.immutable.Map logicalPlanLeafToSource = (scala.collection.immutable.Map)this.newData().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                SparkDataStream source = (SparkDataStream)tuple2._1();
                LogicalPlan logicalPlan2 = (LogicalPlan)tuple2._2();
                Seq seq = (Seq)logicalPlan2.collectLeaves().map((Function1 & Serializable & scala.Serializable)leaf -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(leaf), (Object)source), Seq$.MODULE$.canBuildFrom());
                return seq;
            }, Map$.MODULE$.canBuildFrom());
            Seq allLogicalPlanLeaves = this.lastExecution().logical().collectLeaves();
            Seq allExecPlanLeaves = this.lastExecution().executedPlan().collectLeaves();
            if (allLogicalPlanLeaves.size() == allExecPlanLeaves.size()) {
                Seq execLeafToSource = (Seq)((TraversableLike)allLogicalPlanLeaves.zip((GenIterable)allExecPlanLeaves, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    LogicalPlan lp = (LogicalPlan)tuple2._1();
                    SparkPlan ep = (SparkPlan)((Object)((Object)tuple2._2()));
                    Iterable iterable = Option$.MODULE$.option2Iterable(logicalPlanLeafToSource.get((Object)lp).map((Function1 & Serializable & scala.Serializable)source -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ep), source)));
                    return iterable;
                }, Seq$.MODULE$.canBuildFrom());
                Seq sourceToInputRowsTuples = (Seq)execLeafToSource.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    SparkPlan execLeaf = (SparkPlan)((Object)((Object)tuple2._1()));
                    SparkDataStream source = (SparkDataStream)tuple2._2();
                    long numRows = BoxesRunTime.unboxToLong((Object)execLeaf.metrics().get((Object)"numOutputRows").map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.value())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)source), (Object)BoxesRunTime.boxToLong((long)numRows));
                    return tuple22;
                }, Seq$.MODULE$.canBuildFrom());
                map = ProgressReporter.sumRows$1(sourceToInputRowsTuples);
            } else {
                if (!this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged()) {
                    this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(154).append("Could not report metrics as number leaves in trigger logical plan did not match that").append(" of the execution plan:\n").append("logical plan leaves: ").append(ProgressReporter.toString$1(allLogicalPlanLeaves)).append("\n").append("execution plan leaves: ").append(ProgressReporter.toString$1(allExecPlanLeaves)).append("\n").toString());
                    this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(true);
                }
                map = Predef$.MODULE$.Map().empty();
            }
        }
        return map;
    }

    private scala.collection.immutable.Map<String, Row> extractObservedMetrics(boolean hasNewData, QueryExecution lastExecution) {
        if (!hasNewData || lastExecution == null) {
            return Predef$.MODULE$.Map().empty();
        }
        return lastExecution.observedMetrics();
    }

    public static /* synthetic */ Object reportTimeTaken$(ProgressReporter $this, String triggerDetailKey, Function0 body) {
        return $this.reportTimeTaken(triggerDetailKey, body);
    }

    default public <T> T reportTimeTaken(String triggerDetailKey, Function0<T> body) {
        long startTime = this.triggerClock().getTimeMillis();
        Object result = body.apply();
        long endTime = this.triggerClock().getTimeMillis();
        long timeTaken = package$.MODULE$.max(endTime - startTime, 0L);
        long previousTime = BoxesRunTime.unboxToLong((Object)this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().getOrElse((Object)triggerDetailKey, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs().put((Object)triggerDetailKey, (Object)BoxesRunTime.boxToLong((long)(previousTime + timeTaken)));
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append(triggerDetailKey).append(" took ").append(timeTaken).append(" ms").toString());
        return (T)result;
    }

    public static /* synthetic */ String formatTimestamp$(ProgressReporter $this, long millis) {
        return $this.formatTimestamp(millis);
    }

    default public String formatTimestamp(long millis) {
        return this.org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat().format(new Date(millis));
    }

    public static /* synthetic */ void updateStatusMessage$(ProgressReporter $this, String message) {
        $this.updateStatusMessage(message);
    }

    default public void updateStatusMessage(String message) {
        StreamingQueryStatus qual$1 = this.currentStatus();
        String x$1 = message;
        boolean x$2 = qual$1.copy$default$2();
        boolean x$3 = qual$1.copy$default$3();
        this.currentStatus_$eq(qual$1.copy(x$1, x$2, x$3));
    }

    public static /* synthetic */ long $anonfun$finishTrigger$5(StreamWriterCommitProgress x$4) {
        return 0L;
    }

    public static /* synthetic */ long $anonfun$extractSourceToNumInputRows$2(Seq x$6) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)x$6.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7._2$mcJ$sp()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    private static scala.collection.immutable.Map sumRows$1(Seq tuples) {
        return tuples.groupBy((Function1 & Serializable & scala.Serializable)x$5 -> (SparkDataStream)x$5._1()).mapValues((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)ProgressReporter.$anonfun$extractSourceToNumInputRows$2(x$6)));
    }

    public static /* synthetic */ boolean $anonfun$extractSourceToNumInputRows$4(boolean x$8) {
        return x$8;
    }

    private static String toString$1(Seq seq) {
        return new StringBuilder(11).append("(size = ").append(seq.size()).append("), ").append(seq.mkString(", ")).toString();
    }

    public static void $init$(ProgressReporter $this) {
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerStartTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$currentTriggerEndTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastTriggerStartTimestamp_$eq(-1L);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$currentDurationsMs_$eq((scala.collection.mutable.HashMap<String, Object>)new scala.collection.mutable.HashMap());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$metricWarningLogged_$eq(false);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$progressBuffer_$eq((Queue<StreamingQueryProgress>)new Queue());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$noDataProgressEventInterval_$eq($this.sparkSession().sessionState().conf().streamingNoDataProgressEventInterval());
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$lastNoExecutionProgressEventTime_$eq(Long.MIN_VALUE);
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$_setter_$org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat_$eq(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
        $this.org$apache$spark$sql$execution$streaming$ProgressReporter$$timestampFormat().setTimeZone(DateTimeUtils$.MODULE$.getTimeZone("UTC"));
        $this.currentStatus_$eq(new StreamingQueryStatus("Initializing StreamExecution", false, false));
    }

    public class ExecutionStats
    implements Product,
    scala.Serializable {
        private final scala.collection.immutable.Map<SparkDataStream, Object> inputRows;
        private final Seq<StateOperatorProgress> stateOperators;
        private final scala.collection.immutable.Map<String, String> eventTimeStats;
        public final /* synthetic */ ProgressReporter $outer;

        public scala.collection.immutable.Map<SparkDataStream, Object> inputRows() {
            return this.inputRows;
        }

        public Seq<StateOperatorProgress> stateOperators() {
            return this.stateOperators;
        }

        public scala.collection.immutable.Map<String, String> eventTimeStats() {
            return this.eventTimeStats;
        }

        public ExecutionStats copy(scala.collection.immutable.Map<SparkDataStream, Object> inputRows, Seq<StateOperatorProgress> stateOperators, scala.collection.immutable.Map<String, String> eventTimeStats) {
            return new ExecutionStats(this.org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer(), inputRows, stateOperators, eventTimeStats);
        }

        public scala.collection.immutable.Map<SparkDataStream, Object> copy$default$1() {
            return this.inputRows();
        }

        public Seq<StateOperatorProgress> copy$default$2() {
            return this.stateOperators();
        }

        public scala.collection.immutable.Map<String, String> copy$default$3() {
            return this.eventTimeStats();
        }

        public String productPrefix() {
            return "ExecutionStats";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.inputRows();
                    break;
                }
                case 1: {
                    object = this.stateOperators();
                    break;
                }
                case 2: {
                    object = this.eventTimeStats();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExecutionStats;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ExecutionStats)) return false;
            if (((ExecutionStats)object).org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer() != this.org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ExecutionStats executionStats = (ExecutionStats)x$1;
            scala.collection.immutable.Map<SparkDataStream, Object> map = this.inputRows();
            scala.collection.immutable.Map<SparkDataStream, Object> map2 = executionStats.inputRows();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Seq<StateOperatorProgress> seq = this.stateOperators();
            Seq<StateOperatorProgress> seq2 = executionStats.stateOperators();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            scala.collection.immutable.Map<String, String> map3 = this.eventTimeStats();
            scala.collection.immutable.Map<String, String> map4 = executionStats.eventTimeStats();
            if (map3 == null) {
                if (map4 != null) {
                    return false;
                }
            } else if (!map3.equals(map4)) return false;
            if (!executionStats.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ProgressReporter org$apache$spark$sql$execution$streaming$ProgressReporter$ExecutionStats$$$outer() {
            return this.$outer;
        }

        public ExecutionStats(ProgressReporter $outer, scala.collection.immutable.Map<SparkDataStream, Object> inputRows, Seq<StateOperatorProgress> stateOperators, scala.collection.immutable.Map<String, String> eventTimeStats) {
            this.inputRows = inputRows;
            this.stateOperators = stateOperators;
            this.eventTimeStats = eventTimeStats;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

