/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp.schemas;

import java.util.Date;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.XMPSchemaAdapter;
import org.apache.xmlgraphics.xmp.XMPSchemaRegistry;

public class DublinCoreAdapter
extends XMPSchemaAdapter {
    private static final String CREATOR = "creator";
    private static final String DATE = "date";
    private static final String SUBJECT = "subject";
    private static final String TITLE = "title";
    private static final String DESCRIPTION = "description";
    private static final String LANGUAGE = "language";

    public DublinCoreAdapter(Metadata meta) {
        super(meta, XMPSchemaRegistry.getInstance().getSchema("http://purl.org/dc/elements/1.1/"));
    }

    public void addCreator(String value) {
        this.addStringToSeq(CREATOR, value);
    }

    public String[] getCreators() {
        return this.getStringArray(CREATOR);
    }

    public void addDate(Date value) {
        this.addDateToSeq(DATE, value);
    }

    public Date[] getDates() {
        return this.getDateArray(DATE);
    }

    public Date getDate() {
        Date[] dates = this.getDates();
        if (dates != null) {
            Date latest = null;
            int c = dates.length;
            for (int i = 0; i < c; ++i) {
                if (latest != null && dates[i].getTime() <= latest.getTime()) continue;
                latest = dates[i];
            }
            return latest;
        }
        return null;
    }

    public void addSubject(String value) {
        this.addStringToBag(SUBJECT, value);
    }

    public String[] getSubjects() {
        return this.getStringArray(SUBJECT);
    }

    public void setTitle(String value) {
        this.setTitle(null, value);
    }

    public void setTitle(String lang, String value) {
        this.setLangAlt(TITLE, lang, value);
    }

    public String getTitle() {
        return this.getTitle(null);
    }

    public String getTitle(String lang) {
        return this.getLangAlt(lang, TITLE);
    }

    public void setDescription(String lang, String value) {
        this.setLangAlt(DESCRIPTION, lang, value);
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public String getDescription(String lang) {
        return this.getLangAlt(lang, DESCRIPTION);
    }

    public void addLanguage(String value) {
        this.addStringToBag(LANGUAGE, value);
    }

    public String[] getLanguages() {
        return this.getStringArray(LANGUAGE);
    }
}

