/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.mail;

import java.net.URISyntaxException;
import org.ardulink.core.Link;
import org.ardulink.core.Pin;
import org.ardulink.mail.Command;

public class Commands {
    public static Command switchDigitalPin(int pin, boolean value) {
        return new SwitchDigitalPinCommand(pin, value);
    }

    public static Command switchAnalogPin(int pin, int value) {
        return new SwitchAnalogPinCommand(pin, value);
    }

    private static class SwitchAnalogPinCommand
    implements Command {
        private final int pin;
        private final int value;

        public SwitchAnalogPinCommand(int pin, int value) {
            this.pin = pin;
            this.value = value;
        }

        @Override
        public void execute(Link link) throws URISyntaxException, Exception {
            link.switchAnalogPin(Pin.analogPin((int)this.pin), this.value);
        }

        public String toString() {
            return "SwitchAnalogPinCommand [pin=" + this.pin + ", value=" + this.value + "]";
        }
    }

    private static class SwitchDigitalPinCommand
    implements Command {
        private final int pin;
        private final boolean value;

        public SwitchDigitalPinCommand(int pin, boolean value) {
            this.pin = pin;
            this.value = value;
        }

        @Override
        public void execute(Link link) throws URISyntaxException, Exception {
            link.switchDigitalPin(Pin.digitalPin((int)this.pin), this.value);
        }

        public String toString() {
            return "SwitchDigitalPinCommand [pin=" + this.pin + ", value=" + this.value + "]";
        }
    }
}

