/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.mail.camel;

import java.util.Iterator;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.UriEndpoint;
import org.ardulink.mail.Command;
import org.ardulink.mail.Commands;
import org.ardulink.mail.camel.ArdulinkEndpoint;
import org.ardulink.util.Integers;
import org.ardulink.util.Optional;
import org.ardulink.util.Preconditions;

@UriEndpoint(scheme="ardulink", syntax="ardulink:type", title="Ardulink Link")
public class ArdulinkComponent
extends UriEndpointComponent {
    private static final String SCENARIO_PREFIX = "scenario.";

    public ArdulinkComponent() {
        super(ArdulinkEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ArdulinkEndpoint.Config config = new ArdulinkEndpoint.Config();
        config.setType(remaining);
        config.setTypeParams((String)this.getOptional(parameters, "linkparams").orNull());
        config.setValidFroms(this.get(parameters, "validfroms").split("\\;"));
        this.handleScenarios(parameters, config);
        ArdulinkEndpoint endpoint = new ArdulinkEndpoint(uri, this, config);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    private void handleScenarios(Map<String, Object> parameters, ArdulinkEndpoint.Config config) {
        Iterator<Map.Entry<String, Object>> it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            if (!entry.getKey().startsWith(SCENARIO_PREFIX)) continue;
            String scenario = String.valueOf(parameters.get(entry.getKey()));
            it.remove();
            String name = entry.getKey().substring(SCENARIO_PREFIX.length());
            for (String pinAndValue : scenario.split("\\;")) {
                String[] pv = pinAndValue.split("\\=");
                String pinType = pv[0].substring(0, 1);
                int pin = (Integer)Preconditions.checkNotNull((Object)Integers.tryParse((String)pv[0].substring(1)), (String)"Could not parse %s as int", (Object[])new Object[]{pv[0].substring(1)});
                config.addCommand(name, this.createCommand(pinType, pin, pv));
            }
        }
    }

    private Command createCommand(String pinType, int pin, String[] pv) {
        if ("D".equalsIgnoreCase(pinType)) {
            return Commands.switchDigitalPin(pin, Boolean.parseBoolean(pv[1]));
        }
        if ("A".equalsIgnoreCase(pinType)) {
            return Commands.switchAnalogPin(pin, this.getInt(pv[1]));
        }
        throw new IllegalStateException("Unknown pin type " + pinType);
    }

    private String get(Map<String, Object> parameters, String key) {
        return (String)this.getOptional(parameters, key).getOrThrow("%s not configured", new Object[]{key});
    }

    private Optional<String> getOptional(Map<String, Object> parameters, String key) {
        return parameters.containsKey(key) ? Optional.of((Object)String.valueOf(parameters.remove(key))) : Optional.absent();
    }

    private int getInt(String string) {
        return (Integer)Preconditions.checkNotNull((Object)Integers.tryParse((String)string), (String)"Could not parse %s as int", (Object[])new Object[]{string});
    }
}

