/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.mail.camel;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.ardulink.mail.Command;
import org.ardulink.mail.camel.ArdulinkComponent;
import org.ardulink.mail.camel.ArdulinkProducer;
import org.ardulink.util.ListMultiMap;

public class ArdulinkEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport {
    private Config config;

    public ArdulinkEndpoint(String uri, ArdulinkComponent ardulinkComponent, Config config) {
        super(uri, (Component)ardulinkComponent);
        this.config = config;
    }

    public Producer createProducer() throws Exception {
        ArdulinkProducer ardulinkProducer = new ArdulinkProducer((Endpoint)this, this.config.type, this.config.typeParams);
        ardulinkProducer.setValidFroms(this.config.validfroms);
        for (Map.Entry entry : this.config.commands.asMap().entrySet()) {
            ardulinkProducer.setCommands((String)entry.getKey(), (List)entry.getValue());
        }
        return ardulinkProducer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("not implemented");
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    public static class Config {
        private String type;
        private String typeParams;
        private List<String> validfroms;
        private ListMultiMap<String, Command> commands = new ListMultiMap();

        public void setValidFroms(String ... validfroms) {
            this.validfroms = Arrays.asList((Object[])validfroms.clone());
        }

        public void setType(String type) {
            this.type = type;
        }

        public void addCommand(String name, Command command) {
            this.commands.put((Object)name, (Object)command);
        }

        public void setTypeParams(String typeParams) {
            this.typeParams = typeParams;
        }
    }
}

