/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.mail.camel;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultProducer;
import org.ardulink.core.Link;
import org.ardulink.core.convenience.Links;
import org.ardulink.mail.Command;
import org.ardulink.util.Joiner;
import org.ardulink.util.ListMultiMap;
import org.ardulink.util.Lists;
import org.ardulink.util.Optional;
import org.ardulink.util.Preconditions;
import org.ardulink.util.Throwables;

public class ArdulinkProducer
extends DefaultProducer {
    private final Link link;
    private final List<String> validFroms = new ArrayList<String>();
    private final ListMultiMap<String, Command> commands = new ListMultiMap();

    public ArdulinkProducer(Endpoint endpoint, String type, String typeParams) {
        super(endpoint);
        try {
            String str = "ardulink://" + (String)Preconditions.checkNotNull((Object)type, (String)"type must not be null", (Object[])new Object[0]);
            if (typeParams != null && !typeParams.isEmpty()) {
                str = str + "?" + typeParams;
            }
            this.link = Links.getLink((URI)new URI(str));
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void process(Exchange exchange) throws Exception {
        Optional<String> out = this.process(exchange.getIn());
        if (out.isPresent()) {
            this.getMessageTarget(exchange).setBody(out.get(), String.class);
        }
    }

    private Message getMessageTarget(Exchange exchange) {
        Message in = exchange.getIn();
        if (exchange.getPattern().isOutCapable()) {
            Message out = exchange.getOut();
            out.setHeaders(in.getHeaders());
            out.setAttachments(in.getAttachments());
            return out;
        }
        return in;
    }

    public void stop() throws Exception {
        this.link.close();
        super.stop();
    }

    private Optional<String> process(Message message) {
        String from = (String)message.getHeader("From", String.class);
        Preconditions.checkState((from != null && !from.isEmpty() ? 1 : 0) != 0, (String)"No from set in message", (Object[])new Object[0]);
        Preconditions.checkState((boolean)this.validFroms.contains(from), (String)"From user %s not a valid from address", (Object[])new Object[]{from});
        Preconditions.checkState((boolean)(message.getBody() instanceof String), (String)"Body not a String", (Object[])new Object[0]);
        String commandName = (String)message.getBody();
        Preconditions.checkState((!commandName.isEmpty() ? 1 : 0) != 0, (String)"Body not set", (Object[])new Object[0]);
        for (Map.Entry entry : this.commands.asMap().entrySet()) {
            String key = (String)entry.getKey();
            if (!commandName.equals(key)) continue;
            List values = (List)entry.getValue();
            List results = Lists.newArrayList((Object[])new String[0]);
            for (Command command : values) {
                try {
                    command.execute(this.link);
                    results.add(command + "=OK");
                }
                catch (Exception e) {
                    results.add(command + "=KO");
                }
            }
            return Optional.of((Object)Joiner.on((String)"\n").join((Iterable)results));
        }
        return Optional.absent();
    }

    public void setValidFroms(List<String> validFroms) {
        this.validFroms.addAll(validFroms);
    }

    public void setCommands(String onValue, Command ... commands) {
        this.setCommands(onValue, Arrays.asList(commands));
    }

    public void setCommands(String onValue, List<Command> commands) {
        for (Command command : commands) {
            this.commands.put((Object)onValue, (Object)command);
        }
    }
}

