/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.gradle.base;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.asciidoctor.gradle.base.AscGitHubArchive;
import org.asciidoctor.gradle.base.AscGitLabArchive;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.provider.Provider;
import org.ysb33r.grolifant.api.core.ClosureUtils;
import org.ysb33r.grolifant.api.core.ProjectOperations;
import org.ysb33r.grolifant.api.core.git.AbstractCloudGit;
import org.ysb33r.grolifant.api.core.git.CloudGitDescriptor;
import org.ysb33r.grolifant.api.core.git.GitLabArchive;
import org.ysb33r.grolifant.api.core.git.GitRepoArchiveDownloader;

public abstract class AbstractDownloadableComponent<ComponentSrc, ResolvedComponent> {
    protected final ProjectOperations projectOperations;
    private final Map<String, Callable<ResolvedComponent>> components = new LinkedHashMap<String, Callable<ResolvedComponent>>();
    private final Provider<File> downloadRootProvider;

    public void local(String name, Action<ComponentSrc> localConfig) {
        ComponentSrc component = this.instantiateComponentSource(name);
        localConfig.execute(component);
        this.components.put(name, this.convertible(component));
    }

    public void github(String name, Action<AscGitHubArchive> githubConfig) {
        AscGitHubArchive archive = new AscGitHubArchive(this.projectOperations);
        githubConfig.execute((Object)archive);
        this.components.put(name, this.convertible(name, (AbstractCloudGit)archive));
    }

    public void gitlab(String name, @DelegatesTo(value=GitLabArchive.class) Closure<?> gitlabConfig) {
        AscGitLabArchive archive = new AscGitLabArchive(this.projectOperations);
        ClosureUtils.configureItem((Object)((Object)archive), gitlabConfig);
        this.components.put(name, this.convertible(name, (AbstractCloudGit)archive));
    }

    public void gitlab(String name, Action<AscGitLabArchive> gitlabConfig) {
        AscGitLabArchive archive = new AscGitLabArchive(this.projectOperations);
        gitlabConfig.execute((Object)archive);
        this.components.put(name, this.convertible(name, (AbstractCloudGit)archive));
    }

    public ResolvedComponent getByName(String name) {
        try {
            if (this.components.containsKey(name)) {
                return this.components.get(name).call();
            }
        }
        catch (Exception e) {
            throw new UnknownDomainObjectException("Unexpected error when tryying to retrieve " + name, (Throwable)e);
        }
        throw new UnknownDomainObjectException("Theme with name '" + name + "' was not registered");
    }

    protected AbstractDownloadableComponent(Project project) {
        this.projectOperations = ProjectOperations.find((Project)project);
        this.downloadRootProvider = this.projectOperations.buildDirDescendant((Object)"cloud-archives");
    }

    protected Callable<ResolvedComponent> convertible(String name, AbstractCloudGit component) {
        GitRepoArchiveDownloader downloader = new GitRepoArchiveDownloader((CloudGitDescriptor)component, this.projectOperations);
        String relativePath = this.getRelativePathInsideArchive(component);
        return () -> {
            downloader.setDownloadRoot((File)this.downloadRootProvider.get());
            File root = downloader.getArchiveRoot();
            return this.instantiateResolvedComponent(name, relativePath != null ? new File(root, relativePath) : root);
        };
    }

    protected abstract ComponentSrc instantiateComponentSource(String var1);

    protected abstract Callable<ResolvedComponent> convertible(ComponentSrc var1);

    protected abstract ResolvedComponent instantiateResolvedComponent(String var1, File var2);

    private void addCloudGitArchive(String name, AbstractCloudGit archive, Action<? super AbstractCloudGit> config) {
        config.execute((Object)archive);
        this.components.put(name, this.convertible(name, archive));
    }

    private String getRelativePathInsideArchive(AbstractCloudGit theme) {
        return (String)theme.getProperty("relativePath");
    }
}

