/*
 * Copyright 2013-2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.asciidoctor.gradle.internal

import groovy.transform.CompileStatic
import org.gradle.api.logging.LogLevel

/** Utility methods for dealing with executors.
 *
 * @since 2.0
 */
@CompileStatic
class ExecutorUtils {

    /** Determines an executor logging level from the current Gradle logging level
     *
     * @param level
     * @return
     */
    static ExecutorLogLevel getExecutorLogLevel(LogLevel level) {
        switch (level) {
            case LogLevel.DEBUG:
                return ExecutorLogLevel.DEBUG
            case LogLevel.LIFECYCLE:
            case LogLevel.WARN:
                return ExecutorLogLevel.WARN
            case LogLevel.INFO:
                return ExecutorLogLevel.INFO
            case LogLevel.QUIET:
                return ExecutorLogLevel.QUIET
            default:
                return ExecutorLogLevel.ERROR
        }
    }
}
