/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import java.io.File;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.listeners.PreMessageReceivedEventListener;
import org.bitcoinj.kits.WalletAppKit;
import org.bitcoinj.params.RegTestParams;
import org.bitcoinj.utils.BriefLogFormatter;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.Wallet;

public class DoubleSpend {
    public static void main(String[] args) throws Exception {
        BriefLogFormatter.init();
        RegTestParams params = RegTestParams.get();
        WalletAppKit kit = new WalletAppKit((NetworkParameters)params, new File("."), "doublespend");
        kit.connectToLocalHost();
        kit.setAutoSave(false);
        kit.startAsync();
        kit.awaitRunning();
        System.out.println(kit.wallet());
        kit.wallet().getBalanceFuture(Coin.COIN, Wallet.BalanceType.AVAILABLE).get();
        Transaction tx1 = kit.wallet().createSend(Address.fromBase58((NetworkParameters)params, (String)"muYPFNCv7KQEG2ZLM7Z3y96kJnNyXJ53wm"), Coin.CENT);
        Transaction tx2 = kit.wallet().createSend(Address.fromBase58((NetworkParameters)params, (String)"muYPFNCv7KQEG2ZLM7Z3y96kJnNyXJ53wm"), Coin.CENT.add(Coin.SATOSHI.multiply(10L)));
        Peer peer = (Peer)kit.peerGroup().getConnectedPeers().get(0);
        peer.addPreMessageReceivedEventListener(Threading.SAME_THREAD, new PreMessageReceivedEventListener(){

            public Message onPreMessageReceived(Peer peer, Message m) {
                System.err.println("Got a message!" + m.getClass().getSimpleName() + ": " + m);
                return m;
            }
        });
        peer.sendMessage((Message)tx1);
        peer.sendMessage((Message)tx2);
        Thread.sleep(5000L);
        kit.stopAsync();
        kit.awaitTerminated();
    }
}

