/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import java.io.File;
import java.io.IOException;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.Range;

public class LevelDbSizes {
    public static void main(String[] args) throws Exception {
        DB db = null;
        Options options = new Options();
        options.createIfMissing(false);
        try {
            db = JniDBFactory.factory.open(new File(args[0]), options);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Thread.sleep(100000L);
        for (int i = 0; i < 10; ++i) {
            byte[] from = new byte[]{(byte)i};
            byte[] to = new byte[]{(byte)(i + 1)};
            long[] sizes = db.getApproximateSizes(new Range[]{new Range(from, to)});
            System.out.println("From:" + i + " to:" + (i + 1) + " Size: " + sizes[0]);
        }
        byte[] from = new byte[]{0};
        byte[] to = new byte[]{-128};
        long[] sizes = db.getApproximateSizes(new Range[]{new Range(from, to)});
        System.out.println("Size: " + sizes[0]);
        String stats = db.getProperty("leveldb.stats");
        System.out.println(stats);
        db.close();
    }
}

