/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.VersionMessage;
import org.bitcoinj.core.listeners.PeerConnectedEventListener;
import org.bitcoinj.core.listeners.PeerDisconnectedEventListener;
import org.bitcoinj.net.NioClientManager;
import org.bitcoinj.net.StreamConnection;
import org.bitcoinj.net.discovery.DnsDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.utils.BriefLogFormatter;

public class PrintPeers {
    private static InetSocketAddress[] dnsPeers;

    private static void printElapsed(long start) {
        long now = System.currentTimeMillis();
        System.out.println(String.format("Took %.2f seconds", (double)(now - start) / 1000.0));
    }

    private static void printPeers(InetSocketAddress[] addresses) {
        for (InetSocketAddress address : addresses) {
            String hostAddress = address.getAddress().getHostAddress();
            System.out.println(String.format("%s:%d", hostAddress, address.getPort()));
        }
    }

    private static void printDNS() throws PeerDiscoveryException {
        long start = System.currentTimeMillis();
        DnsDiscovery dns = new DnsDiscovery((NetworkParameters)MainNetParams.get());
        dnsPeers = dns.getPeers(0L, 10L, TimeUnit.SECONDS);
        PrintPeers.printPeers(dnsPeers);
        PrintPeers.printElapsed(start);
    }

    public static void main(String[] args) throws Exception {
        BriefLogFormatter.init();
        System.out.println("=== DNS ===");
        PrintPeers.printDNS();
        System.out.println("=== Version/chain heights ===");
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        for (InetSocketAddress peer : dnsPeers) {
            addrs.add(peer.getAddress());
        }
        System.out.println("Scanning " + addrs.size() + " peers:");
        MainNetParams params = MainNetParams.get();
        final Object lock = new Object();
        final long[] bestHeight = new long[1];
        ArrayList futures = Lists.newArrayList();
        NioClientManager clientManager = new NioClientManager();
        for (final InetAddress addr : addrs) {
            InetSocketAddress address = new InetSocketAddress(addr, params.getPort());
            final Peer peer = new Peer((NetworkParameters)params, new VersionMessage((NetworkParameters)params, 0), null, new PeerAddress(address));
            final SettableFuture future = SettableFuture.create();
            peer.addConnectedEventListener(new PeerConnectedEventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onPeerConnected(Peer p, int peerCount) {
                    VersionMessage ver = peer.getPeerVersionMessage();
                    long nodeHeight = ver.bestHeight;
                    Object object = lock;
                    synchronized (object) {
                        long diff = bestHeight[0] - nodeHeight;
                        if (diff > 0L) {
                            System.out.println("Node is behind by " + diff + " blocks: " + addr);
                        } else if (diff == 0L) {
                            System.out.println("Node " + addr + " has " + nodeHeight + " blocks");
                            bestHeight[0] = nodeHeight;
                        } else if (diff < 0L) {
                            System.out.println("Node is ahead by " + Math.abs(diff) + " blocks: " + addr);
                            bestHeight[0] = nodeHeight;
                        }
                    }
                    future.set(null);
                    peer.close();
                }
            });
            peer.addDisconnectedEventListener(new PeerDisconnectedEventListener(){

                public void onPeerDisconnected(Peer p, int peerCount) {
                    if (!future.isDone()) {
                        System.out.println("Failed to talk to " + addr);
                    }
                    future.set(null);
                }
            });
            clientManager.openConnection((SocketAddress)address, (StreamConnection)peer);
            futures.add(future);
        }
        Futures.successfulAsList((Iterable)futures).get();
    }
}

