/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.examples;

import java.io.File;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.BlockChain;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.core.listeners.DownloadProgressTracker;
import org.bitcoinj.core.listeners.PeerDataEventListener;
import org.bitcoinj.net.discovery.DnsDiscovery;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.params.TestNet3Params;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.SPVBlockStore;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bitcoinj.wallet.Wallet;

public class RestoreFromSeed {
    public static void main(String[] args) throws Exception {
        TestNet3Params params = TestNet3Params.get();
        String seedCode = "yard impulse luxury drive today throw farm pepper survey wreck glass federal";
        String passphrase = "";
        Long creationtime = 1409478661L;
        DeterministicSeed seed = new DeterministicSeed(seedCode, null, passphrase, creationtime.longValue());
        Wallet wallet = Wallet.fromSeed((NetworkParameters)params, (DeterministicSeed)seed);
        System.out.println(wallet.toString());
        wallet.clearTransactions(0);
        File chainFile = new File("restore-from-seed.spvchain");
        if (chainFile.exists()) {
            chainFile.delete();
        }
        SPVBlockStore chainStore = new SPVBlockStore((NetworkParameters)params, chainFile);
        BlockChain chain = new BlockChain((NetworkParameters)params, (BlockStore)chainStore);
        PeerGroup peers = new PeerGroup((NetworkParameters)params, (AbstractBlockChain)chain);
        peers.addPeerDiscovery((PeerDiscovery)new DnsDiscovery((NetworkParameters)params));
        chain.addWallet(wallet);
        peers.addWallet(wallet);
        DownloadProgressTracker bListener = new DownloadProgressTracker(){

            public void doneDownload() {
                System.out.println("blockchain downloaded");
            }
        };
        peers.start();
        peers.startBlockChainDownload((PeerDataEventListener)bListener);
        bListener.await();
        System.out.println(wallet.toString());
        peers.stop();
    }
}

