/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.modes.CFBModeCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.dispose.NativeDisposer;
import org.bouncycastle.util.dispose.NativeReference;

class AESNativeCFB
implements CFBModeCipher {
    private final int bitSize;
    private CFBRefWrapper referenceWrapper;
    private byte[] oldKey;
    private byte[] oldIv;
    private boolean encrypting;

    public AESNativeCFB() {
        this(128);
    }

    public AESNativeCFB(int n) {
        this.bitSize = n;
        switch (n) {
            case 128: {
                break;
            }
            default: {
                throw new IllegalArgumentException("native feedback bit size can only be 128");
            }
        }
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        boolean bl2 = this.encrypting;
        this.encrypting = bl;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (cipherParameters instanceof ParametersWithIV) {
            ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
            byArray2 = parametersWithIV.getIV();
            if (byArray2.length > this.getBlockSize() || byArray2.length < 1) {
                throw new IllegalArgumentException("initialisation vector must be between one and block size length");
            }
            if (byArray2.length < this.getBlockSize()) {
                byte[] byArray3 = new byte[this.getBlockSize()];
                System.arraycopy(byArray2, 0, byArray3, byArray3.length - byArray2.length, byArray2.length);
                byArray2 = byArray3;
            }
            this.oldIv = Arrays.clone(byArray2);
            if (parametersWithIV.getParameters() != null) {
                byArray = ((KeyParameter)parametersWithIV.getParameters()).getKey();
            }
            if (byArray != null) {
                bl2 = this.encrypting;
                this.oldKey = Arrays.clone(byArray);
            } else {
                byArray = this.oldKey;
            }
        } else if (cipherParameters instanceof KeyParameter) {
            byArray = ((KeyParameter)cipherParameters).getKey();
            this.oldKey = Arrays.clone(byArray);
            byArray2 = this.oldIv;
        }
        if (byArray == null && bl2 != this.encrypting) {
            throw new IllegalArgumentException("cannot change encrypting state without providing key.");
        }
        if (byArray2 == null) {
            throw new IllegalArgumentException("iv is null");
        }
        this.referenceWrapper = new CFBRefWrapper(AESNativeCFB.makeNative(this.encrypting, byArray.length));
        this.init(this.referenceWrapper.getReference(), byArray, byArray2);
    }

    @Override
    public String getAlgorithmName() {
        return "AES/CFB";
    }

    @Override
    public byte returnByte(byte by) {
        return AESNativeCFB.processByte(this.referenceWrapper.getReference(), by);
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCFB.processBytes(this.referenceWrapper.getReference(), byArray, n, n2, byArray2, n3);
    }

    @Override
    public int getBlockSize() {
        return this.bitSize / 8;
    }

    @Override
    public int processBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws DataLengthException, IllegalStateException {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("not initialized");
        }
        return AESNativeCFB.processBytes(this.referenceWrapper.getReference(), byArray, n, this.getBlockSize(), byArray2, n2);
    }

    @Override
    public void reset() {
        if (this.referenceWrapper == null) {
            return;
        }
        AESNativeCFB.reset(this.referenceWrapper.getReference());
    }

    @Override
    public int getMultiBlockSize() {
        return AESNativeCFB.getNativeMultiBlockSize();
    }

    @Override
    public int processBlocks(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (this.referenceWrapper == null) {
            throw new IllegalStateException("CFB engine not initialized");
        }
        return this.processBytes(byArray, n, n2 * this.getBlockSize(), byArray2, n3);
    }

    private static native byte processByte(long var0, byte var2);

    private static native int processBytes(long var0, byte[] var2, int var3, int var4, byte[] var5, int var6) throws DataLengthException;

    static native long makeNative(boolean var0, int var1);

    native void init(long var1, byte[] var3, byte[] var4);

    static native void dispose(long var0);

    static native int getNativeMultiBlockSize();

    private static native void reset(long var0);

    public String toString() {
        if (this.oldKey != null) {
            return "CFB[Native](AES[Native](" + this.oldKey.length * 8 + "))";
        }
        return "CFB[Native](AES[Native](not initialized))";
    }

    private static class CFBRefWrapper
    extends NativeReference {
        public CFBRefWrapper(long l) {
            super(l, "CFB");
        }

        @Override
        public Runnable createAction() {
            return new Disposer(this.reference);
        }
    }

    private static class Disposer
    extends NativeDisposer {
        Disposer(long l) {
            super(l);
        }

        @Override
        protected void dispose(long l) {
            AESNativeCFB.dispose(l);
        }
    }
}

