///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-util-string.ts"/>
///<reference path="butterfaces-util-object.ts"/>
(function ($) {
    // you have to extend jQuery with the fn["pluginName"] notation because in Typescript you can't extend
    // the existing typing interface with fn.pluginName!
    $.fn["butterMaxLength"] = function (options) {
        return this.each(function (index, element) {
            new ButterFaces.MaxLengthIndicator($(element), options);
        });
    };
})(jQuery);
var ButterFaces;
(function (ButterFaces) {
    var ERROR_STYLE_CLASS = "has-error";
    var INVALID_STYLE_CLASS = "is-invalid";
    var MaxLengthIndicator = /** @class */ (function () {
        function MaxLengthIndicator(rootElement, options) {
            this.rootElement = rootElement;
            this.options = options;
            this.valueElement = this.rootElement.find("textarea");
            this.maxLengthElement = $("<div>").addClass("butter-component-maxlength-counter");
            this.maxLengthElement.insertAfter(this.valueElement);
            this.initializeComponent();
        }
        MaxLengthIndicator.prototype.initializeComponent = function () {
            console.log("ButterFaces.MaxLengthIndicator - initializeComponent");
            this.hasInitialValidationError = this.rootElement.hasClass(ERROR_STYLE_CLASS);
            console.log(this.valueElement);
            var that = this;
            this.valueElement.on("focus blur keyup cut paste", function () {
                that.checkValue();
            });
            // initial check
            this.checkValue();
        };
        MaxLengthIndicator.prototype.checkValue = function () {
            var value = this.valueElement.val();
            if (!ButterFaces.Object.isNullOrUndefined(value)) {
                console.log("ButterFaces.MaxLengthIndicator: updating maxlength value");
                var freeLetterCount = this.options.maxLength - value.length;
                var formatted = ButterFaces.String.format(this.options.maxLengthText, [freeLetterCount, this.options.maxLength]);
                this.maxLengthElement.text(formatted);
                if (!this.hasInitialValidationError) {
                    if (freeLetterCount < 0) {
                        this.rootElement.addClass(ERROR_STYLE_CLASS);
                        this.valueElement.addClass(INVALID_STYLE_CLASS);
                    }
                    else {
                        this.rootElement.removeClass(ERROR_STYLE_CLASS);
                        this.valueElement.removeClass(INVALID_STYLE_CLASS);
                    }
                }
            }
        };
        return MaxLengthIndicator;
    }());
    ButterFaces.MaxLengthIndicator = MaxLengthIndicator;
})(ButterFaces || (ButterFaces = {}));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
