/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.html.table.export.el;

import java.beans.FeatureDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.html.HtmlGraphicImage;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.component.html.HtmlOutputLink;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextWrapper;
import javax.faces.context.ResponseWriter;
import org.butterfaces.component.html.action.HtmlCommandLink;
import org.butterfaces.component.html.table.HtmlColumn;
import org.butterfaces.component.html.table.export.writer.StringListResponseWriter;
import org.butterfaces.util.StringUtils;

public class TableExportELResolver
extends ELResolver {
    public static final String EXPORT_ERROR_TEXT = "<<Error while export>>";
    private static final Logger LOG = Logger.getLogger(TableExportELResolver.class.getName());
    private static final ThreadLocal<CurrentInstance> KEY_VALUE = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> resolveRow(String tableVar, List<HtmlColumn> columns, Object rowObject) {
        try {
            ArrayList<String> row = new ArrayList<String>(columns.size());
            StringListResponseWriter writer = new StringListResponseWriter(row);
            FacesContext facesContext = TableExportELResolver.createWrappedFacesContext();
            facesContext.setResponseWriter((ResponseWriter)writer);
            TableExportELResolver.activate(tableVar, rowObject);
            int columnCount = 0;
            for (HtmlColumn column : columns) {
                ++columnCount;
                for (UIComponent child : column.getChildren()) {
                    try {
                        TableExportELResolver.writeContent(row, writer, facesContext, columnCount, child);
                    }
                    catch (Exception e) {
                        LOG.warning(String.format("Could not encode child %s with clientId %s", child.getClass(), child.getId()));
                        try {
                            writer.writeText(EXPORT_ERROR_TEXT, "");
                        }
                        catch (IOException e1) {
                            LOG.warning(String.format("Could not encode child %s with clientId %s", child.getClass(), child.getId()));
                        }
                    }
                }
                if (columnCount <= row.size()) continue;
                row.add("");
            }
            ArrayList<String> arrayList = row;
            return arrayList;
        }
        finally {
            TableExportELResolver.deactivate();
        }
    }

    private static void writeContent(List<String> row, StringListResponseWriter writer, FacesContext facesContext, int columnCount, UIComponent child) throws IOException {
        if (child instanceof HtmlCommandLink) {
            HtmlOutputLabel label = new HtmlOutputLabel();
            label.setValue(((HtmlCommandLink)child).getValue());
            label.setRendered(child.isRendered());
            label.encodeBegin(facesContext);
            label.encodeEnd(facesContext);
        } else if (child instanceof HtmlGraphicImage) {
            writer.writeText("", "");
        } else if (child instanceof HtmlPanelGroup || child instanceof HtmlOutputLink) {
            UIComponentBase uiComponent = (UIComponentBase)child;
            if (uiComponent.isRendered()) {
                for (UIComponent uiChildComponent : uiComponent.getChildren()) {
                    TableExportELResolver.writeContent(row, writer, facesContext, columnCount, uiChildComponent);
                }
            }
            TableExportELResolver.postCleanUp(row, columnCount);
        } else {
            child.encodeBegin(facesContext);
            child.encodeEnd(facesContext);
        }
    }

    private static void postCleanUp(List<String> row, int columnCount) {
        int i;
        ArrayList<Integer> indexToDelete = new ArrayList<Integer>();
        for (i = columnCount - 1; i < row.size(); ++i) {
            String s = row.get(i);
            if (s != null && !StringUtils.isEmpty(s.trim())) continue;
            indexToDelete.add(i);
        }
        for (i = indexToDelete.size() - 1; i >= 0; --i) {
            row.remove((Integer)indexToDelete.get(i));
        }
    }

    public static void activate(String key, Object value) {
        KEY_VALUE.set(new CurrentInstance(key, value));
    }

    public static void deactivate() {
        KEY_VALUE.remove();
    }

    public Object getValue(ELContext context, Object base, Object property) {
        CurrentInstance currentInstance = KEY_VALUE.get();
        if (currentInstance == null) {
            return null;
        }
        return this.internalGetValue(context, base, property, currentInstance);
    }

    private Object internalGetValue(ELContext context, Object base, Object property, CurrentInstance currentInstance) {
        if (base == null && property != null && property.equals(currentInstance.key)) {
            context.setPropertyResolved(true);
            return currentInstance.value;
        }
        return null;
    }

    private static FacesContext createWrappedFacesContext() {
        return new FacesContextWrapper(){
            private ResponseWriter responseWriter;

            public FacesContext getWrapped() {
                return FacesContext.getCurrentInstance();
            }

            public ResponseWriter getResponseWriter() {
                return this.responseWriter;
            }

            public void setResponseWriter(ResponseWriter responseWriter) {
                this.responseWriter = responseWriter;
            }
        };
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        CurrentInstance currentInstance = KEY_VALUE.get();
        if (currentInstance == null) {
            return null;
        }
        Object value = this.internalGetValue(context, base, property, currentInstance);
        return value != null ? value.getClass() : null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return true;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return null;
    }

    private static class CurrentInstance {
        private final String key;
        private final Object value;

        protected CurrentInstance(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

