/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.renderkit.html_basic.text;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;
import org.butterfaces.component.base.renderer.HtmlBasicRenderer;
import org.butterfaces.component.behavior.JsfAjaxRequest;
import org.butterfaces.component.html.tree.HtmlTree;
import org.butterfaces.component.partrenderer.RenderUtils;
import org.butterfaces.component.renderkit.html_basic.text.model.CachedNodesInitializer;
import org.butterfaces.component.renderkit.html_basic.text.part.TrivialComponentsEntriesNodePartRenderer;
import org.butterfaces.context.StringHtmlEncoder;
import org.butterfaces.event.TreeNodeExpansionListener;
import org.butterfaces.event.TreeNodeSelectionEvent;
import org.butterfaces.event.TreeNodeSelectionListener;
import org.butterfaces.model.tree.Node;
import org.butterfaces.resolver.ClientBehaviorResolver;
import org.butterfaces.resolver.MustacheResolver;
import org.butterfaces.resolver.WebXmlParameters;
import org.butterfaces.util.StringUtils;

@FacesRenderer(componentFamily="org.butterfaces.component.family", rendererType="org.butterfaces.renderkit.html_basic.TreeRenderer")
public class TreeRenderer
extends HtmlBasicRenderer {
    public static final String DEFAULT_NODES_TEMPLATE = "<div class=\"tr-template-icon-2-lines tr-tree-entry filterable-item {{styleClass}}\">  <div class=\"img-wrapper {{imageClass}}\" style=\"{{imageStyle}}\"></div>  <div class=\"content-wrapper tr-editor-area\">     <div class=\"main-line\">{{title}}</div>     <div class=\"additional-info\">{{description}}</div>  </div></div>";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlTree tree = (HtmlTree)component;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)tree);
        this.writeIdAttribute(context, writer, component);
        String styleClass = tree.getStyleClass();
        writer.writeAttribute("class", (Object)(StringUtils.isNotEmpty(styleClass) ? "butter-component-tree " + styleClass : "butter-component-tree"), "class");
        String style = tree.getStyle();
        if (StringUtils.isNotEmpty(style)) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.startElement("input", (UIComponent)tree);
        if (StringUtils.isNotEmpty(tree.getPlaceholder())) {
            writer.writeAttribute("placeholder", (Object)tree.getPlaceholder(), null);
        }
        writer.writeAttribute("class", (Object)"butter-component-tree-original-input", null);
        writer.endElement("input");
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        HtmlTree tree = (HtmlTree)component;
        Node rootNode = tree.getValue();
        List<Node> nodes = this.createNodesMap(tree, rootNode);
        Map<Integer, Node> nodesMap = CachedNodesInitializer.createNodesMap(nodes);
        ResponseWriter writer = context.getResponseWriter();
        List<String> mustacheKeys = this.createMustacheKeys(context, tree);
        String uniqueComponentId = tree.getClientId().replace(":", "_");
        String jQueryBySelector = RenderUtils.createJQueryBySelector(component.getClientId(), "input");
        Integer selectedNodeNumber = this.getSelectedNodeNumber(tree, nodesMap);
        if (selectedNodeNumber != null) {
            this.openPathToNode(nodesMap.get(selectedNodeNumber), tree.getNodeExpansionListener(), nodesMap);
        }
        writer.startElement("script", component);
        writer.writeText((Object)"jQuery(function () {\n", null);
        writer.writeText((Object)("var entries_" + uniqueComponentId + " = " + new TrivialComponentsEntriesNodePartRenderer().renderEntriesAsJSON(nodes, mustacheKeys, nodesMap) + ";\n"), null);
        writer.writeText((Object)("var trivialTagsOptions" + uniqueComponentId + " = " + this.createTreeOptions(tree, context, selectedNodeNumber) + ";\n"), null);
        writer.writeText((Object)("var trivialTree" + uniqueComponentId + " = ButterFaces.createTrivialTreeComponent(" + jQueryBySelector + ",trivialTagsOptions" + uniqueComponentId + ");\n"), null);
        this.encodeAjaxEvent(tree, writer, "trivialTree" + uniqueComponentId, "click", "onSelectedEntryChanged");
        this.encodeAjaxEvent(tree, writer, "trivialTree" + uniqueComponentId, "toggle", "onNodeExpansionStateChanged");
        writer.writeText((Object)"});", null);
        writer.endElement("script");
        writer.endElement("div");
    }

    private String createTreeOptions(HtmlTree tree, FacesContext context, Integer selectedNodeNumber) throws IOException {
        StringBuilder options = new StringBuilder();
        String searchBarMode = this.determineSearchBarMode(tree);
        WebXmlParameters webXmlParameters = new WebXmlParameters(context.getExternalContext());
        String noMatchingText = StringUtils.getNotNullValue(tree.getNoEntriesText(), webXmlParameters.getNoEntriesText());
        String spinnerText = StringUtils.getNotNullValue(tree.getSpinnerText(), webXmlParameters.getSpinnerText());
        options.append("{");
        options.append("\n    searchBarMode: '" + searchBarMode + "',");
        if (selectedNodeNumber != null) {
            options.append("\n    selectedEntryId: '" + selectedNodeNumber + "',");
        }
        if (tree.getToManyVisibleItemsRenderDelay() != null || tree.getToManyVisibleItemsThreshold() != null) {
            options.append("\n    performanceOptimizationSettings: {");
            if (tree.getToManyVisibleItemsRenderDelay() != null) {
                options.append("\n        toManyVisibleItemsRenderDelay: " + tree.getToManyVisibleItemsRenderDelay() + ",");
            }
            if (tree.getToManyVisibleItemsThreshold() != null) {
                options.append("\n        toManyVisibleItemsThreshold: " + tree.getToManyVisibleItemsThreshold() + ",");
            }
            options.append("\n    },");
        }
        if (tree.getFacet("template") != null) {
            String encodedTemplate = StringHtmlEncoder.encodeComponentWithSurroundingDiv(context, tree.getFacet("template"));
            options.append("\n    templates: ['" + encodedTemplate + "'],");
        } else {
            options.append("\n    templates: ['<div class=\"tr-template-icon-2-lines tr-tree-entry filterable-item {{styleClass}}\">  <div class=\"img-wrapper {{imageClass}}\" style=\"{{imageStyle}}\"></div>  <div class=\"content-wrapper tr-editor-area\">     <div class=\"main-line\">{{title}}</div>     <div class=\"additional-info\">{{description}}</div>  </div></div>'],");
        }
        options.append("\n    spinnerTemplate: '<div class=\"tr-default-spinner\"><div class=\"spinner\"></div><div>" + spinnerText + "</div></div>',");
        options.append("\n    noEntriesTemplate: '<div class=\"tr-default-no-data-display\"><div>" + noMatchingText + "</div></div>',");
        options.append("\n    entries: entries_" + tree.getClientId().replace(":", "_"));
        options.append("\n}");
        return options.toString();
    }

    private List<Node> createNodesMap(HtmlTree tree, Node rootNode) {
        return tree.isHideRootNode() ? rootNode.getSubNodes() : Arrays.asList(rootNode);
    }

    private List<String> createMustacheKeys(FacesContext context, HtmlTree tree) throws IOException {
        if (tree.getFacet("template") != null) {
            String encodedTemplate = StringHtmlEncoder.encodeComponentWithSurroundingDiv(context, tree.getFacet("template"));
            return MustacheResolver.getMustacheKeysForTreeNode(encodedTemplate);
        }
        return Collections.emptyList();
    }

    private void encodeAjaxEvent(HtmlTree tree, ResponseWriter writer, String variableName, String eventName, String trivialCallback) throws IOException {
        AjaxBehavior ajaxBehavior = ClientBehaviorResolver.findFirstActiveAjaxBehavior(tree, eventName);
        if (ajaxBehavior != null) {
            writer.writeText((Object)(variableName + "." + trivialCallback + ".addListener(function(node) {"), null);
            String ajaxRequest = new JsfAjaxRequest(tree.getClientId(), true).setEvent(eventName).setRender(tree, eventName).setParams("node.id").addOnEventHandler(ajaxBehavior.getOnevent()).addOnErrorHandler(ajaxBehavior.getOnerror()).setBehaviorEvent(eventName).toString();
            writer.writeText((Object)ajaxRequest, null);
            writer.writeText((Object)"});", null);
        }
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        HtmlTree tree = (HtmlTree)component;
        TreeNodeSelectionListener nodeSelectionListener = tree.getNodeSelectionListener();
        TreeNodeExpansionListener nodeExpansionListener = tree.getNodeExpansionListener();
        Map behaviors = tree.getClientBehaviors();
        if (behaviors.isEmpty()) {
            return;
        }
        Node rootNode = tree.getValue();
        List<Node> nodes = this.createNodesMap(tree, rootNode);
        Map<Integer, Node> nodesMap = CachedNodesInitializer.createNodesMap(nodes);
        ExternalContext external = context.getExternalContext();
        Map params = external.getRequestParameterMap();
        String behaviorEvent = (String)params.get("javax.faces.behavior.event");
        if (behaviorEvent != null && "click".equals(behaviorEvent)) {
            try {
                Integer nodeNumber = Integer.valueOf((String)params.get("params"));
                Node node = nodesMap.get(nodeNumber);
                if (nodeSelectionListener != null) {
                    Integer selectedNodeNumber = this.getSelectedNodeNumber(tree, nodesMap);
                    Node selectedNode = selectedNodeNumber != null ? nodesMap.get(selectedNodeNumber) : null;
                    nodeSelectionListener.processValueChange(new TreeNodeSelectionEvent(selectedNode, node));
                }
            }
            catch (NumberFormatException nodeNumber) {}
        } else if (behaviorEvent != null && "toggle".equals(behaviorEvent)) {
            try {
                Integer nodeNumber = Integer.valueOf((String)params.get("params"));
                Node cachedNode = nodesMap.get(nodeNumber);
                if (cachedNode != null) {
                    if (cachedNode.isCollapsed()) {
                        cachedNode.setCollapsed(false);
                        if (nodeExpansionListener != null) {
                            nodeExpansionListener.expandNode(cachedNode);
                        }
                    } else {
                        cachedNode.setCollapsed(true);
                        if (nodeExpansionListener != null) {
                            nodeExpansionListener.collapseNode(cachedNode);
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void openPathToNode(Node node, TreeNodeExpansionListener nodeExpansionListener, Map<Integer, Node> nodesMap) {
        Node parent = this.getParent(node, nodesMap);
        if (parent != null) {
            if (parent.isCollapsed()) {
                parent.setCollapsed(false);
                if (nodeExpansionListener != null) {
                    nodeExpansionListener.expandNode(node);
                }
            }
            this.openPathToNode(parent, nodeExpansionListener, nodesMap);
        }
    }

    private Node getParent(Node child, Map<Integer, Node> nodesMap) {
        for (Node node : nodesMap.values()) {
            if (!node.getSubNodes().contains(child)) continue;
            return node;
        }
        return null;
    }

    private String determineSearchBarMode(HtmlTree tree) {
        if ("show-if-filled".equals(tree.getSearchBarMode())) {
            return "show-if-filled";
        }
        if ("always-visible".equals(tree.getSearchBarMode())) {
            return "always-visible";
        }
        return "none";
    }

    private Integer getSelectedNodeNumber(HtmlTree tree, Map<Integer, Node> nodesMap) {
        if (tree.getNodeSelectionListener() != null) {
            for (Integer nodeNumber : nodesMap.keySet()) {
                Node node = nodesMap.get(nodeNumber);
                if (!tree.getNodeSelectionListener().isValueSelected(node)) continue;
                return nodeNumber;
            }
        }
        return null;
    }
}

